/*
 * (C) Copyright Keith Visco 1998, 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package xslp.xml.parsers;

import org.w3c.dom.*;
import org.xml.sax.*;
import com.ibm.xml.framework.*;
import com.ibm.xml.parsers.*;
      
import java.io.Reader;
import java.io.PrintWriter;
/**
 * Creates a DOM Package for use with IBM's XML4J 2.x package
 * @author <A HREF="mailto:kvisco@ziplink.net">Keith Visco</A>
 * @author <A HREF="mailto:casa@sdv.fr">Michel Casabianca</A>
**/
public class XML4J_2xParser implements com.kvisco.xml.parser.DOMPackage {

    private NonValidatingDOMParser parser = null;    
    private boolean validate = false;
    
    //----------------/    
    //- Constructors -/
    //----------------/    
    
    /**
     * Instantiate parser
     */
    public XML4J_2xParser() {
	    initParser();
    } //-- XML4J_2xParser

    /**
     * Instantiate parser and read catalog
     *
     */
    private void initParser() {
	    if (validate)
	        parser = new DOMParser();
	    else 
	        parser = new NonValidatingDOMParser();
    	            
	    parser.setExpandEntityReferences(true);
	    parser.setNodeExpansion(NonValidatingDOMParser.FULL);
	    // casa: create a simple catalog
	    SimpleCatalog catalog=new 
	        SimpleCatalog(System.getProperty("xml.catalog"));
	    parser.getEntityHandler().setEntityResolver(catalog);
    } //-- initParser
    
    //---------------------------------------------------/    
    //- Interfaces for com.kvisco.xml.parser.DOMPackage -/
    //---------------------------------------------------/    

    /**
     * Creates a DOM DocumentType using the DOM package of this DOMReader
     * @return the new DocumentType
     **/
    public void setDocumentType(Document document, String systemId) {
        
    } //-- setDocumentType
    
    /**
     * Sets whether or not to Validate the Document
     * @param validate a boolean indicating whether or not to
     * validate the Document
     **/
    public void setValidation(boolean validate) {
	    // casa: reinit the parser if necessary
	    if(this.validate!=validate) {
	        this.validate = validate;
	        initParser();
	    }
    } //-- setValidation
    
    /**
     * Creates a DOM Document 
     * @return the new Document
     **/
    public Document createDocument() {
        return new com.ibm.xml.dom.DocumentImpl();
    } //-- createDocument
    
    /**
     * Reads an XML Document from the given Reader
     * @param reader the Reader for reading the XML stream
     * @param filename
     * @param errorWriter the PrintWriter to write all errors to
     **/
    public Document readDocument
        (Reader reader, String filename, PrintWriter errorWriter) 
    {
	    Document doc = null;
	    try {
	        InputSource is = new InputSource(reader);
	        is.setSystemId(filename); //-- important for resolving paths
	        parser.parse(is);
	        doc = parser.getDocument();
	    }
	    catch (Exception ex) {
	        errorWriter.println("error while trying to read document.");
	        errorWriter.println(" - " + ex.getMessage());
	        errorWriter.flush();
	    }
        return doc;
		
    } //-- readDocument
    
} //-- DOMParser

