// curses++.cc
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  A few initialization routines and so on.

#include "curses++.h"

#include <stdarg.h>

#include <string>

//  Note: resize handling is *really* nasty.  REALLY nasty.  I mean it. :)

#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/ioctl.h>

cwindow rootwin=NULL;

void init_curses()
{
  rootwin=initscr();

  cbreak();
  noecho();
  nonl();
  intrflush(stdscr,FALSE);
  keypad(stdscr,TRUE);

  start_color();
}

void resize()
{
  int fd;

  if( (fd=open("/dev/tty",O_RDONLY)!=-1))
    {
      struct winsize w;
      if(ioctl(fd, TIOCGWINSZ, &w)!=-1)
	{
	  resizeterm(w.ws_row,w.ws_col);
	  return;
	}
      else
	{
	  beep();
	  perror("ioctl");
	}
      close(fd);
    }
  else
    {
      beep();
      perror("open");
    }
}

int cwindow::printw(char *str, ...)
{
  va_list args;
  int amt;

  va_start(args, str);
  amt=vwprintw(win, str, args);
  va_end(args);

  return amt;
}

void cwindow::show_string_as_progbar(int x, int y, string s, int attr1, int attr2, int size1, int totalsize)
{
  int width,height;

  getmaxyx(height,width);

  attrset(attr1);
  move(y, x);

  for(int i=0; i<totalsize; i++)
    {
      if(i==size1)
	attrset(attr2);

      if(((unsigned int) i)<s.size())
	// -- make the compiler happy about signed and unsigned stuff.
	addch(s[i]);
      else
	addch(' ');
    }
}

void cwindow::display_header(string s, int attr)
  // Y'know, this could be just a call to show_as_progbar or whatever I called
  // it..
{
  attrset(attr);

  int width,height;
  getmaxyx(height,width);

  move(0,0);
  for(int i=0; i<width; i++)
    addch(' ');

  mvaddnstr(0,0,s.c_str(),width);
}

void cwindow::display_status(string s, int attr)
{
  attrset(attr);

  int width,height;
  getmaxyx(height,width);

  move(height-1,0);
  for(int i=0; i<width; i++)
    addch(' ');

  mvaddnstr(height-1,0,s.c_str(),width);
}
