
#ifndef _interface_captris_H
#define _interface_captris_H

#define NUM_TYPES 7
#define BOARD_WIDTH 18
#define BOARD_HEIGHT 14

class pkgAcquireInterface;

class Captris
{ private:
	pkgAcquireInterface * Owner;

	static char board[BOARD_HEIGHT][BOARD_WIDTH + 1];
	static char penta[NUM_TYPES][4][4][5];

	int ctype;
	int crot;
	int ntype;
	int nrot;
	long score;
	long level;
	int cx;
	int cy;
	long advance_us;

	int waitcount;
	bool paused;

	int collision(int, int, int, int);
	void add_to_board(int, int, int, int);
	void clear_board();
	void check_lines();
	int advance_y(int wait);
	void generate_new_penta();
	void init_draw();
	void text_draw();
	void draw();

      public:
	void handlekey(int);
	void initiate();
	void pulse();

	 Captris(pkgAcquireInterface *);
	~Captris();
};

#endif // _interface_captris_H
