/* gnome-drud-page-standard.h
 * Copyright (C) 1999  Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GNOME_DRUD_PAGE_STANDARD_H__
#define __GNOME_DRUD_PAGE_STANDARD_H__

#include <gtk/gtk.h>
#include <gdk_imlib.h>
#include "libgnomeui/gnome-canvas.h"
#include "gnome-drud-page.h"

BEGIN_GNOME_DECLS

#define GNOME_TYPE_DRUD_PAGE_STANDARD			(gnome_drud_page_standard_get_type ())
#define GNOME_DRUD_PAGE_STANDARD(obj)			(GTK_CHECK_CAST ((obj), GNOME_TYPE_DRUD_PAGE_STANDARD, GnomeDrudPageStandard))
#define GNOME_DRUD_PAGE_STANDARD_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_DRUD_PAGE_STANDARD, GnomeDrudPageStandardClass))
#define GNOME_IS_DRUD_PAGE_STANDARD(obj)			(GTK_CHECK_TYPE ((obj), GNOME_TYPE_DRUD_PAGE_STANDARD))
#define GNOME_IS_DRUD_PAGE_STANDARD_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GNOME_TYPE_DRUD_PAGE_STANDARD))


typedef struct _GnomeDrudPageStandard       GnomeDrudPageStandard;
typedef struct _GnomeDrudPageStandardClass  GnomeDrudPageStandardClass;

struct _GnomeDrudPageStandard
{
	GnomeDrudPage parent;

	GtkWidget *vbox;
	GdkColor background_color;
	GdkColor logo_background_color;
	GdkColor title_color;
	GdkImlibImage *logo_image;

	gchar *title;
	
	/*< private >*/
	GtkWidget *canvas;
	GtkWidget *side_bar;
	GnomeCanvasItem *logoframe_item;
	GnomeCanvasItem *logo_item;
	GnomeCanvasItem *title_item;
	GnomeCanvasItem *background_item;
};
struct _GnomeDrudPageStandardClass
{
	GnomeDrudPageClass parent_class;
};


GtkType    gnome_drud_page_standard_get_type      (void);
GtkWidget *gnome_drud_page_standard_new           (void);
GtkWidget *gnome_drud_page_standard_new_with_vals (const gchar *title, GdkImlibImage *logo);
void gnome_drud_page_standard_set_bg_color        (GnomeDrudPageStandard *drud_page_standard,
						    GdkColor *color);
void gnome_drud_page_standard_set_logo_bg_color   (GnomeDrudPageStandard *drud_page_standard,
						    GdkColor *color);
void gnome_drud_page_standard_set_title_color     (GnomeDrudPageStandard *drud_page_standard,
						    GdkColor *color);
void gnome_drud_page_standard_set_title           (GnomeDrudPageStandard *drud_page_standard,
						    const gchar *title);
void gnome_drud_page_standard_set_logo            (GnomeDrudPageStandard *drud_page_standard,
						    GdkImlibImage *logo_image);

END_GNOME_DECLS

#endif /* __GNOME_DRUD_PAGE_STANDARD_H__ */

