#include <stdio.h>
extern "C" {
	#include <gd.h>
	#include <gdfontmb.h>
}


void button_text2png (const char *str, FILE *fout)
{
	gdImagePtr gd = gdImageCreate (100,30);
	int white = gdImageColorAllocate (gd,255,255,255);
	int black = gdImageColorAllocate (gd,0,0,0);
	int gray80 = gdImageColorAllocate (gd,150,150,150);

	gdImageFilledRectangle (gd,0,0,99,29,gray80);
	gdImageRectangle (gd,0,0,99,29,black);
	gdImageRectangle (gd,1,1,98,28,black);

	gdImageLine (gd,0,0,0,29,white);
	gdImageLine (gd,0,0,99,0,white);
	gdImageLine (gd,1,1,1,28,white);
	gdImageLine (gd,1,1,98,1,white);

	int len = strlen (str);
	int halfwidth = (len/2)*7;
	if ((len & 1) != 0) halfwidth += 4;
	gdImageString (gd,gdFontMediumBold,(100/2)-halfwidth,10,(unsigned char*)str,black);

	gdImagePng (gd,fout);
}

#ifdef TEST

int main (int argc, char *argv[])
{
	if (argc != 2){
		fprintf (stderr,"string to build the button\n");
	}else{
		FILE * fout = fopen ("/tmp/toto.png","w");
		button_text2png (argv[1],fout);
		fclose (fout);
		printf ("/tmp/toto.png was generated\n");
	}
	return 0;
}

#endif
