#!/bin/sh
# diffdoc.sh
# produce a diff file by comparing to linuxconf documentation
# directory
# You must give the version ID of the original and
# the version ID of the new one
# For example, if you start from 1.9r22, you
# untar linuxconf-1.9r22 and then you create a work copy
#     cp -a linuxconf-1.9r22 linuxconf-19r22.new
# and then you edit files in linuxconf-1.9r22.new
#
# the argument of this scripts are
# diffdoc.sh 1.9r22 1.9r22.new
# The output goes in /tmp/diffdoc-1.9r22-1.9r22.new
if [ $# != 2 ] ; then
	echo diffdoc.sh 1.9r22 1.9r22.new
elif [ ! -d linuxconf-$1 ] ; then
	echo linuxconf-$1 does not exist
elif [ ! -d linuxconf-$2 ] ; then
	echo linuxconf-$2 does not exist
else
	diff -rc2P \
		-x \*.o -x \*.a -x \*.bak -x \*~ \
		-x \*.old \
		-x \*.html \
		-x \*.help \
		linuxconf-$1/help.files linuxconf-$2/help.files \
			>/tmp/diffdoc-$1-$2
fi

