/* ***********

	Check comments starting with // ### and fill appropriate code there

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include "inittab.h"
#include "inittab.m"

MODULE_DEFINE_VERSION(inittab);

PUBLIC MODULE_inittab::MODULE_inittab()
	: LINUXCONF_MODULE("inittab")
{
	linuxconf_loadmsg ("inittab",PACKAGE_REV);
	module_register_api ("inittab",1,inittab_api_get,inittab_api_release);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_inittab::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MISCSERV){
		keymenu = MSG_U(M_inittab,"Initial system services");
		dia.new_menuitem ("inittab","",keymenu);
	}
}

PUBLIC int MODULE_inittab::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MISCSERV){
		if (key == keymenu){
			inittab_menu();
		}
	}
	return 0;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module inittab\n"
		 "\n"
		 "    --setdefaultlevel default_runlevel\n")
		);
}

PUBLIC void MODULE_inittab::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_inittab::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"inittab")==0){
		ret = -1;
		if (argc == 1){
			inittab_menu();
		}else if (argc == 3 && strcmp(argv[1],"--setdefaultlevel")==0){
			ret = inittab_setdefaultlevel(atoi(argv[2]));
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_inittab inittab;

