#pragma implementation
#include "internal.h"
#include <subsys.h>
#include <translat.h>
#include "uucp.m"

const char subsys_uucp[]="uucp";

static LINUXCONF_SUBSYS subb (subsys_uucp
	,P_MSG_U(M_UUCPSYS,"Unix To Unix copy (UUCP)"));


PUBLIC CONFIG_OBJS::CONFIG_OBJS (CONFIG_FILE &_f)
	: f(_f)
{
}

/*
	Read all records from the Permissions file
	Return -1 if any error
*/
PUBLIC int CONFIG_OBJS::read()
{
	int ret = -1;
	FILE *fin = f.fopen ("r");
	if (fin != NULL){
		char buf[3000];
		SSTRING comments;
		ret = 0;
		while (fgets_comments(buf,sizeof(buf)-1,fin,comments)!=NULL){
			char err[10000];
			add (newobj(buf,comments,err));
			if (err[0] != '\0') ret = -1;
		}
		fclose (fin);
		if (getnb()==0){
			first_comment.setfrom (comments);
		}else{
			last_comment.setfrom (comments);
		}
	}
	rstmodified();
	return ret;
}

PRIVATE CONFIG_OBJ *CONFIG_OBJS::getitem (int no)
{
	return (CONFIG_OBJ*)ARRAY::getitem(no);
}

/*
	Write all records from the Poll file
*/
PUBLIC int CONFIG_OBJS::write()
{
	int ret = -1;
	FILE *fout = f.fopen ("w");
	if (fout != NULL){
		comment_write (first_comment,fout);
		int n = getnb();
		for (int i=0; i<n; i++) getitem(i)->write (fout);
		comment_write (last_comment,fout);
		ret = fclose (fout);
		rstmodified();
	}
	return ret;
}

