/* #Specification: translation / msgupd / intro
	the msgupd utility update translated dictionaries
	using the dictionaries extracted from the C++ sources.
*/
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <sys/stat.h>
#include <errno.h>
#include "internal.h"

#ifdef UNIX
	#define MAXIMUM_PATH	PATH_MAX
#else
	#define MAXIMUM_PATH	128
#endif

/*
	Print an error message in a popup
	Stubs to avoid linking the world
*/
void xconf_error (const char *msg, ...)
{
	va_list list;
	va_start (list,msg);
	vfprintf (stderr,msg,list);
	va_end (list);
}

static int msgupd_exist (const char *path)
{
	struct stat st;
	return stat(path,&st)!= -1;
}

static int msgupd_do (
	const char *srcpath,
	const char *dstpath,
	const char *dict,
	char lang)
{
	int ret = -1;
	char path[PATH_MAX];
	sprintf (path,"%s%s.dic",srcpath,dict);
	if (!msgupd_exist (path)){
		fprintf (stderr,"Dictionary %s does not exist\n",path);
	}else{		
		TR_STRINGS src;
		if (src.read(path)!=-1){
			if (src.getnb() == 0){
				fprintf (stderr,"Dictionary %s is empty\n",path);
			}else{
				sprintf (path,"%s%s.dic",dstpath,dict);
				TR_STRINGS dst;
				dst.read (path);
				int n = src.getnb();
				printf ("Processing dictionary %s\n",dict);
				for (int i=0; i<n; i++){
					TR_STRING *s = src.getitem(i);
					const char *id = s->getid();
					TR_STRING *d = dst.getitem(id);
					if (d == NULL){
						// New message
						d = new TR_STRING (id);
						dst.add (d);
					}
					const char *sm = s->getmsg(lang);
					LANG_STRING *dm = d->gettranslation(lang);
					if (sm == NULL){
					}else if (dm == NULL){
						d->settranslation (lang,sm);
						d->add2comment ("# *** new message\n");
					}else if (dm->str.cmp(sm)!=0){
						dm->lang = 'Z';
						d->settranslation (lang,sm);
						d->add2comment ("# *** updated message\n");
					}
				}
				ret = 0;
				if (dst.was_modified()){
					printf ("\tSome work to do in dictionary %s\n",dict);
					ret = dst.write_mod (path);
				}
			}
		}
	}
	return ret;
}


int main (int _argc, char *_argv[])
{
	char *argv[200];
	int argc = anlparm (_argc,_argv,argv);
	int ret = -1;
	if (argc < 5){
		fprintf (stderr,"msgupd -spath -dpath -rlang dictionary ...\n");
	}else{
		ret = 0;
		const char *srcpath = NULL;
		const char *dstpath = NULL;
		char lang = 'E';
		for (int a=1; a<argc; a++){
			char *arg = argv[a];
			if (arg[0] == '-'){
				if (arg[1] == 's'){
					if (arg[2] == '\0'){
						a++;
						srcpath = argv[a];
					}else{
						srcpath = arg+2;
					}
				}else if (arg[1] == 'd'){
					if (arg[2] == '\0'){
						a++;
						dstpath = argv[a];
					}else{
						dstpath = arg+2;
					}
				}else if (arg[1] == 'r'){
					if (arg[2] == '\0'){
						a++;
						lang = argv[a][0];
					}else{
						lang = arg[2];
					}
				}else{
					fprintf (stderr,"Invalid option %s\n",arg);
					ret = -1;				
				}
			}else if (dstpath == NULL || srcpath == NULL){
				fprintf (stderr,"Can't process dictionary %s\n"
					"Both -d and -s are needed\n",arg);
				ret = -1;				
			}else if (ret == 0){
				ret = msgupd_do (srcpath,dstpath,arg,lang);
			}
		}
	}
	return ret;
}


