/*
 * tools/lib/vg_check_active.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March,November 1997
 * September 1999
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    11/08/97 - minor cleanup
 *    11/09/97 - vg_check_active_all_vg - avoided name based loop
 *    29/10/1999 - fixed possible free() bug
 *
 */

#include <liblvm.h>

int vg_check_active ( char *vg_name) {
   int ret = 0;
   vg_t *vg;

#ifdef DEBUG
   debug ( "vg_check_active -- CALLED\n");
#endif

   if ( vg_name == NULL || vg_check_name ( vg_name) < 0) return -LVM_EPARAM;

   if ( ( ret = vg_status ( vg_name, &vg)) == 0) {
      if ( vg->vg_status & VG_ACTIVE) ret = TRUE;
      else                            ret = FALSE;
   }

#ifdef DEBUG
   debug ( "vg_check_active -- LEAVING\n");
#endif
   return ret;
}


char **vg_check_active_all_vg ( void) {
   int i = 0;
   int ret = 0;
   int vg_count = 0;
   char *vg_names = NULL;
   char **vg_name_ptr_sav = NULL;
   static char **vg_name_ptr = NULL;

#ifdef DEBUG
   debug ( "vg_check_active_all_vg -- CALLED\n");
#endif

   if ( ( vg_count = vg_status_get_count ()) < 1)
      ret = -LVM_EVG_CHECK_ACTIVE_ALL_VG_COUNT;
   if ( ( vg_names = malloc ( vg_count * NAME_LEN)) == NULL) {
      fprintf ( stderr, "malloc error in %s [line %d]\n",
                        __FILE__, __LINE__);
      ret = -LVM_EVG_CHECK_ACTIVE_ALL_VG_MALLOC;
   } else if ( ( ret = vg_status_get_namelist ( vg_names)) < 0)
      ret = -LVM_EVG_CHECK_ACTIVE_ALL_VG_NAMELIST;
   else {
      for ( i = 0; i < vg_count; i++) {
         vg_name_ptr_sav = vg_name_ptr;
         if ( ( vg_name_ptr = realloc ( vg_name_ptr,
                                       ( i + 2) * sizeof ( char*))) == NULL) {
            fprintf ( stderr, "realloc error in %s [line %d]\n",
                              __FILE__, __LINE__);
            free ( vg_name_ptr_sav);
            free ( vg_names);
            ret = -1;
         } else vg_name_ptr_sav = NULL;
         vg_name_ptr[i] = &vg_names[i*NAME_LEN];
      }
      if ( vg_count > 0 && ret == 0) vg_name_ptr[i] = NULL;
   }

#ifdef DEBUG
   debug ( "vg_check_active_all_vg -- LEAVING\n");
#endif
   if ( ret == 0) return vg_name_ptr;
   else           return NULL;
}
