/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

#include "common/common.h"

#include "gs_token.h"
#include "gs_list.h"
#include "gs_translate.h"
#include "gs_parser.h"

#include "gs_getdict.h"
#include "gs_getlist.h"

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
TOKEN *gs_get_list_element(TOKEN *item, int index)
{
	return NULL;
}

/* -------------------------------------------------------------------- */
/* Return Value:							*/
/*									*/
/*	The numbers of items in the list or				*/
/*	-1 to inidicate and error.					*/
/* -------------------------------------------------------------------- */
int gs_get_list_length(TOKEN *item)
{
	TOKEN	*token;
	TOKEN_LIST
		*eptr;

	int 	len;


	len = 0;


	eptr = NULL;
	while ((token = gs_get_list_next(item, &eptr)) != NULL)
	{
		if (! gs_isdata(token))
		{
			len++;
		}


		if (eptr == NULL)
		{
			break;
		}
	}

	if (eptr != NULL)
	{
		return -1;
	}

	return len;
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
TOKEN *gs_get_list_next(TOKEN *item, TOKEN_LIST **ptr)
{
	TOKEN_HEAP 
		*heap;
	TOKEN_LIST	
		*list;
	TOKEN	*token;



	if (! gs_islist(item))
	{
		return NULL;
	}

	if (*ptr == NULL)
	{
		heap = (TOKEN_HEAP *)(item->ptr);
		if (heap == NULL)
		{
			return NULL;
		}

		list = (TOKEN_LIST *)(heap->list);
		if (list == NULL)
		{
			return NULL;
		}
	}
	else
	{	list = *ptr;
	}


	while ((list != NULL) && (gs_isdata(list->token)))
	{
		/* Skip ALL items which are simply	*/
		/* Data. We only want to return		*/
		/* 'Identifiers', 'Dictionaries' or 	*/
		/* 'Lists'				*/

		list = list->next;
	}

	token = list->token;
	if (token == NULL)
	{
		return NULL;
	}
	
	*ptr = list->next;
	return token;
}


