/************************************************************
*  Main function for the spk Tk interface
************************************************************/
#include "incall.h"
extern "C" {
#include "tk.h"
}

extern ConfigInfo conf;

int GSPK_Init(Tcl_Interp *interp);

int main(int argc, char** argv)
{
    if (argc == 2)
    {
       Tk_Main(argc, argv, Tcl_AppInit);
    } else
    {
       Tk_Window win;
       Tcl_Interp *interp;

//       Tcl_FindExecutable( argv[0] );

       interp = Tcl_CreateInterp();

       if (Tcl_AppInit(interp) != TCL_OK)
       {
         fprintf(stderr, "Could not init application: %s\n", interp->result);
       }

       win = Tk_MainWindow(interp);

       if (Tcl_EvalFile(interp, conf.GSPKPath) != TCL_OK)
       {
         fprintf(stderr, "Could not execute script: %s\n", interp->result);
       }

       Tk_MainLoop();
    }
    return 0;
}

/************************************************************
 * Tcl_AppInit - initialize tck,tk and spk packages
************************************************************/
int Tcl_AppInit(Tcl_Interp *interp)
{
    if (Tcl_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

 //   Tcl_StaticPackage(interp, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);

    if (GSPK_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }

    Tcl_SetVar(interp, "tcl_rcFileName", "~/.wishrc", TCL_GLOBAL_ONLY);
    return TCL_OK;
}

