/* -*- C++ -*- */
// $Id: FIFO_Recv.h,v 4.9 1999/07/05 09:52:51 nanbor Exp $

// ============================================================================
//
// = LIBRARY
//    ace
//
// = FILENAME
//    FIFO_Recv.h
//
// = AUTHOR
//    Doug Schmidt
//
// ============================================================================

#ifndef ACE_FIFO_RECV_H
#define ACE_FIFO_RECV_H

#include "ace/FIFO.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

class ACE_Export ACE_FIFO_Recv : public ACE_FIFO
{
  // = TITLE
  //    Receiver side of the bytestream C++ wrapper for UNIX
  //    FIFOs.
public:
  // = Initialization methods.
  ACE_FIFO_Recv (void);
  // Default constructor.

  ACE_FIFO_Recv (const ASYS_TCHAR *rendezvous,
                 int flags = O_CREAT | O_RDONLY,
                 int perms = ACE_DEFAULT_FILE_PERMS,
                 int persistent = 1,
                 LPSECURITY_ATTRIBUTES sa = 0);
  // Open up a bytestream named pipe for reading.

  int open (const ASYS_TCHAR *rendezvous,
            int flags = O_CREAT | O_RDONLY,
            int perms = ACE_DEFAULT_FILE_PERMS,
            int persistent = 1,
            LPSECURITY_ATTRIBUTES sa = 0);
  // Open up a bytestream named pipe for reading.

  int close (void);
  // Close down the named pipe.

  ssize_t recv (void *buf, size_t len);
  // Recv <buf> of up to <len> bytes.

  ssize_t recv_n (void *buf, size_t len);
  // Recv <buf> of exactly <len> bytes (block until done).

  void dump (void) const;
  // Dump the state of an object.

  ACE_ALLOC_HOOK_DECLARE;
  // Declare the dynamic allocation hooks.

private:
  ACE_HANDLE aux_handle_;
  // Auxiliary handle that is used to implement persistent FIFOs.
};

#if !defined (ACE_LACKS_INLINE_FUNCTIONS)
#include "ace/FIFO_Recv.i"
#endif

#endif /* ACE_FIFO_RECV_H */
