/* assert_.h -- wrapper for GCC's assert.h
   Copyright (C) 1997 Free Software Foundation, Inc.

This file is part of GNU Pascal.

GNU Pascal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Pascal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Pascal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _GPC_ASSERT_H_
#define _GPC_ASSERT_H_

/* @@@@ should we use system's <assert.h>, if existant ? */
/* No, see the comments in ../dwarfout.c */
/* #include "assert.h" */

#define assert(expression)  \
  ((void) ((expression) ? 0 : \
   (fprintf (stderr, "%s:%u: failed assertion `" #expression "'\n", __FILE__, __LINE__), abort (), 0)))

/* Old style GPC assert definition
 * To be phased out.
 */
#ifdef __STDC__
# define ASSERT(x, str) \
  if (! x) \
   printf("Assert failure at %s line %d : %s\n",__FILE__,__LINE__,str),abort();
#else
/* Thanks Doug! */
# define ASSERT(x, str) \
  if (! x) printf("Assert failure : %s\n", str),abort();
#endif

#endif /* _GPC_ASSERT_H_ */
