/*
Module/unit constructors. To be done by the compiler soon.

Copyright (C) 1991-99 Free Software Foundation, Inc.

This file is part of the GNU Pascal Library. The GNU Pascal
Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

The GNU Pascal Library is distributed in the hope that it will
be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.
If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "rts.h"

typedef struct contype {
  void (*fun)();
  int  run_id;
  struct contype *next;
} CONSTRUCTOR;

/* A list of saved constructors to be run */
CONSTRUCTOR *_p_c_list = (CONSTRUCTOR *) NULL;

/* This is set nonzero when the constructors are collected */
int _p_collect_flag = 1;

/* This is called by the compiler generated code from pascal module
 * initializers, each pass their own ADDRESS and a RUN_ID as argument.
 * RUN_ID's are obsolete. */
extern void _p_collect PROTO((void (*)(),int));
void
_p_collect (fun, run_id)
     void (* fun)();
     int run_id;
{
  CONSTRUCTOR *scan, *c = (CONSTRUCTOR *) malloc (sizeof (CONSTRUCTOR));
  if (! c)
    {
      fputs ("internal error: could not allocate storage for constructor\n", stderr);
      _exit (-1);
    }
  c->fun    = fun;
  c->run_id = run_id;
  c->next   = (CONSTRUCTOR *) NULL;
  if (!_p_c_list || run_id < _p_c_list->run_id)
    {
      /* Make this the first constructor */
      c->next = _p_c_list;
      _p_c_list = c;
    }
  else
    for (scan = _p_c_list; scan; scan = scan->next)
      {
        if (fun == scan->fun)
          {
            /* dynamic RTS linking currently can produce a duplicate
               constructor of gpc.pas -- it doesn't hurt much since the
               constructor does nothing, and the object file it's in is
               empty otherwise (19990307) */
            #if 1
            break;
            #else
            fputs ("internal error: duplicate constructor\n", stderr);
            _exit (-1);
            #endif
          }
        if (scan->run_id > run_id || !scan->next)
          { /* Append to current node */
            c->next = scan->next;
            scan->next = c;
            break;
          }
      }
}

/* Run the constructors collected and sorted to _p_c_list */
void
_p_run_constructors ()
{
  CONSTRUCTOR *scan = _p_c_list, *next;
  _p_collect_flag = 0;
  while (scan)
    {
      (*(scan->fun)) ();
      next = scan->next;
      free (scan);
      scan = next;
    }
  _p_c_list = (CONSTRUCTOR *) NULL;
}
