/* -*- c++ -*-
 *
 * $Copyright$
 *
 * $Id: debug-cc.h,v 6.1 1999/08/01 19:08:44 jsquyres Exp $
 *
 *	Function:	- IMPI client daemon header file for C++ functions
 */

#ifndef _LAM_DEBUG_CC_H_
#define _LAM_DEBUG_CC_H_

#ifndef __cplusplus

Error: This should only be included by C++ source files

#endif

#include <iostream.h>

//
// Brings printf debugging to a new low
//
class Debug {
public:
  inline Debug(bool initial = false) : on(initial) {}

  inline void On() { on = true; }
  inline void Off() { on = false; }
  inline bool isOn() { return on; };

protected:
  bool on;
};


//
// A sick and wrong templated debug function
//
template <class T>
inline Debug&
operator<<(Debug& d, const T& x) {
  if (d.isOn())
    cerr << x;
  return d;

}

//
// These need to be here for the endl on some compilers
//
inline Debug&
operator<< (Debug& d, ostream& (*_f)(ostream&))
{
  if (d.isOn())
    cerr << endl;
  return d;
}

inline Debug& 
operator<< (Debug& d, ios& (*_f)(ios&))
{
  if (d.isOn())
    cerr << endl;
  return d;
}

#endif
