/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *
 *	$Id: app_mgmt.h,v 1.2 1999/08/09 12:45:50 lamteam Exp $
 *
 *	Function:	- running application management
 */

#ifndef _APP_MGMT_H
#define _APP_MGMT_H

#include "lam.h"

/*
 * LAM constants & macros
 */
#define LAM_GPSCMP(p1, p2)	(((p1)->gps_node < (p2)->gps_node) ? -1 : \
				(((p1)->gps_node > (p2)->gps_node) ? 1 : \
				(((p1)->gps_idx < (p2)->gps_idx) ? -1 : \
				(((p1)->gps_idx > (p2)->gps_idx) ? 1 : \
				(((p1)->gps_pid < (p2)->gps_pid) ? -1 : \
				(((p1)->gps_pid > (p2)->gps_pid) ? 1 : 0))))))

#define LAM_FULL_GPSCMP(p1, p2) (((p1)->gps_node < (p2)->gps_node) ? -1 : \
                                (((p1)->gps_node > (p2)->gps_node) ? 1 : \
                                (((p1)->gps_idx < (p2)->gps_idx) ? -1 : \
                                (((p1)->gps_idx > (p2)->gps_idx) ? 1 : \
                                (((p1)->gps_pid < (p2)->gps_pid) ? -1 : \
                                (((p1)->gps_pid > (p2)->gps_pid) ? 1 : \
                                (((p1)->gps_grank > (p2)->gps_grank) ? -1 : \
                                (((p1)->gps_grank < (p2)->gps_grank) ? 1 : 0))))))))

/*
 * Global Positioning System for running processes
 */
struct _gps {
	int4		gps_node;		/* node ID */
	int4		gps_pid;		/* process ID */
	int4		gps_idx;		/* process index */
	int4		gps_grank;		/* glob. rank in loc. world */
};

#ifdef __cplusplus
extern "C" {
#endif

extern int		app_doom __ARGS((int app_n, struct _gps *app, 
					 int sig));
extern int		app_sendprocs __ARGS((int np, struct _gps *w));

#ifdef __cplusplus
}
#endif

#endif	/* _APP_MGMT_H */
