/////////////////////////////////////////////////////////////////////////////
// Name:        treetest.h
// Purpose:     wxTreeCtrl sample
// Author:      Julian Smart
// Modified by:
// Created:     04/01/98
// RCS-ID:      $Id: treetest.h,v 1.14 1998/12/20 00:34:52 VZ Exp $
// Copyright:   (c) Julian Smart and Markus Holzem
// Licence:     wxWindows license
/////////////////////////////////////////////////////////////////////////////

// Define a new application type
class MyApp : public wxApp
{
public:
  bool OnInit();
};

class MyTreeItemData : public wxTreeItemData
{
public:
  MyTreeItemData(const wxString& desc) : m_desc(desc) { }

  void ShowInfo(wxTreeCtrl *tree);

private:
  wxString m_desc;
};

class MyTreeCtrl : public wxTreeCtrl
{
public:
  enum
  {
    TreeCtrlIcon_File,
    TreeCtrlIcon_Folder
  };

  MyTreeCtrl() { }
  MyTreeCtrl(wxWindow *parent, const wxWindowID id,
             const wxPoint& pos, const wxSize& size,
             long style);
  virtual ~MyTreeCtrl();

  void OnBeginDrag(wxTreeEvent& event);
  void OnBeginRDrag(wxTreeEvent& event);
  void OnBeginLabelEdit(wxTreeEvent& event);
  void OnEndLabelEdit(wxTreeEvent& event);
  void OnDeleteItem(wxTreeEvent& event);
  void OnGetInfo(wxTreeEvent& event);
  void OnSetInfo(wxTreeEvent& event);
  void OnItemExpanded(wxTreeEvent& event);
  void OnItemExpanding(wxTreeEvent& event);
  void OnItemCollapsed(wxTreeEvent& event);
  void OnItemCollapsing(wxTreeEvent& event);
  void OnSelChanged(wxTreeEvent& event);
  void OnSelChanging(wxTreeEvent& event);
  void OnTreeKeyDown(wxTreeEvent& event);
  void OnItemActivated(wxTreeEvent& event);

  void GetItemsRecursively(const wxTreeItemId& idParent, long cookie);

  void AddTestItemsToTree(size_t numChildren,
                          size_t depth);

  void DoSortChildren(const wxTreeItemId& item, bool reverse = FALSE)
    { m_reverseSort = reverse; wxTreeCtrl::SortChildren(item); }

protected:
  virtual int OnCompareItems(const wxTreeItemId& item1,
                             const wxTreeItemId& item2);

private:
  void AddItemsRecursively(const wxTreeItemId& idParent,
                           size_t nChildren,
                           size_t depth,
                           size_t folder);

  wxImageList *m_imageListNormal;
  bool         m_reverseSort;           // flag for OnCompareItems

  // NB: due to an ugly wxMSW hack you _must_ use DECLARE_DYNAMIC_CLASS()
  //     if you want your overloaded OnCompareItems() to be called.
  //     OTOH, if you don't want it you may omit the next line - this will
  //     make default (alphabetical) sorting much faster under wxMSW.
  DECLARE_DYNAMIC_CLASS(MyTreeCtrl)
  DECLARE_EVENT_TABLE()
};

// Define a new frame type
class MyFrame: public wxFrame
{
public:
  // ctor and dtor
  MyFrame(const wxString& title, int x, int y, int w, int h);
  virtual ~MyFrame();

  // menu callbacks
  void OnQuit(wxCommandEvent& event);
  void OnAbout(wxCommandEvent& event);
  void OnDump(wxCommandEvent& event);
  void OnDelete(wxCommandEvent& event);
  void OnDeleteChildren(wxCommandEvent& event);
  void OnDeleteAll(wxCommandEvent& event);
  void OnRecreate(wxCommandEvent& event);

  void OnSetBold(wxCommandEvent& WXUNUSED(event)) { DoSetBold(TRUE); }
  void OnClearBold(wxCommandEvent& WXUNUSED(event)) { DoSetBold(FALSE); }

  void OnRename(wxCommandEvent& event);
  void OnSort(wxCommandEvent& event) { DoSort(); }
  void OnSortRev(wxCommandEvent& event) { DoSort(TRUE); }

private:
  void DoSort(bool reverse = FALSE);

  MyTreeCtrl *m_treeCtrl;

  void DoSetBold(bool bold = TRUE);

  DECLARE_EVENT_TABLE()
};

// menu and control ids
enum
{
  TreeTest_Quit,
  TreeTest_About,
  TreeTest_Dump,
  TreeTest_Sort,
  TreeTest_SortRev,
  TreeTest_Bold,
  TreeTest_UnBold,
  TreeTest_Rename,
  TreeTest_Delete,
  TreeTest_DeleteChildren,
  TreeTest_DeleteAll,
  TreeTest_Recreate,
  TreeTest_Ctrl = 100
};