
#include <sys/signal.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <limits.h>
#include <errno.h>
#include <termios.h>

/* They are needed to see devices */
#include <linux/fs.h>
#include <linux/fd.h>


/*
 * If no version is defined then set the VC as the default,
 * however this problem should not happen (unless you do
 * something wrong)
 */

#if !defined(VCHE_VC) && !defined(VCHE_RAW) && !defined(VCHE_NC)
#define VCHE_VC 1
#endif

#if defined(VCHE_NC)
#include <curses.h>
#endif

#include "config.h"

/* Some useful macros. */
#define hex2bin( buf, j) ((buf[ j] >= '0' && buf[ j] <= '9') ? buf[ j] - '0' : ((buf[ j] >= 'A' && buf[ j] <= 'F') ? buf[ j] - '7': 0))


#if defined(VCHE_VC) || defined(VCHE_RAW)

/*
 * Key definitions
 */

/* I use big numbers so they doesn't mess with */
/* other values in the switch()s.              */
#define VC_KEY_NONE     0
#define VC_KEY_F1     257
#define VC_KEY_F2     258
#define VC_KEY_F3     259
#define VC_KEY_F4     260
#define VC_KEY_F5     261
#define VC_KEY_F6     262 
#define VC_KEY_F7     263
#define VC_KEY_F8     264
#define VC_KEY_F9     265
#define VC_KEY_F10    266
#define VC_KEY_UP     267
#define VC_KEY_DOWN   268
#define VC_KEY_RIGHT  269
#define VC_KEY_LEFT   270
#define VC_KEY_HOME   271
#define VC_KEY_END    272
#define VC_KEY_PGUP   273
#define VC_KEY_PGDN   274

/*
 * Virtual console attributes
 */

/* Main foreground 16 colors */
#define VC_COLOR_BLACK         0
#define VC_COLOR_BLUE          1
#define VC_COLOR_GREEN         2
#define VC_COLOR_CYAN          3
#define VC_COLOR_RED           4
#define VC_COLOR_MAGENTA       5
#define VC_COLOR_BROWN         6
#define VC_COLOR_LIGHTGRAY     7
#define VC_COLOR_DARKGRAY      8
#define VC_COLOR_LIGHTBLUE     9
#define VC_COLOR_LIGHTGREEN   10
#define VC_COLOR_LIGHTCYAN    11 
#define VC_COLOR_LIGHTRED     12
#define VC_COLOR_LIGHTMAGENTA 13
#define VC_COLOR_YELLOW       14
#define VC_COLOR_WHITE        15

/* Background color attributes */
#define VC_COLOR_BG_BLUE          0x10
#define VC_COLOR_BG_GREEN         0x20
#define VC_COLOR_BG_CYAN          0x30
#define VC_COLOR_BG_RED           0x40
#define VC_COLOR_BG_MAGENTA       0x50
#define VC_COLOR_BG_BROWN         0x60
#define VC_COLOR_BG_LIGHTGRAY     0x70

/* Blink attribute bit */
#define VC_COLOR_BLINK            0x80

#define VC_COLOR_ATTENTION  ( VC_COLOR_WHITE     | VC_COLOR_BG_RED       )
#define VC_COLOR_BACKCYAN   ( VC_COLOR_BLACK     | VC_COLOR_BG_CYAN      )
#define VC_COLOR_BACKBLUE   ( VC_COLOR_LIGHTCYAN | VC_COLOR_BG_BLUE      )
#define VC_COLOR_BACKGRAY   ( VC_COLOR_BLACK     | VC_COLOR_BG_LIGHTGRAY )

/* Set color off */
#define VC_COLOR_OFF      0x2000

#endif

#if defined(VCHE_NC)

/* Key definitions */

#define VC_KEY_NONE   0
#define VC_KEY_F1    KEY_F(1)
#define VC_KEY_F2    KEY_F(2)
#define VC_KEY_F3    KEY_F(3)
#define VC_KEY_F4    KEY_F(4)
#define VC_KEY_F5    KEY_F(5)
#define VC_KEY_F6    KEY_F(6)
#define VC_KEY_F7    KEY_F(7)
#define VC_KEY_F8    KEY_F(8)
#define VC_KEY_F9    KEY_F(9)
#define VC_KEY_F10   KEY_F(10)
#define VC_KEY_UP    KEY_UP
#define VC_KEY_DOWN  KEY_DOWN
#define VC_KEY_RIGHT KEY_RIGHT
#define VC_KEY_LEFT  KEY_LEFT
#define VC_KEY_HOME  KEY_HOME
#define VC_KEY_END   KEY_END
#define VC_KEY_PGUP  KEY_PPAGE
#define VC_KEY_PGDN  KEY_NPAGE

/* Colors */
#define VC_COLOR_LIGHTGRAY     COLOR_PAIR( 20)
#define VC_COLOR_WHITE       ( COLOR_PAIR( 21) | A_BOLD)
#define VC_COLOR_BG_LIGHTGRAY  COLOR_PAIR( 22)
#define VC_COLOR_RED           COLOR_PAIR( 23)
#define VC_COLOR_ATTENTION   ( COLOR_PAIR( 23) | A_BOLD)
#define VC_COLOR_BACKCYAN      COLOR_PAIR( 24)
#define VC_COLOR_CYANBLUE      COLOR_PAIR( 25)
#define VC_COLOR_BACKBLUE    ( COLOR_PAIR( 25) | A_BOLD)
#define VC_COLOR_BACKGRAY      COLOR_PAIR( 26)

#define BUF_BBLUE  0
#define BUF_BLGRAY 1
#define BUF_WHITE  2

/* Normal state */
#define VC_COLOR_OFF      A_NORMAL

#endif


/*
 * Line/Box drawing
 */

#if defined(VCHE_VC)

#define VC_LINE_TOPLEFT       ''
#define VC_LINE_TOPRIGHT      ''
#define VC_LINE_BOTTOMLEFT    ''
#define VC_LINE_BOTTOMRIGHT   ''
#define VC_LINE_VERT          ''
#define VC_LINE_HORIZ         ''
#define VC_LINE_NOTHING       ' '

#elif defined(VCHE_RAW)

#define RAW_LINE_TOPLEFT       'l'
#define RAW_LINE_TOPRIGHT      'k'
#define RAW_LINE_BOTTOMLEFT    'm'
#define RAW_LINE_BOTTOMRIGHT   'j'
#define RAW_LINE_VERT          'x'
#define RAW_LINE_HORIZ         'q'
#define RAW_LINE_NOTHING       ' '
#define RAW_CROSS              'n'  /* a cross for box drawing */
#define RAW_LTEE               't'  /* tee pointing left       */
#define RAW_RTEE               'u'  /* tee pointing right      */
#define RAW_BTEE               'v'  /* tee pointing up         */
#define RAW_TTEE               'w'  /* tee pointing down       */
#define RAW_LARROW             ','  /* arrow pointing left     */
#define RAW_RARROW             '+'  /* arrow pointing right    */
#define RAW_DARROW             '.'  /* arrow pointing down     */
#define RAW_UARROW             '-'  /* arrow pointing up       */

#endif

#define FLAG_EDIT           2
#define FLAG_BELL           3
#define FLAG_NOHEX          5
#define FLAG_READONLY       6

#if defined(VCHE_VC)

#define FLAG_MASK           1
#define FLAG_ZERO           4

#define MAX_VCS_SAVE        256  /* Maximum number of screens saved */

#endif

#define EDIT_BITOP_XOR  0
#define EDIT_BITOP_OR   1
#define EDIT_BITOP_AND  2
#define EDIT_BITOP_NEG  3
#define EDIT_BITOP_ADD  4
#define EDIT_BITOP_SUB  5

#define EDIT_ASK_SAVE   0
#define EDIT_ASK_QUIT   1

/* Case sensitive for search */
#define VC_CASE_SENSITIVE   0
#define VC_CASE_INSENSITIVE 1

/*
 * Global variables
 */

/* note: extern variables are explained where defined, just use grep. */

struct fkey_text {
   char *text;
   int size;
};

extern struct fkey_text fkeys[ 3][ 11];

struct vc_flags {
   int bell;        /* Bell flag, set bell on and off               */
   int edit;        /* Edit flag                                    */
   int nohex;       /* No hex flag, toggle viewing the hex segment  */
   int readonly;    /* Read Only flag, disable/enable readonly mode */
#if defined(VCHE_VC)
   /* They are meaningless in non-vc versions */
   int mask;        /* Mask flag, mask non-printable characters     */
   int zero;        /* Zero flag, mask zero with "."                */
#endif
};

extern int fd;
extern struct stat stbuf;

extern struct vc_flags flags;

extern int bytes_to_read;
extern int bytes_per_row;
extern int bytes_per_row_hex;

extern int vc_case_sensitive;

#if defined(VCHE_VC)
extern int vcsafd;
extern int vcsfd;
extern char **vcs_save_buffer;
extern int vcs_save_index;
#endif

extern int ex, ey;

extern int bread;

extern long vc_filesize;

#if defined(VCHE_VC)

/* the 4-bytes screen structure of /dev/vcsa* devices */
struct vcscrn { unsigned char lines, cols, x, y; } scrn;

#endif

#if defined(VCHE_RAW)

/*
 * the windows size structure
 * (filled by init_screen_size() in init.c)
 */
struct wscrn {
       unsigned short lines;
       unsigned short cols;
       unsigned short xp;
       unsigned short yp;
} scrn;

#endif

#if defined(VCHE_VC) || defined(VCHE_RAW)

#define vc_lines scrn.lines
#define vc_cols  scrn.cols

#elif defined(VCHE_NC)

#define vc_lines LINES
#define vc_cols  COLS

#endif

/* The double linked list file structure */
struct ll_file {
        char *filename;
        long filepos;
        struct ll_file *next;
        struct ll_file *prev;
};

extern struct ll_file *ll_file_head;
extern struct ll_file *ll_file_current;
extern struct ll_file *ll_file_tail;
extern int ll_file_qty;

extern struct ll_file *ll_file_browse_curr;
extern struct ll_file *ll_file_browse_top;
extern int ll_file_browse_pos;

/* The linked list for editing changes */
struct ll_edit {
       char byte;
       long filepos;
       struct ll_edit *next;
};

extern struct ll_edit *ll_edit_head;

extern char hex_trans[];
extern char *obuffer;

#if defined(VCHE_RAW)
extern char *restore_buffer;
extern int stop_restore;
extern int current_color;
#endif

extern long fpos;

extern int edit_mask;

extern char srch[];

extern char *space_buffer;

/* edit.c */
void edit( void);
void edit_insert_in_obuffer( char byte, int what_attr);

/* file.c */
#define file_getpos() lseek( fd, (long) 0, SEEK_CUR);
int file_go_next( void);
int file_go_prev( void);
void file_open( char *filename);
void file_cannot_open( void);
void file_next_line( void);
void file_prev_line( void);
void file_next_byte( void);
void file_prev_byte( void);
void file_go_home( void);
void file_go_end( void);
void file_next_block( void);
void file_prev_block( void);
void file_getsize( void);
int file_is_a_valid_offset( long offset);

/* help.c */
void help( void);
void show_gnu_license( void);
void ascii_table( void);

/* hex.c */
void hex_mainloop( int view_or_edit);
void hex_showfile( void);
void hex_fill_hex_buffer( char *buf, int size);
void hex_fill_offset_buffer( long pos);
void hex_fill_ascii_buffer( char *buf, int size);
#if defined(VCHE_VC)
void hex_fill_zero_buffer( char *buf, int size);
#endif

/* init.c */
void init( void);
void init_buffers( void);
#if defined(VCHE_NC)
void init_ncurses( void);
#endif

/* keyboard.c */
#if defined(VCHE_VC) || defined(VCHE_RAW)
void key_wait_for_any( void);
void key_scanf( char *str, int leng);
int key_get( void);
#elif defined(VCHE_NC)
void key_scanf( WINDOW *w, char *str, int leng);
#define key_get() getch()
#endif

/* linkedlist.c */
void ll_file_init( void);
struct ll_file *ll_file_alloc( char *filename);
void ll_file_add( char *filename);
void ll_file_insert( char *filename);
void ll_file_free( void);
struct ll_file *ll_file_find( char *filename);
void ll_file_delete( void);
void ll_file_browse( void);
#if defined(VCHE_VC) || defined(VCHE_RAW)
void ll_file_browse_show( void);
#elif defined(VCHE_NC)
void ll_file_browse_show( WINDOW *w);
#endif
int ll_file_browse_next( int nitems);
int ll_file_browse_back( int nitems);
struct ll_edit *ll_edit_alloc( char byte);
void ll_edit_add( char byte, long filepos, struct ll_edit *tmp);
void ll_edit_free( void);

/* misc.c */
void do_exit( int status);
void draw_filename( char *filename);
void draw_main_screen( void);
void draw_fkeys( struct fkey_text fkt[]);
void draw_offset_n_perc( long offset);
void set_flag( int flag);
void *allocate_mem( int size);
char *trim_spaces( char *s);
void set_hexmode_variables( void);
int check_readonly( void);
#if defined(VCHE_NC)
void translate_buffer_colors( int what_attr, attr_t *attr, short *color);
#endif

/* term.c */
void term_init( void);
void term_beep( void);
void term_unhide_cursor( void);
void term_hide_cursor( void);
void term_goto( int x, int y);
#if defined(VCHE_VC) || defined(VCHE_RAW)
void term_noraw( void);
void term_raw( void);
void term_color( int color);
#endif
#if defined(VCHE_RAW)
void term_enable_graf_map( void);
void term_disable_graf_map( void);
#endif
#if defined(VCHE_NC)
void term_wgoto( WINDOW *w, int x, int y);
#endif

/* search.c */
void search( void);
void search_again( void);
void filegoto( void);
void search_hilite_found_string( void);

/* signals.c */
void signals_init( void);

#if defined(VCHE_VC)

/* vclib.c */
void vc_box( int x, int y, int xlen, int ylen, int attr);
void vc_color_puts( int x, int y, int size, char *str, int attr);
void vc_color_putc( int x, int y, char byte, int attr);
void vc_color_buffer_puts( int x, int y, int size, char *str, int attr);
void vc_puts( int x, int y, int size, char *str);
void vc_putc( int x, int y, char byte);
void vc_save_screen( void);
void vc_load_screen( void);
void vc_dialog_box( char *titlestr, char *valuestr, int size, int tattr, int vattr);
void vc_fill_screen( int attr);
void vc_show_alert_box( char *str, int addy);
void vc_show_screentext( char *text, char *title);
void vc_do_title( char *title);
void vc_put_bottom_line( char *text);
void vc_flush( void);
int vc_ask( char *msg, char *q1, char *q2, char *q3, int posit);
void vc_show_message( char *msg, int addy);
void vc_fill_obuffer( void);

#define lib_flush        vc_flush
#define lib_ask          vc_ask
#define lib_alert        vc_show_alert_box
#define lib_text         vc_show_screentext
#define lib_message      vc_show_message
#define lib_save_screen  vc_save_screen
#define lib_load_screen  vc_load_screen
#define lib_fill_obuffer vc_fill_obuffer
#define lib_dialog       vc_dialog_box
#define lib_cputc        vc_color_putc
#define lib_cputs        vc_color_puts
#define lib_buffer_puts  vc_color_buffer_puts

#elif defined(VCHE_RAW)

/* rawlib.c */
void raw_box( int x, int y, int xlen, int ylen, int attr);
void raw_buffer_puts( int x, int y, int size, char *str, int attr);
void raw_puts( int x, int y, int size, char *str);
void raw_putc( int x, int y, char byte);
void raw_color_putc( int x, int y, char byte, int attr);
void raw_color_puts( int x, int y, int size, char *str, int attr);
void raw_save_screen( void);
void raw_load_screen( void);
void raw_dialog_box( char *titlestr, char *valuestr, int size, int tattr, int vattr);
void raw_fill_screen( int attr);
void raw_show_alert_box( char *str, int addy);
void raw_show_screentext( char *text, char *title);
void raw_do_title( char *title);
void raw_put_bottom_line( char *text);
void raw_flush( void);
int raw_ask( char *msg, char *q1, char *q2, char *q3, int posit);
void raw_show_message( char *msg, int addy);
void raw_fill_obuffer( void);

#define lib_flush        raw_flush
#define lib_ask          raw_ask
#define lib_alert        raw_show_alert_box
#define lib_text         raw_show_screentext
#define lib_message      raw_show_message
#define lib_save_screen  raw_save_screen
#define lib_load_screen  raw_load_screen
#define lib_fill_obuffer raw_fill_obuffer
#define lib_dialog       raw_dialog_box
#define lib_cputc        raw_color_putc
#define lib_cputs        raw_color_puts
#define lib_buffer_puts  raw_buffer_puts

#elif defined(VCHE_NC)

/* nclib.c */
WINDOW *nc_box( int x, int y, int xlen, int ylen, chtype attr);
void nc_color_wputs( WINDOW *w, int x, int y, int size, char *str, chtype attr);
void nc_color_puts( int x, int y, int size, char *str, chtype attr);
void nc_color_buffer_puts( int x, int y, int size, char *str, int what_attr);
void nc_color_wputc( WINDOW *w, int x, int y, chtype byte, chtype attr);
void nc_color_putc( int x, int y, chtype byte, chtype attr);
WINDOW *nc_dialog_box( char *titlestr, char *valuestr, int size, chtype tattr, chtype vattr);
void nc_fill_screen( chtype attr);
void nc_show_alert_box( char *str, int addy);
void nc_show_screentext( char *text, char *title);
void nc_do_title( WINDOW *w, char *title);
void nc_put_bottom_line( WINDOW *w, char *text);
void nc_flush( void);
int nc_ask( char *msg, char *q1, char *q2, char *q3, int posit);
WINDOW *nc_show_message( char *msg, int addy);
void nc_fill_obuffer( void);

#define lib_flush        nc_flush
#define lib_ask          nc_ask
#define lib_alert        nc_show_alert_box
#define lib_text         nc_show_screentext
#define lib_message      nc_show_message
#define lib_fill_obuffer nc_fill_obuffer
#define lib_dialog       nc_dialog_box
#define lib_cputc        nc_color_putc
#define lib_cputs        nc_color_puts
#define lib_buffer_puts  nc_color_buffer_puts

#endif

