
#ifndef IIRBASE_PROCESS_STATEMENT_HH
#define IIRBASE_PROCESS_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_ProcessStatement.hh,v 1.2 1999/03/09 20:51:26 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_ConcurrentStatement.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_SequentialStatementList.hh"

class IIRBase_ProcessStatement : public IIR_ConcurrentStatement {

public:

  IIR_Kind get_kind() {return IIR_PROCESS_STATEMENT;}
  IIR_Char *get_kind_text() {return "IIR_ProcessStatement";}

  void set_postponed( IIR_Boolean postponed);
  IIR_Boolean get_postponed();

  IIR_DeclarationList process_declarative_part;
  IIR_SequentialStatementList process_statement_part;

protected:
  
  IIRBase_ProcessStatement();
  virtual ~IIRBase_ProcessStatement() = 0;
    
private:
  
  IIR_Boolean postponed;

};
#endif
