
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_EntityClassEntryList.cc,v 1.2 1999/03/09 20:54:14 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_EntityClassEntryList.hh"
#include "IIR_EntityClassEntry.hh"

IIRScram_EntityClassEntryList::~IIRScram_EntityClassEntryList(){}

void 
IIRScram_EntityClassEntryList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_EntityClassEntry* entity_class;
  for(entity_class = (IIR_EntityClassEntry*)first();
      entity_class != NULL;
    ) {
    entity_class->_publish_vhdl(_vhdl_out);
    entity_class = (IIR_EntityClassEntry*)successor(entity_class);
    if(entity_class != NULL) {
      _vhdl_out << ", ";
    }
  }
}

