#ifndef IIRSCRAM_FUNCTION_CALL_HH
#define IIRSCRAM_FUNCTION_CALL_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FunctionCall.hh,v 1.2 1999/03/09 20:54:39 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_FunctionCall.hh"

class IIR_DesignatorList;
template <class type> class set;
class IIR_TypeDefinition;
class IIR_SubprogramDeclaration;
class IIR_IndexedName;
class IIR_FunctionCall;

class IIRScram_FunctionCall : public IIRBase_FunctionCall {
// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  void _publish_vhdl(ostream &);
  void _publish_cc_as_operator();
  void _publish_cc();
  void _publish_cc_elaborate();
  void _publish_cc_bounds();
  void _publish_cc_elaborate_arg();
  void _publish_cc_initialization_value();

  // This function is implemented recursively in different nodes to handle
  // type conversion in procedure calls. The actual can be nest function
  // calls and the actual nested with them is extracted and published
  
  void _publish_cc_first_objectParameter();

  void _publish_cc_kernel_type();
  
  void _type_check( set<IIR_TypeDefinition> * );
  IIR * _rval_to_decl( IIR_TypeDefinition * );
  IIR_TypeDefinition *_get_subtype();

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  IIR_Boolean _is_resolved(){ return TRUE; }
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }

  static IIR_FunctionCall *_build_function_call( IIR_SubprogramDeclaration *, IIR_IndexedName * );

  ostream &_print( ostream & );

  set<IIR_Declaration> *_symbol_lookup();

  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  void _get_list_of_input_signals(set<IIR_Declaration>* list);
  void _add_decl_into_cgen_symbol_table();

  IIR *_clone();
  IIR_Mode _get_mode();

  // (See IIRScram.hh for description)
  IIR_Declaration *_find_formal_declaration();

  IIR_Boolean _is_globally_static_primary();

  IIR_Boolean _is_static_expression();
  
protected:
  IIRScram_FunctionCall() {}
  virtual ~IIRScram_FunctionCall() = 0;
    
private:
};
#endif


