#ifndef IIRSCRAM_INCOMPLETE_TYPE_DEFINITION_HH
#define IIRSCRAM_INCOMPLETE_TYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_IncompleteTypeDefinition.hh,v 1.2 1999/03/09 20:54:56 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_TypeDefinition.hh"
class IIR_Name;

class IIRScram_IncompleteTypeDefinition : public IIR_TypeDefinition {
public:
  IIR_Kind get_kind(){ return _IIR_ERROR; }
  IIR_Char *get_kind_text(){ return "IIRScram_IncompleteTypeDefinition"; }
  
  IIRScram_IncompleteTypeDefinition(){
    _my_designated_type_name = NULL;
  }

  ~IIRScram_IncompleteTypeDefinition(){}
  
  IIR_Name *_get_designated_type_name(){
    return _my_designated_type_name;
  }

  void _set_designated_type_name( IIR_Name *new_type_name ){
    _my_designated_type_name = new_type_name;
  }

  IIR_Boolean _is_incomplete_type_definition(){
    return TRUE;
  }

private:
  IIR_Name *_my_designated_type_name;
};

#endif
