#ifndef FILETYPE_HH
#define FILETYPE_HH

//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------

#include "VHDLType.hh"
#include "STDTypes.hh"
#include "TypeKind.hh"
#include "ArrayType.hh"

extern const int maxExtraInFilesInProcedure;
extern const int maxExtraOutFilesInProcedure;

template <class Type> class AccessVariable;
class SavantlineType;
class VHDLKernelBase;

class FileType : public VHDLType {
public:

  FileType(bool alias = false);
  FileType(const FileType &);
  FileType(VHDLKernelBase*, const char*, const _savant_file_open_kind);
  FileType(VHDLKernelBase*, const ArrayType&, const _savant_file_open_kind);

  virtual void openFile(VHDLKernelBase *, const char *fileName, const _savant_file_open_kind &, ios::open_mode = ios::out);
  virtual  void openFile(VHDLKernelBase *, const ArrayType& fileName, const _savant_file_open_kind &, ios::open_mode = ios::out);
  void closeFile(VHDLKernelBase *);
  
  void reset(const char *fileName);
  void reset(const ArrayType& fileName);
  
  virtual ~FileType();

  virtual Type get_kind() const;

  ObjectBase* getObject() const {
    return NULL;
  }

  virtual ObjectBase::ObjectType getKind() const;

  virtual void print(ostream& = cout) const;
  
  VHDLType* clone() const;
  
  int savantwriteline(VHDLKernelBase *, AccessVariable <char*> &);
  int savantwriteline(VHDLKernelBase *, SavantlineType &);
  int savantreadline(VHDLKernelBase *, AccessVariable <char*> &);
  int savantreadline(VHDLKernelBase *, SavantlineType &);
  int savantreadline(VHDLKernelBase *, SavantlineType &, IntegerType&);
  
  EnumerationType savantendfile_boolean(VHDLKernelBase *, int);
  
  int get_fileHandle() const;
  _savant_file_open_kind& get_fileOpenKind();
  void set_fileHandle(const int);
  void set_fileOpenKind(const _savant_file_open_kind &);

  FileType & operator =(const FileType &);

  bool operator==(const VHDLType&) const;
  
  int fileHandle;
  _savant_file_open_kind openKind;
};

// extern int savantwrite(VHDLKernelBase *base, FileType&, SavantlineType&);
// extern int savantwriteline(VHDLKernelBase *base, FileType&, SavantlineType&);
// extern int savantread(VHDLKernelBase *base, FileType&, SavantlineType&);
// extern int savantreadline(VHDLKernelBase *base, FileType&, SavantlineType&);
// extern EnumerationType savantendfile(VHDLKernelBase *base, FileType&);

#endif
