#include "CWSignalType.hh"
#include "Signal.hh"
#include "ImplicitSignal.hh"
#include "SignalNetinfo.hh"

#ifdef CLASS_WIDE
// In each constructor, val is only used to keep a handle on memory
// allocated, in case it is needed to destroy the memory. For signals
// this is not an issue; the Signal class destructor should do this 
// (see documentation). For ImplicitSignal, the class does not have
// a destructor and hence this may be a problem (may need to write
// a destructor which is similar to Signal in the way that it deals 
// with class wide signals.

CWSignalType::CWSignalType(ObjectBase::ObjectType objType) {
 CWSignalData *val;

 switch(objType) {
 case ObjectBase::SIGNAL : 
   val = new CWSignalData();
   object = new Signal<CWSignalData>(*val); break;
 case ObjectBase::SIGNAL_NETINFO :
   object = new SignalNetinfo; break;
 case ObjectBase::IMPLICIT_SIGNAL :
   val= new CWSignalData();
   object = new ImplicitSignal<CWSignalData>(*val); break;
 case ObjectBase::VARIABLE :
   cerr << "ERROR: cannot have this object type VARIABLE" << endl;
   exit(-1);
 default:
   cerr << "ERROR: unknown object type" << endl;
   exit(-1);
 }
}

CWSignalType::CWSignalType(ObjectBase::ObjectType objType, const TaggedRecord& value) {

 CWSignalData *val; 

 switch(objType) {
 case ObjectBase::SIGNAL : 
   val = new CWSignalData(value);
   object = new Signal<CWSignalData>(*val); break;
 case ObjectBase::IMPLICIT_SIGNAL :
   val = new CWSignalData(value);
   object = new ImplicitSignal<CWSignalData>(*val); break;
 case ObjectBase::SIGNAL_NETINFO :
   object = new SignalNetinfo; break;
 case ObjectBase::VARIABLE :
   cerr << "ERROR: cannot have this object type VARIABLE" << endl;
   exit(-1);
 default:
   cerr << "ERROR: unknown object type" << endl;
   exit(-1);
 }
}

CWSignalType::CWSignalType(ObjectBase::ObjectType objType, const CWSignalType& value) {

 CWSignalData *val; 

 switch(objType) {
 case ObjectBase::SIGNAL : 
   val = new CWSignalData((CWSignalData &) value.object->readVal());
   object = new Signal<CWSignalData> (*val); break;
 case ObjectBase::IMPLICIT_SIGNAL :
   val = new CWSignalData((CWSignalData &) value.object->readVal());
   object = new ImplicitSignal<CWSignalData> (*val); break;
 case ObjectBase::SIGNAL_NETINFO :
   object = new SignalNetinfo; break;
 case ObjectBase::VARIABLE :
   cerr << "ERROR: cannot have this object type VARIABLE" << endl;
   exit(-1);
 default:
   cerr << "ERROR: unknown object type" << endl;
   exit(-1);
 }
}


CWSignalType::CWSignalType(ObjectBase::ObjectType objType, const CWSignalData& value) {
 // not sure about memory allocation here. This could be correct though.

 CWSignalData *val;

 switch(objType) {
 case ObjectBase::SIGNAL : 
   val = new CWSignalData(value);
   object = new Signal<CWSignalData>(*val); break;
 case ObjectBase::IMPLICIT_SIGNAL :
   val = new CWSignalData(value);
   object = new ImplicitSignal<CWSignalData>(*val); break;
 case ObjectBase::SIGNAL_NETINFO :
   object = new SignalNetinfo; break;
 case ObjectBase::VARIABLE :
   cerr << "ERROR: cannot have this object type VARIABLE" << endl;
   exit(-1);
 default:
   cerr << "ERROR: unknown object type" << endl;
   exit(-1);
 }
}
#endif

bool
CWSignalType::operator==(const VHDLType& val) {
  if (val.get_kind() == TAGGED_TYPE) {
    return (*((CWSignalData &) (object->readVal())).val == val);
  }
 
  return (*((CWSignalData &) (((CWSignalType &) val).object->readVal())).val
	  == *((CWSignalData &) (object->readVal())).val);
 
}

void 
CWSignalType::print(ostream& os) const {
  ((CWSignalData &) (object->readVal())).val->print(os);
}

VHDLType *
CWSignalType::clone() const {
  cerr << "CWSignalType::clone() Can not do this." << endl;
  abort();
  return NULL;
}

ObjectBase::ObjectType
CWSignalType::getKind() const {
  return ((CWSignalData &) (object->readVal())).val->getKind();
}

ObjectBase *
CWSignalType::getObject() const {
  return object; 
}
