/*
  sdf.h
  Standard Downloading Functions
  Uros Platise (c) 1997, November
*/

#ifndef __SDF
#define __SDF

#include <stdio.h>

typedef unsigned int TMem;
struct TDataQuery {
  char*          segName; /* dest/source segment name */
  unsigned char* buf;     /* input/output buffer */
  TMem           size;    /* max size of transferred data */
  TMem           offset;  /* segment offset address */
  bool           keepOut; /* filter */
};

class TAout {
public:
  TAout (char* aoutFileName, char* mode);
  ~TAout ();

  int  readData (TDataQuery* dataP);
  bool segRequest (char* segName);
  void writeData (TDataQuery* dataP);

private:
  FILE *fp;
  char fileName [64];
  bool startofFile, endofFile;
  bool anySegWr;
  char curSegmentName [32];
  char filter [32];
};

class TSDF {
public:
  virtual void upload (TAout* aout, bool verifyOnly=false) = 0;
  virtual void download (TAout* aout) = 0;
  virtual ~TSDF () {};
};

#endif
