%define name	gnomehack
%define version	1.0.5

%define usrpfx /usr
%define varpfx /var
%define etcpfx /etc


Name: 		%{name}
Version: 	%{version}
Release: 	%{release}
Prefix:		/var
Prefix:		/usr
Summary:	A port of NetHack for GNOME
Copyright: 	Open Source (Nethack General Public Licence)
Group: 		X11/Games
Source:		gnomehack_%{version}-%{release}.tar.gz
Url:		http://www.xmission.com/~andersen/erik/gnomehack/gnomehack.html
BuildRoot:	/var/tmp/%{name}-%{version}-root
Requires: gnome-libs >= 1.0.9
Requires: gtk+ >= 1.2.0
Requires: bzip2


%description
Nethack is the greatest of all the Rogue-like games. GnomeHack is a
port of NetHack for Gnome, using the very cool GTK+ toolkit.


%prep
%setup

%build
# export CFLAGS="$RPM_OPT_FLAGS"
# export CXXFLAGS="$RPM_OPT_FLAGS"

if [ -f autogen.sh ]; then \
    echo "You seem to be building from CVS..."; \
    ./autogen.sh --prefix=%{usrpfx} \
       --enable-alt-hackdir=%{usrpfx}/lib/games/gnomehack \
       --enable-alt-desktopdir=%{usrpfx}/share/gnome/apps/Games \
       --enable-alt-savedir=%{varpfx}/lib/games/gnomehack \
       --enable-exp-in-status --enable-enh-wizard \
       --enable-wizard=root --disable-secure --enable-vision-algo=funcs \
       --with-tty-port --with-gnome-port ; \
else \
    echo "You seem to be building from a tarball..."; \
    ./configure --prefix=%{usrpfx} \
       --enable-alt-hackdir=%{usrpfx}/lib/games/gnomehack \
       --enable-alt-desktopdir=%{usrpfx}/share/gnome/apps/Games \
       --enable-alt-savedir=%{varpfx}/lib/games/gnomehack \
       --enable-exp-in-status --enable-enh-wizard \
       --enable-wizard=root --disable-secure --enable-vision-algo=funcs \
       --with-tty-port --with-gnome-port ; \
fi;

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi


%install
make DESTDIR=$RPM_BUILD_ROOT install

# Adjust the install slightly -- move the gnomehack binaries
# to the lib directory so I can put a wrapper script into
# /usr/games instead
mv $RPM_BUILD_ROOT%{usrpfx}/games/* $RPM_BUILD_ROOT%{usrpfx}/lib/games/gnomehack/

# specially install X11 stuff
/usr/X11R6/bin/bdftopcf -o nh10.pcf win/X11/nh10.bdf
mkdir -p $RPM_BUILD_ROOT%{usrpfx}/X11R6/lib/X11/fonts/misc/
install -m 644 nh10.pcf $RPM_BUILD_ROOT%{usrpfx}/X11R6/lib/X11/fonts/misc/nh10.pcf
rm -f $RPM_BUILD_ROOT%{usrpfx}/X11R6/lib/X11/fonts/misc/nh10.pcf.gz
gzip $RPM_BUILD_ROOT%{usrpfx}/X11R6/lib/X11/fonts/misc/nh10.pcf

# extract spoilers for the docs directory
tar -xzf helper-stuff/spoilers.tar.gz

# install wrapper scripts and supporting rc files
# ( I should make the game install do this....)
mkdir -p $RPM_BUILD_ROOT%{usrpfx}/games/
install -m 2755 -o root -g games \
        helper-stuff/gnomehack.sh \
        $RPM_BUILD_ROOT%{usrpfx}/games/gnomehack
install -m 2755 -o root -g games \
        helper-stuff/games/nethack.sh \
        $RPM_BUILD_ROOT%{usrpfx}/games/nethack
mkdir -p $RPM_BUILD_ROOT%{etcpfx}/
install -m 0644  -o root -g root \
        helper-stuff/gnomehackrc \
        $RPM_BUILD_ROOT%{etcpfx}/gnomehackrc
install -m 0644  -o root -g root \
        helper-stuff/nethackrc \
        $RPM_BUILD_ROOT%{etcpfx}/nethackrc
mkdir -p $RPM_BUILD_ROOT%{usrpfx}/lib/games/gnomehack/
install -m 0755 -o root -g games \
        helper-stuff/gnomehack_wrapper.sh \
        $RPM_BUILD_ROOT%{usrpfx}/lib/games/gnomehack/gnomehack.sh
mkdir -p $RPM_BUILD_ROOT%{etcpfx}/rc.d/init.d/
install -m 0755  -o root -g root \
        helper-stuff/gnomehack.init.sh \
        $RPM_BUILD_ROOT%{etcpfx}/rc.d/init.d/gnomehack

touch $RPM_BUILD_ROOT%{varpfx}/lib/games/gnomehack/{perm,record,logfile}
chown root.games $RPM_BUILD_ROOT%{varpfx}/lib/games/gnomehack/{perm,record,logfile}
chmod 0664 $RPM_BUILD_ROOT%{varpfx}/lib/games/gnomehack/{perm,record,logfile}

rm -fr $RPM_BUILD_ROOT%{usrpfx}/doc/gnomehack

%files
%doc AUTHORS COPYING COPYING.read-this ChangeLog INSTALL LICENSE NEWS README README.nethack doc/Guidebook doc/Guidebook.tex spoilers
%attr(0644, root, root) %{etcpfx}/gnomehackrc
%attr(0755, root, root) %{etcpfx}/rc.d/init.d/gnomehack
%attr(0644, root, root) %{usrpfx}/X11R6/lib/X11/fonts/misc/nh10.pcf.gz
%attr(2755, root, games) %{usrpfx}/games/gnomehack
%attr(2755, root, games) %{usrpfx}/games/nethack
%dir %attr(2755, root, games) %{usrpfx}/lib/games/gnomehack
%attr(2755, root, games) %{usrpfx}/lib/games/gnomehack/dgn_comp
%attr(2755, root, games) %{usrpfx}/lib/games/gnomehack/gnomehack
%attr(2755, root, games) %{usrpfx}/lib/games/gnomehack/lev_comp
%attr(2755, root, games) %{usrpfx}/lib/games/gnomehack/recover
%attr(0755, root, games) %{usrpfx}/lib/games/gnomehack/gnomehack.sh
%attr(0644, root, games) %{usrpfx}/lib/games/gnomehack/license
%attr(0644, root, games) %{usrpfx}/lib/games/gnomehack/mapbg.xpm
%attr(0644, root, games) %{usrpfx}/lib/games/gnomehack/nh_icon.xpm
%attr(0644, root, games) %{usrpfx}/lib/games/gnomehack/nhdat
%attr(0644, root, games) %{usrpfx}/lib/games/gnomehack/pet_mark.xbm
%attr(0644, root, games) %{usrpfx}/lib/games/gnomehack/rip.xpm
%attr(0644, root, games) %{usrpfx}/lib/games/gnomehack/x11tiles
%attr(0644, root, root) %{usrpfx}/man/man6/*
%attr(0644, root, root) %{usrpfx}/share/gnome/apps/Games/*
%dir %attr(0775, root, games) %{varpfx}/lib/games/gnomehack
%attr(0664, root, games) %{varpfx}/lib/games/gnomehack/*

%pre
if [ -f %{etcpfx}/rc.d/init.d/gnomehack ]; then \
    %{etcpfx}/rc.d/init.d/gnomehack stop; \
fi

%post
if [ -x /usr/X11R6/bin/mkfontdir ] ; then /usr/X11R6/bin/mkfontdir \
  /usr/X11R6/lib/X11/fonts/misc ; \
fi

chkconfig --add gnomehack
chkconfig gnomehack reset
%{etcpfx}/rc.d/init.d/gnomehack start

%preun
%{etcpfx}/rc.d/init.d/gnomehack stop
chkconfig --del gnomehack

%postun
if [ -x /usr/X11R6/bin/mkfontdir ] ; then /usr/X11R6/bin/mkfontdir \
  /usr/X11R6/lib/X11/fonts/misc; \
fi

%clean
rm -rf $RPM_BUILD_ROOT
rm -rf $RPM_BUILD_DIR/gnomehack-%{version}

%changelog
* Fri Oct 29 1999 Fred Richardson <frichard@bbn.com>
- Many small fixes.  Should work with repository version. Uses `DESTDIR' instead
  of setting each prefix path explicitly for install (looks like this
  is supported well in the make files).
  Copied chunks of debian package steps into spec file.
* Fri Oct 29 1999 Erik Andersen <andersee@debian.org>
- Fixed problems thanks to a patch from Fred Richardson <frichard@bbn.com>
* Tue Oct 26 1999 Erik Andersen <andersee@debian.org>
- Fixed based in part on the .spec file from Mandrake.
* Wed May 5  1999 Erik Andersen <andersee@debian.org>
- I Wrote this spec file.  I have no idea if this is correct or even works...

