#!/usr/bin/perl

%links = (
	__XSWALLOW__ => 
'<A HREF="http://skynet.csn.ul.ie/~caolan/docs/XSwallow.html">XSwallow</A>'
);

sub shorten {
	print "sh $_[0]\n";
#	return "ARCHI- &nbsp&nbsp&nbsp;TECTURE" if $_[0] eq "ARCHITECTURE";
	$_[0];
}

sub hlinks {
	local $_ = $_[0];
	s/&/&amp;/g;
	s/"/&quot;/g;
	s/</&lt;/g;
	s/>/&gt;/g;
	s/((?:http|ftp):\S+[a-zA-Z\/0-9])([\.,]?\s+)/<A__TJLSPACEFOO__HREF="$1">$1<\/A>$2/gs;
	s/ /&nbsp;/g;
	s/__TJLSPACEFOO__/ /g;
	s/\n/<BR>/g;
	"<TT>$_</TT>";
}

@docs = qw/README CONFORMANCE INSTALL ARCHITECTURE GOALS CREDITS TODO/;
%mans = qw/freewrl freewrl VRML::Browser Browser.pm VRML::Viewer Viewer.pm/;
@mans = qw/freewrl VRML::Browser VRML::Viewer/;

for(@docs) {
	system("cp ../VRML/$_ .");
}

for(@mans) {
	system("rm -f $_.pod");
	system(qq|perl -p -e's/L<([^>]+)>/LINK_\$1_LINK/g' ../VRML/$mans{$_} >$_.pod|);
}


@menu = (
["Main","index.html"],
["License intent","intent.html"],
["Screenshots","screenshots.html"],
["News","news.html"],
["Download", "download/"],
["Links","links.html"],
[XX1, "FreeWRL&nbsp;manpages"],
(map {[$_,$_.".html"]} @mans),
[XX2],
[XX1, "FreeWRL&nbsp;docs"],
(map {[shorten($_),$_.".html"]} @docs),
[XX2],
);

for(@docs) {
	writepage($_.".html", $_, hlinks(join '',`cat $_`)."\n");
}

$lib = join ':',@mans;
for(@mans) {
	system("pod2html --podroot=. --infile=$_.pod --outfile=$_.tmp -podpath=. -htmlroot=. ");
	my $txt = (join '', `cat $_.tmp`);
	$txt =~ s/TITLE/H1/g;
	$txt =~ s/<\/?(HTML|HEAD|BODY)>//g;
	$txt =~ s/LINK_([^_]+)_LINK/<A HREF="$1.html">the $1 manpage<\/A>/g;
	writepage($_.".html", "$_ Manual Page", $txt);
}

# system("rm *.tmp");

writepage("intent.html","FreeWRL License intent",hlinks("

This license intent was originally written by Tuomas Lukka. 
We will keep this license intent intact, but it may be re-written
in the future. John.stewart\@crc.ca

On the www-vrml mailing list ([] = later addition)...

On Tue, 7 Jul 1998, Mike Fletcher wrote:
> My apologies, I had gathered from your comments during our earlier
> discussions that you were not amenable to allowing your browser to be
> used as a library in commercial situations.  I apparently gathered
> wrongly.  I will review the package as soon as I get a chance to
> breathe and come back to you with comments.

There are two different matters here.

I'm not amiable to someone taking a certain version of my browser
and packaging it and adding a small proprietary addition and selling
that [without providing source for my browser!!]. 

It's not so much that I would be against having them make money -
you are allowed to put FreeWRL on a CD right now and ask for money.

What I would be annoyed about is the same thing as Richard Stallman:
if I after that moment improve my browser, I would have to choose between
my improvement or the company's proprietary thingie - no way to have both.

This is something I'm not willing to let happen. And it's not only
bad for me but for the company too, in the long run.

I'm being pretty flexible in my opinion by letting the API be public,
the only restrictions are: if you take one of the FreeWRL modules
and change it, you have to let those changes be redistributed freely
and with source. If you write a new backend without using FreeWRL code,
it's ok.

And if someone wants to do something without writing a whole module
but needs to have it proprietary, PLEASE TALK TO ME! It's in both
our interests to create an intermediate API so that your extension
can be included. For instance, if SuperExtrusion Inc. wants to 
release a new VRML browser using their extrusion library that
they want to keep proprietary, this is possible. What they would
have to do is talk with me, establish an API for the library and
I'll include the code to use that API in FreeWRL, GPL'd. Their
lib stays proprietary and when they release their browser, I can
buy a copy and use it with my FreeWRL code that I've updated since
then with bug fixes / other new features. Everyone's happy, SuperExtrusion
Inc. gets their money and I get to keep my sources alterable.

So again, the GPL only applies to modifications made to the FreeWRL 
modules. It does not traverse across published APIs.

This is also to prevent the X11 problem: the X consortium actually
got bug fixes from very few external sources, slowing down their
development - they complained about this sometimes. With GPL, 
bug fixes to the core will be GPL'ed.

I'm not anti-commercial, just anti-freezing-my-source. I'm sorry
if I have sounded too harsh in the past. I'm sure you can see the
reason for my point of view.

I suppose I should write this up carefully in the distribution somewhere.

        Tuomas
"));


writepage("screenshots.html","FreeWRL ScreenShots",
<<'__STOP__'
There are many cool worlds that already work inside FreeWRL but
I won't show them here yet.
<P>
What I *will* show is Netscape running FreeWRL (using __XSWALLOW__).
FreeWRL is rendering the box and it is possible to just grab it and
rotate it in any way the user pleases. 
<IMG SRC="screenshot1.jpg">
<P>
__STOP__
);

writepage("links.html","FreeWRL Links",
<<'__STOP__'
<LIST>
<LI>

<A HREF="http://www.vrml.org" TARGET="main"> The VRML consortium  </A>
is the official site for VRML specifications and working groups.

<LI><A HREF="http://www.web3d.org/vrml/vrml.htm" TARGET="main"> The VRML repository  </A>
is a huge collection of VRML-related information and links.

<LI><A HREF="http://vrml.miningco.com"><IMG SRC="mcbut.gif">'s VRML focus</A>

<LI><A HREF="http://www.pernet.net/~kahlage/vrml.html">VRML Resources for Linux page by Gerall Kahla
	<IMG SRC="V4L.jpg"></A>

<LI>
	<A HREF="http://www.mesa3d.org">The Mesa
	library</A> 

<LI>__XSWALLOW__ is useful for running FreeWRL inside Netscape (look
	at the screenshots!)
</LIST>

__STOP__
);

writepage("news.html","FreeWRL News",
$news= <<'__STOP__'
<LIST>
<LI> 14.June.1999 -- 0.20alpha1 is out! EAI is pretty good now, still a few
bugs to work on.
<LI> 18.May.1999 -- 0.19beta2 should be released soon. I have been working on
EAI code, and fixing some minor bugs. The EAI code and SHARED VIRTUAL WORLDS should work
100% soon...
<LI> 23.Mar.1999 -- 0.19 is out. Great gains in EAI, some documentation updates.
<LI> 15.Jan.1999 -- 0.18 is out. First version released by John Stewart (john.stewart@crc.ca)
<LI> 24.Dec.1998 -- 0.17 is out. Minimal portability fixes.
I haven't had much need for FreeWRL in my own work for a while so
much progress has not been made. I welcome patches and new maintainers,
please do contact me.
<LI> 15.Aug.1998 -- 0.16 is out. There is not much new, but I just
wanted to get out what I have before leaving for some weeks. I'll be
in touch on email and will be able to put important announcements or
patches up here if someone has some but will probably not be able to release
complete new versions.
<LI> 4.Aug.1998 -- 0.15 is out. speedups, lighting fixes (e.g. directional
fixes), ...
<LI> 28.Jul.1998 -- 0.14 is out, finally. Featuring: much-improved
documentation (the manpages are available here on this website as well),
better Extrusions (thanks to Bernhard Reiter once again), 
better NavigationInfo handling (John Breen) and lots of cleanups.
The start of the cleanup signifies that we are now headed for 1.0
as fast as possible. As always, keep sending me worlds that don't
work in FreeWRL and I'll try to fix it.
Also, inform me about any problems: otherwise they won't get fixed!
<LI> 16.Jul.1998 -- 0.13 is out. 
Biggest news is EAI classes for Java! 
Now FreeWRL is structurally complete and all the rest will hopefully
be just patching in the holes bit by bit. But nothing major is
lacking any more (of course, EAI through java in a NS plugin would 
be nice... anyone? ;)
<LI> 9.Jul.1998 -- The next version of FreeWRL will be under LGPL 
(the GNU Library General Public License), allowing redistribution
as parts of larger systems. If you want to include FreeWRL in 
your product, email me and we'll work out the details.
<LI> 9.Jul.1998 -- 0.12 is out, possibly even more unstable
but on the other hand having many bugfixes and new features.
Please send in success/failure reports so I can stabilize the
distributions. This version contains a first shot at EAI using
socket communications, PNG support and many neat changes.
Works better inside Netscape than the previous version, as 
now it is possible to specify the URL to be different than the filename
-- enabling e.g. textures and inlines inside netscape.
Now just to make EAI java classes to work in Netscape and... ;)
<LI> 7.Jul.1998 -- 0.11 is out, but unstable. Get it if you want
to be on the bleeding edge and can take care of problems. Otherwise,
wait for 0.12. 0.11 includes lots of new stuff, e.g. ProximitySensor,
TextureTransform, ... and I've started running the NIST test suite
now that I can use FreeWRL inside Netscape. 
<LI> 6.Jul.1998 -- Just after releasing 0.10 I got __XSWALLOW__ and
made freewrl work inside netscape navigator. As a result, I've gotten
quite a lot of fixes done -- I'll put a screenshot and a new version
out soon ;)
<LI> 6.Jul.1998 -- 0.10 is out. Fixes many bugs and makes viewpoints
 finally work. Source organized a little bit more again.
 See README for more change info.
<LI> 3.Jul.1998 -- 0.09 is out, fixing some parser bugs and expanding
the JavaScript support quite a bit. Also prototype/event fixes.
<LI> 30.Jun.1998 -- 0.08 is out, supporting real URLS (using libwww-perl)
and many bug fixes.
<LI> 22.Jun.1998 -- 0.07 is out, fixing many things over 0.06. I apologize
for the hasty, not-enough-tested releases but I'm preparing the papers
for the Perl conference so I am only concentrating on getting my demos
for there working. The situation will improve in about two weeks.
<LI> 22.Jun.1998 -- Some other known bugs for 0.06: MFFloats and MFInt32's
with commas are parsed incorrectly. A new release will be out soon.
<LI> 21.Jun.1998 -- It appears that FreeWRL-0.06 still doesn't work
correctly with FreeType-1.1. For the time being, use FreeType-1.0,
until I finally move my own machines to 1.1. Sorry about this.
<LI> 21.Jun.1998 -- A new look for the web pages - got rid of the tacky
frames and so on. Now they are generated with Perl to ensure a common
look.
<LI> 17.Jun.1998 -- Finally it's here: version 0.06. Lots of things
work more stably and much faster than before, it is not as horribly
verbose at startup and so on. Please try it and send bug reports.
Oh yes, there is also a new DESCENT(tm)-like interface for moving
around in 3-space (FLY mode, see README).
<LI> 16.Jun.1998 -- Several things: 1. FreeWRL is going to be in the 
<A HREF="http://conference.perl.com/">Perl Conference 2.0</A>, in San Jose
in august. 2. 0.06 is coming real soon now, I've added createVrmlFromString
to the Perl script interface, and other languages will soon follow suit.
<LI> 8.Jun.1998 -- now it works on IRIX 6.2, with accelerated OpenGL.
Is this the first browser with javascript (instead of vrmlscript) for
SGI? Next version coming soon... Also, I'm working on an app that needs
EAI so it is conceivable that EAI will be implemented soon ;) ;)
<LI> 3.Jun.1998 -- released version 0.05. Contains bugfixes and several
new nodes work, most importantly Plane- and SphereSensor, as well as
Switch and LOD. It should also be quite
a lot faster than the previous version, as now I use polygon culling.
As always, please try out the new version and report
bugs so I can improve FreeWRL!
<LI> 30.May.1998 -- released new version 0.04, as I accidentally omitted
important Javascript files from 0.03. It was possible to use 0.03 but
not the javascript part. 0.04 also contains support for Text and
Background nodes as well as bindable nodes. Many more examples
from the VRML Sourcebook work now... Go to the download area for the source.
</LIST>
__STOP__
);

$newest = $news; 
# $newest =~ s/(<LIST>\s*<LI>[^>]*<LI>[^>]*<LI>[^>]*).*(<\/LIST>)/$1$2/
$newest =~ s/(<LIST>\s*<LI>[^<]*<LI>[^<]*<LI>[^<]*).*(<\/LIST>)$/$1$2/s
or die("No newest-match ($newest)");

writepage("index.html","FreeWRL Home Page", 
<<'__STOP__'
Welcome to the FreeWRL web pages.
<P>
<SMALL>
DISCLAIMER: All information and programs 
presented on these pages is presented strictly on an as-is basis without
an explicit or implicit warranty or guarantee of any kind, not even
for fitness for any particular purpose. The FreeWRL logo is based
on the Linux Penguin logo by Larry Ewing. All trademarks are owned
by their respective owners.
</SMALL>

<P>
FreeWRL is an <A HREF="http://www.opensource.org">open-source(R)</A>
<A HREF="http://www.vrml.org">VRML</A> 
browser written by Tuomas J. Lukka, John Stewart  and others,
placed under the Gnu Library General Public License.
It is written particularly
on/for Linux but runs also under other Unix operating systems
(e.g. Irix, OSF, Solaris) with little trouble. For the current version,
see the <A HREF="news.html">news page</A>. For release history,
see the file <A HREF="README.html">README</A>.
<P>
If you use FreeWRL in an interesting project, drop John Stewart a note (and a 
link if possible).
<P>
<SMALL>
<H2>Latest</H2>
Newest news (for the previous items, see the <A HREF="news.html">news page</A>)
__STOP__
.
$newest
.
<<'__STOP__'
</SMALL>
<P>
<H2>Features</H2>
FreeWRL is currently still in alpha stage but has several interesting
features:
<LIST>
<LI> A Descent(tm)-like FLY mode with full 6 degrees of freedom
 (with 12 keys to control movement).
<LI> A programmatic interface enabling you to make scripts to take
 snapshots of the world at specific times and places, e.g. for making
 a movie for non-VRML-enabled people.
<LI> Script node support for both Java and Javascript (as well as Perl)
<LI> TrueType(tm) font support using the <A HREF="http://www.freetype.org">
	FreeType</A> library 
<LI> <A HREF="http://www.opengl.org">OpenGL rendering</A> (on Linux
	using the 
	<A HREF="http://www.mesa3d.org">Mesa</A>
	library)
	-- which means hardware accelerated rendering on many systems.
<LI> Open, pluggable framework -- the browser, event model, backend and
 script engines can all be easily replaced with code to handle new interfaces,
 e.g. binary VRML, other 3D library interfaces, new scripting languages,
 whatever.
<LI> Support for most nodes, PROTOs (with events), and Inlines
<LI> Written mostly in <A HREF="http://www.perl.com/">Perl</A>, 
	allowing fast prototyping of possible
 extensions as well as concise code. (Which other language would
 enable one person to write a nearly complete browser in just a couple
 of months in his spare time?)
<LI> Support for __XSWALLOW__ for embedding into Netscape (see the screenshot)
</LIST>

<P>
<H2>Downsides</H2>
For fairness sake, here is the list of current downsides, which I hope to eradicate
as soon as possible:
<LIST>
<LI> Some nodes and features are currently only partially implemented
 -- You can help me. Report the nodes and features 
 I haven't yet completely implemented and you
 need right now -- or even send a patch
<LI> Uses external libraries which you may have to compile separately
     (JPEG, FreeType)
<LI> No binary distributions yet
<LI> Incomplete EAI implementation (work is in progress)
</LIST>

<P>
<H2>Contact</H2>
If you want to help, please email John Stewart 
at John.Stewart@crc.ca.
<P>
If you want to get email when I release a new version, please mail
me to be added to the list.
<P>
<P>
__STOP__
);

sub writepage {
my($file, $title,$text) = @_;
for(keys %links) {
	$text =~ s/$_/$links{$_}/g;
}
open HT, ">$file" or die" Couldn't write to $file\n";
print HT "
<HTML>
<HEAD>
 <TITLE> $title </TITLE>
</HEAD>
<BODY BGCOLOR=\"#FFFFFF\">
<TABLE>
<TR VALIGN=TOP>
<TD ALIGN=LEFT>
</TD>
<TD></TD>

<TD ALIGN=LEFT>
";

print HT "
<H1><IMG SRC=\"freewrl.gif\" ALIGN=\"MIDDLE\" HSPACE=50></H1>
";

print HT "
</TD>
</TR>

<TR>
<TD ALIGN=LEFT VALIGN=TOP>
<SMALL>
";
my $indent=0;
for(@menu) {
	# print "menu $_->[0]\n";
	if($_->[0] eq "XX1") {
		print HT "<BR>*&nbsp;$_->[1]<BR>";
		$indent+=4;
	} elsif($_->[0] eq "XX2") {
		# print HT "<BR>";
		$indent-=4;
	} else {
		if(!defined $_->[1]) {$_->[1] = $_->[0]}
		my $id = "&nbsp"x$indent;
		print HT "$id*&nbsp;<A HREF=$_->[1]>$_->[0]</A><BR>";
	}
}
print HT "
</SMALL>

</TD>
<TD ALIGN=LEFT>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </TD>
<TD ALIGN=LEFT>
<H1> $title </H1>
$text
</TD>
</TR>
</TABLE>
</BODY>
</HTML>
";

close HT;

}
