/*-----------------------------------------------------------------

    GEM - Graphics Environment for Multimedia

    Load an video into a pix block

    Copyright (c) 1997-1999 Mark Danks. mark@danks.org
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_PIX_VIDEO_H_
#define INCLUDE_PIX_VIDEO_H_

#include "Base/GemBase.h"
#include "Base/GemState.h"

#ifdef _WINDOWS
#include <vfw.h>
#else
#error No movie defined for OS
#endif

#include "Base/GemPixUtil.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
	pix_movie
    
    Loads in a movie
    
KEYWORDS
    pix
    
DESCRIPTION

-----------------------------------------------------------------*/
class GEM_EXTERN pix_movie : public GemBase
{
    CPPEXTERN_HEADER(pix_movie, GemBase)

    public:

        //////////
        // Constructor
    	pix_movie(t_symbol *filename);
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~pix_movie();

		//////////
		// open a movie up
		void			openMess(t_symbol *filename);

    	//////////
    	// Do the rendering
    	virtual void 	render(GemState *state);

    	//////////
    	// Clear the dirty flag on the pixBlock
    	virtual void 	postrender(GemState *state);

    	//////////
    	virtual void	startRendering();

    	//////////
    	// Delete texture object
    	virtual void	stopRendering();
    	
    	//////////
		void			setUpTextureState();

    	//////////
    	// Change which image to display
    	void	    	changeImage(int imgNum);
    
			//-----------------------------------
			// GROUP:	Movie data
			//-----------------------------------
    
    	//////////
    	// The texture coordinates
		TexCoord    	m_coords[4];
    	
     	//////////
    	// If a movie was loaded
    	int 	    	m_haveMovie;
    	
    	//////////
    	// The pixBlock with the current image
    	pixBlock    	m_pixBlock;
    	
    	//////////
    	// Should swap the pixels?
    	int 	    	m_swap;
    	 
    	//////////
    	// Do we have to color swap?
    	int 	    	m_colorSwap;
    	
    	//////////
    	// The currently requested frame
    	int 	    	m_reqFrame;

    	//////////
    	// The real current frame
    	int 	    	m_curFrame;

    	//////////
    	// The texture object number
    	GLuint	    	m_textureObj;
    	
		//////////
		// The size of the texture (so we can use sub image)
		int				m_dataSize[3];

		int				m_xsize;
		float			m_xRatio;
		int				m_ysize;
		float			m_yRatio;
		/////////
		// The length, in frames, of the movie
		int				m_numFrames;

#ifdef _WINDOWS
		PGETFRAME		m_getFrame;			// the frame information
		PAVISTREAM		m_streamVid;		// the stream itself
#else
#error Define pix_movie for this OS
#endif
	
	private:

    	//////////
    	// static member functions
    	static void 	openMessCallback(void *data, t_symbol *filename);
    	static void 	changeImageCallback(void *data, t_floatarg imgNum);
};

#endif	// for header file
