/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2                                                       *
 * Modul:     menue.c                                                        *
 *            Build GTK menu for paul (more or less useful for i18n support  *
 *            to avoid doubling of strings                                   *
 * Author:    Andreas Tille                                                  *
 * Date:      14.03.1999                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <ctype.h>
#include "paul.h"
#include "callback.h"
#include "names.h"
 
typedef struct { 
  const char            *menu,    /* main menu entry; if NULL set this entry for            *
                                   * This/Mark/All according to the content of what         */
                        *sub;     /* sub menu entry, if NULL it is just the main menu entry */
  gchar                  accel;   /* Accelerator, prepend <control> if menu is NULL, else   *
                                   * take it for "This", prepend "<shift>" for "Marked" and *
                                   * prepend "<shift><control>" for "All"                   */
  GtkItemFactoryCallback callback;/* Callback for this menu item, if NULL assume separator  *
                                   * inside "File" or a branch inside This/Mark/All         */
  int                    what;    /* What section This/Mark/All                             */
} MENUPREP;


static int SetSingleItem(GtkItemFactory *items, GtkItemFactoryEntry *e, PAUL *p)
{
  gtk_item_factory_create_item(items, e, p, 1);
  FREE(e->path);
  FREE(e->accelerator);
  return RET_OK;
}

static int SetEntry(GtkItemFactory *items, MENUPREP *mp, PAUL *p) 
/* Builds item factory entry after certain rules
 * --- Parameter: ---
 * GtkItemFactory *items       : item entry(s) to set
 * MENUPREP       *mp          : rules for item preparation
 * PAUL           *p           : PAUL ... callback_data to set
 * --- Return: ---
 * int             MySetEntry(): RET_ERR or RET_OK
 */
{
  const gchar        *main_men[3] = { This, Marked, All };
  GtkItemFactoryEntry e[1] = { {NULL, NULL, NULL, 0, NULL} };

  g_return_val_if_fail ( items, RET_ERR ) ;
  g_return_val_if_fail ( GTK_IS_ITEM_FACTORY(items), RET_ERR ) ;
  g_return_val_if_fail ( IS_PAUL(p), RET_ERR ) ;
  
  if ( mp->accel < 0 && mp->what < 0 ) return 0;
  
  if ( mp->callback ) e->callback  = mp->callback;

  if ( mp->menu ) {  /* File, Parameters or Help */
    if ( !mp->sub ) {
      e->path        = g_strdup_printf("/_%s", mp->menu);
      e->item_type   = "<Branch>";
    } else {
      e->path        = g_strdup_printf("/%s/%s", mp->menu, mp->sub);
      if ( mp->accel )    e->accelerator = g_strdup_printf("<control>%c", mp->accel);
      if ( !*(mp->sub) )  e->item_type   = "<Separator>";
    }
    return SetSingleItem(items, e, p);
  }

  /* This/Marked/All sub menu */

  if ( mp->what & THIS ) {
    e->path          = g_strdup_printf("/%s/%s", main_men[0], mp->sub);
    e->accelerator   = g_strdup_printf("%c", mp->accel);
    if ( mp->what ) e->callback_action = mp->what & ~(MARK|ALL);
    SetSingleItem(items, e, p);
  }
  if ( mp->what & MARK ) {
    e->path          = g_strdup_printf("/%s/%s", main_men[1], mp->sub);
    e->accelerator   = g_strdup_printf("<shift>%c", toupper(mp->accel));
    if ( mp->what ) e->callback_action = mp->what & ~(THIS|ALL);
    SetSingleItem(items, e, p);
  }
  if ( mp->what & ALL  ) {
    e->path          = g_strdup_printf("/%s/%s", main_men[2], mp->sub);
    e->accelerator   = g_strdup_printf("<shift><control>%c", toupper(mp->accel));
    if ( mp->what ) e->callback_action = mp->what & ~(THIS|MARK);
    SetSingleItem(items, e, p);
  }
  return RET_OK;
}

int BuildMenu(PAUL *p)
{
  MENUPREP            *mp,
                       menu_prep[] = {
     { File,       NULL,          0, NULL,                    0 },
     { File,       _Open,       'O', FileLoad,                0 },
     { File,       _Save,       'S', FileSave,                0 },
     { File,       Save_As,     'A', FileSaveAs,              0 },
     { File,       Save_All,    'V', FilesSaveAll,            0 },
     { File,       _Delete,     'D', FileDelete,              0 },
     { File,       "",            0, NULL,                    0 }, 
     { File,       _Info,       'I', FileInfo,                0 },
#ifdef PHYSICAL_PAUL
     { File,       _Load_phys,  'L', LoadPhysical,            0 },
#endif
     { File,       "",            0, NULL,                    0 },
     { File,       _Quit,       'Q', PaulExit,                0 },

     { NULL,       Contr_ast,   'a', ScaleCallback,           THIS|MARK|ALL },
     { NULL,       _Brightness, 'b', BrightnessCallback,      THIS|MARK|ALL },
     { NULL,       _Cut,        'c', CutCallback,             THIS|MARK|ALL },
     { NULL,       _Difference, 'd', DifferenceCallback,      THIS|MARK|ALL },
     { NULL,       Diff_erence, 'e', QueueDifferenceCallback, ALL },
     { NULL,       FF_T,        't', FFTCallback,             THIS|MARK|ALL },
     { NULL,       _Filter,     'f', FilterCallback,          THIS|MARK|ALL },
     { NULL,       _Monochrome, 'g', MonochromeCallback,      THIS|MARK|ALL },
     { NULL,       _Histogram,  'h', HistogramCallback,       THIS|MARK|ALL },
     { NULL,       _Insert,     'i', ThisInsertCallback,      THIS },
     { NULL,       _Mirror_h,   'w', MirrorCallback,          THIS|MARK|ALL|MIRROR_H },
     { NULL,       _Mirror_v,   'v', MirrorCallback,          THIS|MARK|ALL|MIRROR_V },
     { NULL,       Mo_ve,       'm', MoveImageCallback,       THIS|MARK|ALL },
     { NULL,       _Negativ,    'n', NegativCallback,         THIS|MARK|ALL },
     { NULL,       R_otate_90,  'x', RotateCallback,          THIS|MARK|ALL|ROT_90 },
     { NULL,       R_otate_180, 'y', RotateCallback,          THIS|MARK|ALL|ROT_180 },
     { NULL,       R_otate_270, 'z', RotateCallback,          THIS|MARK|ALL|ROT_270 },
     { NULL,       _Remove_bo_b,'r', DelBorderCallback,       THIS|MARK|ALL },
     { NULL,       _Remove_bo_w,'s', DelScanBorderCallback,   THIS|MARK|ALL },
     { NULL,       _Shrink,     'k', ShrinkCallback,          THIS|MARK|ALL },

     { Parameters, NULL,          0, NULL,                           0 },
     { Parameters, Animation_t,   0, AnimationTimeParameterCallback, 0 },
     { Parameters, Contr_ast,     0, ScaleParameterCallback,         0 },
     { Parameters, _Brightness,   0, BrightnessParameterCallback,    0 },
     { Parameters, _Difference,   0, DifferenceParameterCallback,    0 },
     { Parameters, _Filter,       0, FilterParameterCallback,        0 },
     { Parameters, _Monochrome,   0, GrayParameterCallback,          0 },
     { Parameters, _Remove_bo,    0, DelBorderParameterCallback,     0 },
     { Parameters, _Shrink,       0, ShrinkParameterCallback,        0 },

     { Help,       NULL,          0, NULL,                           0 },
     { Help,       Dn_hesitate,   0, NULL,                           0 },
     { NULL,       NULL,         -1, NULL,                          -1 },
  };

  g_return_val_if_fail ( IS_PAUL(p), RET_ERR );
  g_return_val_if_fail ( p->items, RET_ERR );
  g_return_val_if_fail ( GTK_IS_ITEM_FACTORY(p->items), RET_ERR );
  
  for ( mp = menu_prep; mp->accel >= 0 && mp->what >= 0; mp++ )
    g_return_val_if_fail ( SetEntry(p->items, mp, p) == RET_OK, RET_ERR ) ;
  return RET_OK;
}
