/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogMerge.h"
#include "GuiDialogPreview.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "MathTrig.h"
#include "TFGui.h"
#include "TFWindowHandler.h"			// circular 


#if 0
// dummy table to trick xgettext into extracting the translatable strings
char *foobar[] = {
				N_("Add"),
				N_("Subtract"),
				N_("Multiply"),
				N_("Divide"),
				N_("Minimum"),
				N_("Maximum"),
};
#endif


/*
 *  constructor: initialize all data members 
 */
TFDialogMerge::TFDialogMerge (FlexArray *winList)
	        : GuiDialogOAC (_("Terraform Merge Dialog"), _("Merge Parameters")),
		  d_vBox1 (TRUE, 0),
		  d_vBox2 (FALSE, 0),
		  d_vBox3 (TRUE, 0),
		  d_vBox4 (TRUE, 0),
		  d_hbMain (FALSE, 10),
		  d_hbFactor1 (TRUE, 5),
		  d_hbFactor2 (TRUE, 5)
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogMerge\n");

	SanityCheck::bailout ((!winList), "winList==NULL", "TFDialogMerge::TFDialogMerge");

	d_lastSelect = -1;
	d_winList = winList;

	p_adjFactor1 = new Gtk_Adjustment (1.0, 0.01, 1, 0.01),
	p_adjFactor2 = new Gtk_Adjustment (1.0, 0.01, 1, 0.01),

	p_hsFactor1 = new Gtk_HScale (*p_adjFactor1),
	p_hsFactor2 = new Gtk_HScale (*p_adjFactor2),

	p_cList = NULL;
	p_cmbMethod = NULL;
	p_glstMethod = NULL;
	p_scrolledWin = NULL;
	p_pvwFrame1 = p_pvwFrame2 = p_pvwFrame3 = NULL;
	p_drawArea1 = p_drawArea2 = p_drawArea3 = NULL;
	p_pixmap1 = p_pixmap2 = NULL;
	p_HF1 = p_HF2 = p_HF3 = NULL;
	p_HFD1 = p_HFD2 = p_HFD3 = NULL;
	p_drawArea1 = p_drawArea2 = p_drawArea3 = NULL;

	buildDialogWindow ();
	initHeightFields ();
	//sprintf (this->p_windowTitle, "Merge: %s", p_HF1->getName());
	//this->set_title (this->p_windowTitle);
	GuiDialogPreview::iterateEvents ();
	updatePreviewCallback ();

	connect_to_method (p_adjFactor1->value_changed, this, &TFDialogMerge::updatePreviewCallback);
	connect_to_method (p_adjFactor2->value_changed, this, &TFDialogMerge::updatePreviewCallback);
	connect_to_method (p_cmbMethod->get_list()->selection_changed, this, &TFDialogMerge::updatePreviewCallback);
	connect_to_method (p_cList->select_row, this, &TFDialogMerge::rowSelectedCallback);
	connect_to_method (d_btn1.clicked, this, &TFDialogMerge::button1Callback);
	connect_to_method (d_btn2.clicked, this, &TFDialogMerge::button2Callback);
	//connect_to_method (p_cList->button_press_event, this, &TFDialogMerge::processCListButtonPress);
}


/*
 *  destructor: clean up 
 */
TFDialogMerge::~TFDialogMerge ()
{
	delete p_adjFactor1;
	delete p_adjFactor2;
	delete p_hsFactor1;
	delete p_hsFactor2;
	delete p_scrolledWin;
	delete p_pvwFrame1;
	delete p_pvwFrame2;
	delete p_pvwFrame3;
	delete p_cmbMethod;
	delete p_cList;
	delete p_drawArea1;
	delete p_drawArea2;
	delete p_drawArea3;
	delete p_pixmap1;
	delete p_pixmap2;
	delete p_packSourceMain;
	delete p_packSourceGrp1;
	delete p_packSourceGrp2;
	delete p_packAssignButtons;

	if (p_HF1Preview)
		delete p_HF1Preview;
	if (p_HF2Preview)
		delete p_HF2Preview;
	if (p_HF3Preview)
		delete p_HF3Preview;

	if (p_HFD1Preview)
		delete p_HFD1Preview;
	if (p_HFD2Preview)
		delete p_HFD2Preview;
	if (p_HFD3Preview)
		delete p_HFD3Preview;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogMerge\n");
}


/*
 *  initHeightFields: initialize the HeightFields
 */
void TFDialogMerge::initHeightFields (TFWindowHandler *TFWHseed)
{
	SanityCheck::bailout ((!p_cList), "p_cList==NULL", "TFDialogMerge::initHeightFields");

	int 			c=0;
	TFWindowHandler		*TFWH;
	HeightFieldOps		*HFO;

	if (p_cList->rows() == 0)
		return;

	// get HF and HFD from CList row data items
	if (TFWHseed)
		TFWH = TFWHseed;
	else
		TFWH = static_cast<TFWindowHandler*>(p_cList->get_row_data(0));
	p_HF1 = TFWH->getHeightField();
	p_HFD1 = TFWH->getHeightFieldDraw();

	if (p_cList->rows() == 1)
		{
		p_HF2 = p_HF1;
		p_HFD2 = p_HFD1;
		}
	else
		{
		if (TFWHseed)
		    {
		    // find first HF in CList which is != TFWHseed
		    do 
			{
			TFWH = static_cast<TFWindowHandler*>(p_cList->get_row_data(c++));
			}
		    while (TFWH == TFWHseed);
		    }
		else
			TFWH = static_cast<TFWindowHandler*>(p_cList->get_row_data(1));

		p_HF2 = TFWH->getHeightField();
		p_HFD2 = TFWH->getHeightFieldDraw();
		}

	// clean up 
	if (p_HF1Preview)
		delete p_HF1Preview;
	if (p_HF2Preview)
		delete p_HF2Preview;
	if (p_HF3Preview)
		delete p_HF3Preview;

	if (p_HFD1Preview)
		delete p_HFD1Preview;
	if (p_HFD2Preview)
		delete p_HFD2Preview;
	if (p_HFD3Preview)
		delete p_HFD3Preview;

	// create the reduced Preview HFs and create HFDs for them
	p_frmGrp1->set_label (p_HF1->getName());
	HFO = new HeightFieldOps (p_HF1);
	p_HF1Preview = HFO->hfResize (100, 100);
	delete HFO;
	p_HFD1Preview = new HeightFieldDraw (p_HF1Preview, p_drawArea1);
	p_HFD1Preview->setMode ("0");
	p_HFD1Preview->setColormap (p_HFD1->getColormap());

	p_frmGrp2->set_label (p_HF2->getName());
	HFO = new HeightFieldOps (p_HF2);
	p_HF2Preview = HFO->hfResize (100, 100);
	delete HFO;
	p_HFD2Preview = new HeightFieldDraw (p_HF2Preview, p_drawArea2);
	p_HFD2Preview->setMode ("0");
	p_HFD2Preview->setColormap (p_HFD2->getColormap());

	p_HF3Preview = HeightFieldOps::merge('+',p_HF1Preview,p_HF2Preview,1,1);
	p_HFD3Preview = new HeightFieldDraw (p_HF3Preview, p_drawArea3);
	p_HFD3Preview->setMode ("0");
	p_HFD3Preview->setColormap (p_HFD1->getColormap());

	Gtk_Main *gtkMain = Gtk_Main::instance();
        while (gtkMain->events_pending())
                gtkMain->iteration ();

	p_HFD1Preview->draw ();
	p_HFD2Preview->draw ();
	p_HFD3Preview->draw ();
}


/*
 *  rebuildCList: rebuild the CList message from the TFGui:: source
 */
void TFDialogMerge::rebuildCList ()
{
	FlexArray	*winList = TFGui::getWindowList ();
	TFWindowHandler	*TFWH;
	char		*name;
	int		i, row, lim;

	SanityCheck::bailout ((!p_cList), "p_cList==NULL", "TFDialogMerge::rebuildCList");
	SanityCheck::bailout ((!winList), "winList==NULL", "TFDialogMerge::rebuildCList");

	lim = winList->getSize ();
	p_cList->freeze ();
	p_cList->clear();
	for (i=0; i<lim; i++)
		{
		TFWH = static_cast<TFWindowHandler*>(winList->El(i));
		name = TFWH->getHeightField()->getName ();
		row = p_cList->append (const_cast<const char**>(&name));
		p_cList->set_row_data (row, TFWH);
		}
	p_cList->thaw ();
}


/*
 *  insertCList: add the clist to the first vbox
 */
void TFDialogMerge::insertCList ()
{
	p_scrolledWin = new Gtk_ScrolledWindow ();
	p_scrolledWin->set_border_width (2);
	p_scrolledWin->set_policy (GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	p_cList = new Gtk_CList (1);
	p_cList->set_column_title (0, "Terrain Object List");
	p_cList->column_titles_show ();
	p_cList->set_shadow_type (GTK_SHADOW_OUT);

	p_scrolledWin->add (*p_cList);
	d_vBox1.pack_start (*p_scrolledWin, TRUE, TRUE, 0);
	d_hbMain.pack_start (d_vBox1, TRUE, TRUE, 10);

	p_cList->show ();
	p_scrolledWin->show ();
	d_vBox1.show ();
	d_hbMain.show();
}


/*
 *  insertAssignButtons: insert the buttons you press to assigb a height field
 */
void TFDialogMerge::insertAssignButtons ()
{
	string		*s;
	char		t[256];

	p_packAssignButtons = new Gtk_Packer (),
	sprintf (t, "%s/%s", TF_DATADIR, "arrow_right.xpm");
	s = new string (t);
	p_pixmap1 = new Gtk_Pixmap (*this, *s);
	d_btn1.add (p_pixmap1);
	p_pixmap1->show ();
	p_packAssignButtons->add (d_btn1, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_PACK_EXPAND);
	d_btn1.show ();

	p_pixmap2 = new Gtk_Pixmap (*this, *s);
	d_btn2.add (p_pixmap2);
	p_pixmap2->show ();
	p_packAssignButtons->add (d_btn2, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_PACK_EXPAND);
	d_btn2.show ();
	delete s;

	d_hbMain.pack_start (*p_packAssignButtons, FALSE, FALSE, 10);
	p_packAssignButtons->show ();
	d_hbMain.show();
}


/*
 *  insertSourcePreviews: insert the preview into the main frame/vbox
 */
void TFDialogMerge::insertSourcePreviews ()
{

	p_packSourceMain = new Gtk_Packer (),
	p_packSourceGrp1 = new Gtk_Packer (),
	p_packSourceGrp2 = new Gtk_Packer ();
	p_frmGrp1 = new Gtk_Frame ("Source 1"),
	p_frmGrp2 = new Gtk_Frame ("Source 2");

	// bounding frame for 1st group
	p_frmGrp1->add (*p_packSourceGrp1);
	p_frmGrp1->set_shadow_type (GTK_SHADOW_ETCHED_IN);
	p_frmGrp1->set_border_width (10);
	p_packSourceGrp1->show ();

	// build 1st source preview drawing area 
	p_pvwFrame1 = new Gtk_Frame ();
	p_pvwFrame1->set_shadow_type (GTK_SHADOW_ETCHED_IN);
	p_pvwFrame1->set_border_width (2);
	p_packSourceGrp1->add (*p_pvwFrame1, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0);
	p_pvwFrame1->show ();

	p_drawArea1 = new GuiBufferedDrawingArea ();
	p_drawArea1->setSync (0);
	p_pvwFrame1->add (*p_drawArea1);
	p_drawArea1->show ();
	p_drawArea1->set_usize (100, 100);

	// hscale for 1st preview 
	p_hsFactor1->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsFactor1->set_digits (2);
	p_hsFactor1->set_draw_value (TRUE);
	p_packSourceGrp1->add (*p_hsFactor1, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_FILL_X);
	p_hsFactor1->show ();
	p_packSourceMain->add (*p_frmGrp1, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_FILL_X);
	p_frmGrp1->show ();


	// build dropdown list of operations
	p_cmbMethod = new Gtk_Combo ();
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_MERGE_ADD)));
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_MERGE_SUB)));
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_MERGE_MULT)));
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_MERGE_DIV)));
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_MERGE_MIN)));
	p_glstMethod = g_list_append (p_glstMethod, const_cast<char*>(_(MENU_MERGE_MAX)));
	p_cmbMethod->set_popdown_strings (p_glstMethod);
	p_cmbMethod->get_entry()->set_text (_(MENU_MERGE_ADD));
	p_cmbMethod->get_entry()->set_editable (FALSE);
	//d_vBox2.pack_start (*p_cmbMethod, FALSE, FALSE, 0);
	p_packSourceMain->add (*p_cmbMethod, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_PACK_EXPAND);
	p_cmbMethod->show ();


	// bounding frame for 2nd group
	p_frmGrp2->add (*p_packSourceGrp2);
	p_frmGrp2->set_shadow_type (GTK_SHADOW_ETCHED_IN);
	p_frmGrp2->set_border_width (10);
	p_packSourceGrp2->show ();

	// build 2nd source preview drawing area 
	p_pvwFrame2 = new Gtk_Frame ();
	p_pvwFrame2->set_shadow_type (GTK_SHADOW_ETCHED_IN);
	p_pvwFrame2->set_border_width (10);
	p_packSourceGrp2->add (*p_pvwFrame2, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, (GtkPackerOptions)0);
	p_pvwFrame2->show ();

	p_drawArea2 = new GuiBufferedDrawingArea ();
	p_drawArea2->setSync (0);
	p_pvwFrame2->add (*p_drawArea2);
	p_drawArea2->show ();
	p_drawArea2->set_usize (100, 100);

	// hscale for 2nd preview 
	p_hsFactor2->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsFactor2->set_digits (2);
	p_hsFactor2->set_draw_value (TRUE);
	p_packSourceGrp2->add (*p_hsFactor2, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_FILL_X);
	p_hsFactor2->show ();
	p_packSourceMain->add (*p_frmGrp2, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_FILL_X);
	p_frmGrp2->show ();


	d_hbMain.pack_start (*p_packSourceMain, FALSE, FALSE, 10);
	p_packSourceMain->show ();
}


/*
 *  insertDestPreviews: insert the preview into the main frame/vbox
 */
void TFDialogMerge::insertDestPreviews ()
{
	Gtk_Frame	*destFrame = new Gtk_Frame (_("Result"));
	Gtk_VBox	*destVBox = new Gtk_VBox (TRUE, 5);

	// build title frame
	destVBox->pack_start (*destFrame, FALSE, FALSE, 10);
	destFrame->show ();
	destFrame->set_border_width (5);
	destFrame->add (d_vBox3);
	d_vBox3.show ();

	// build dest preview drawing area 
	p_pvwFrame3 = new Gtk_Frame ();
	p_pvwFrame3->set_shadow_type (GTK_SHADOW_ETCHED_IN);
	p_pvwFrame3->set_border_width (2);
	d_vBox3.pack_start (*p_pvwFrame3, FALSE, FALSE, 0);
	p_pvwFrame3->show ();

	p_drawArea3 = new GuiBufferedDrawingArea ();
	p_drawArea3->setSync (0);
	p_pvwFrame3->add (*p_drawArea3);
	p_drawArea3->show ();
	p_drawArea3->set_usize (100, 100);

	d_hbMain.pack_start (*destVBox, FALSE, FALSE, 10);
	destVBox->show ();

}


/*
 *  buildDialogWindow: build the dialog window from it's components
 */
void TFDialogMerge::buildDialogWindow ()
{
	this->set_usize (600, 500);

	this->get_vbox()->set_border_width (2);
	setupVBox ();

	SanityCheck::bailout ((!this->p_frmBase), "this->p_frmBase==NULL", "TFDialogMerge::buildDialogWindow");
	this->p_frmBase->add (d_hbMain);

	insertCList ();
	insertAssignButtons ();
	insertSourcePreviews ();
	insertDestPreviews ();
	this->fillActionArea ();
	rebuildCList ();

	this->show ();
}


/*
 *  button1Callback: process the 1st callback button
 */
void TFDialogMerge::rowSelectedCallback (int row, int col, GdkEvent *e)
{
	if (TFGui::getWindowList()->getSize() != p_cList->rows())
		{
		rebuildCList ();
		initHeightFields ();
		}

	d_lastSelect = row;
}


/*
 *  button1Callback: process the 1st callback button
 */
void TFDialogMerge::button1Callback ()
{
	TFWindowHandler		*TFWH;
	HeightFieldOps		*HFO;

	if (TFGui::getWindowList()->getSize() != p_cList->rows())
		{
		rebuildCList ();
		initHeightFields ();
		}

	if (d_lastSelect == -1)
		return;

	TFWH = static_cast<TFWindowHandler*>(p_cList->get_row_data(d_lastSelect));
	p_HF1 = TFWH->getHeightField();
	p_frmGrp1->set_label (p_HF1->getName());
	HFO = new HeightFieldOps (p_HF1);
	p_HF1Preview = HFO->hfResize (100, 100);
	delete HFO;

	// allow frame title to change 
	Gtk_Main *gtkMain = Gtk_Main::instance();
        while (gtkMain->events_pending())
                gtkMain->iteration ();

	p_HFD1Preview = new HeightFieldDraw (p_HF1Preview, p_drawArea1);
	p_HFD1Preview->setMode ("0");
	p_HFD1Preview->setColormap (p_HFD1->getColormap());
	p_HFD1Preview->draw ();
	updatePreviewCallback ();
}


/*
 *  button2Callback: process the 2nd callback button
 */
void TFDialogMerge::button2Callback ()
{
	TFWindowHandler		*TFWH;
	HeightFieldOps		*HFO;

	if (TFGui::getWindowList()->getSize() != p_cList->rows())
		{
		rebuildCList ();
		initHeightFields ();
		}

	if (d_lastSelect == -1)
		return;

	TFWH = static_cast<TFWindowHandler*>(p_cList->get_row_data(d_lastSelect));
	p_HF2 = TFWH->getHeightField();
	p_frmGrp2->set_label (p_HF2->getName());
	HFO = new HeightFieldOps (p_HF2);
	p_HF2Preview = HFO->hfResize (100, 100);
	delete HFO;

	// allow frame title to change 
	Gtk_Main *gtkMain = Gtk_Main::instance();
        while (gtkMain->events_pending())
                gtkMain->iteration ();

	p_HFD2Preview = new HeightFieldDraw (p_HF2Preview, p_drawArea2);
	p_HFD2Preview->setMode ("0");
	p_HFD2Preview->setColormap (p_HFD2->getColormap());
	p_HFD2Preview->draw ();
	updatePreviewCallback ();
}


/*
 *  processCListButtonPress: process a button press on the CList
 */
gint TFDialogMerge::processCListButtonPress (GdkEventButton *e)
{
	return 0;
}


/*
 *  buttonCallbackApply: roughen the Height Field
 */
void TFDialogMerge::buttonCallbackApply ()
{
	char		op;
	float		factor1, factor2;
	string		entry;

	SanityCheck::bailout ((!p_cList), "p_cList==NULL", "TFDialogMerge::rebuildCList");
	SanityCheck::bailout ((!p_HF1), "p_HF1==NULL", "TFDialogMerge::updatePreviewCallback");
	SanityCheck::bailout ((!p_HF2), "p_HF2==NULL", "TFDialogMerge::updatePreviewCallback");
	SanityCheck::bailout ((!p_HF3Preview), "p_HF3Preview==NULL", "TFDialogMerge::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFD3Preview), "p_HFD3Preview==NULL", "TFDialogMerge::updatePreviewCallback");

	factor1 = p_adjFactor1->get_value ();
	factor2 = p_adjFactor2->get_value ();
	entry = (p_cmbMethod->get_entry())->get_text();
	if (entry == MENU_MERGE_ADD)
		op = '+';
	else
	if (entry == MENU_MERGE_SUB)
		op = '-';
	else
	if (entry == MENU_MERGE_MULT)
		op = '*';
	else
	if (entry == MENU_MERGE_DIV)
		op = '/';
	else
	if (entry == MENU_MERGE_MIN)
		op = 'm';
	else
	if (entry == MENU_MERGE_MAX)
		op = 'M';

	if (!(p_HF3 = HeightFieldOps::merge (op, p_HF1, p_HF2, factor1, factor2)))
		{
		SanityCheck::warning ((TRUE), "Height Field Merge failed ...\n", "TFDialogMerge::buttonCallbackApply");
		return;
		}

	p_HF3->setName (HeightField::getNewName());
	TFGui::addHeightField (p_HF3);

	// only do this if window stays open 
	if (b_applyHit)
		updatePreviewCallback ();

	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a slider has been updated.
 */
void TFDialogMerge::updatePreviewCallback ()
{
	char		op;
	float		factor1, factor2;
	string		entry;
	FlexArray	*winList = TFGui::getWindowList ();

	SanityCheck::bailout ((!p_cList), "p_cList==NULL", "TFDialogMerge::rebuildCList");
	SanityCheck::bailout ((!winList), "winList==NULL", "TFDialogMerge::rebuildCList");
	SanityCheck::bailout ((!p_HF3Preview), "p_HF3Preview==NULL", "TFDialogMerge::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFD3Preview), "p_HFD3Preview==NULL", "TFDialogMerge::updatePreviewCallback");

	if (winList->getSize() != p_cList->rows())
		{
		rebuildCList ();
		initHeightFields ();
		}

	factor1 = p_adjFactor1->get_value ();
	factor2 = p_adjFactor2->get_value ();
	entry = (p_cmbMethod->get_entry())->get_text();
	if (entry == MENU_MERGE_ADD)
		op = '+';
	else
	if (entry == MENU_MERGE_SUB)
		op = '-';
	else
	if (entry == MENU_MERGE_MULT)
		op = '*';
	else
	if (entry == MENU_MERGE_DIV)
		op = '/';
	else
	if (entry == MENU_MERGE_MIN)
		op = 'm';
	else
	if (entry == MENU_MERGE_MAX)
		op = 'M';

	if (p_HF3Preview)
		delete p_HF3Preview;
	if (p_HFD3Preview)
		delete p_HFD3Preview;

	p_HF3Preview = HeightFieldOps::merge (op, p_HF1Preview, p_HF2Preview, 
						factor1, factor2);
	p_HFD3Preview = new HeightFieldDraw (p_HF3Preview, p_drawArea3);
	p_HFD3Preview->setMode ("0");
	p_HFD3Preview->setColormap (p_HFD1->getColormap());
	p_HFD3Preview->draw ();
}


/*
 *  (virtual) delete_event_impl: provide a function to hande window close
 *                               request
 */
gint TFDialogMerge::delete_event_impl (GdkEventAny *e)
{
	this->hide ();
	return (0);
}

