# Makefile for zgv binary distribution

# Set BINDIR to directory for binaries,
# INFODIR to directory for info files,
# MANDIR to directory for man page.
# Usually it will be simpler to just set PREFIX.
#
PREFIX=/usr

BINDIR=$(PREFIX)/bin
INFODIR=$(PREFIX)/info
MANDIR=$(PREFIX)/man/man1

# Normally `make install' will update your `dir' file (in INFODIR),
# using a copy of texinfo's `install-info' bundled with zgv.
#
# But if you have a different way of keeping `dir' up-to-date (for
# example, perhaps your distribution automatically handles this for
# you) you should uncomment this to prevent `make install' doing that.
#
#INFO_DIR_UPDATE=no


# You shouldn't need to modify anything below this line.


all: install

install:
	install -m 4511 -o root -g root -s zgv $(BINDIR)
	install -m 444 doc/zgv.1 $(MANDIR)
	install -m 444 doc/zgv doc/zgv-? $(INFODIR)
# Update info `dir' file
# Info always uses a dir file in preference to a dir.gz, so we don't use
# dir.gz unless it's the only game in town.
ifneq ($(INFO_DIR_UPDATE),no)
	if [ -f $(INFODIR)/dir.gz -a ! -f $(INFODIR)/dir ]; then \
	  gzip -d $(INFODIR)/dir.gz; \
	  ./install-info doc/zgv $(INFODIR)/dir; \
	  gzip $(INFODIR)/dir; \
	else \
	  ./install-info doc/zgv $(INFODIR)/dir; \
	fi
endif
