// ---------------------------------------------------------------------------
// - Symbol.cpp                                                             -
// - aleph engine - symbol class implementation                             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Symbol.hpp"
#include "Exception.hpp"

namespace aleph {

  // create a new symbol by name

  Symbol::Symbol (const String& name) {
    d_name   = name;
    p_object = nilp;
    d_const  = false;
  }

  // create a symbol by name with an object

  Symbol::Symbol (const String& name, Object* object) {
    d_name   = name;
    p_object = Object::iref (object);
    d_const  = false;
  }

  // destroy this symbol

  Symbol::~Symbol (void) {
    Object::dref (p_object);
  }

  // return the class name

  String Symbol::repr (void) const {
    return "Symbol";
  }

  // set the const flag for this symbol

  void Symbol::setconst (const bool flag) {
    d_const = flag;
  }

  // set the object for this symbol

  void Symbol::setobj (Object* object) {
    // check for the const flag
    if (d_const == true)
      throw Exception ("const-error", "const violation for symbol", d_name);
    Object::iref (object);
    Object::dref (p_object);
    p_object = object;
  }

  // set this symbol as a const object

  Object* Symbol::cdef (Interp* interp, Nameset* nset, Object* object) {
    setobj   (object);
    d_const = true;
    return object;
  }

  // set this symbol with an object

  Object* Symbol::vdef (Interp* interp, Nameset* nset, Object* object) {
    setobj (object);
    return object;
  }

  // evaluate this object - this is like get object

  Object* Symbol::eval (Interp* interp, Nameset* nset) {
    return getobj ();
  }
}
