// ---------------------------------------------------------------------------
// - Method.cpp                                                              -
// - standard object library - generic method class implementation           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Method.hpp"

namespace aleph {

  // create a new method with a name

  Method::Method (const String& name, Object* object) {
    d_type = NAMED;
    d_name = name;
    p_object = Object::iref (object);
    p_method = nilp;
  }

  // create a new method with a quark

  Method::Method (const long quark, Object* object) {
    d_type = QUARK;
    d_quark = quark;
    p_object = Object::iref (object);
    p_method = nilp;
  }

  // create a new method with a method object

  Method::Method (Object* method, Object* object) {
    d_type = OBJECT;
    p_method = Object::iref (method);
    p_object = Object::iref (object);
  }

  // destroy this method

  Method::~Method (void) {
    Object::dref (p_method);
    Object::dref (p_object);
  }

  // return the class name

  String Method::repr (void) const {
    return "Method";
  }

  // apply this method with a set of arguments
  
  Object* Method::apply (Interp* interp, Nameset* nset, Cons* args) {
    Object* result = nilp;
    switch (d_type) {
    case Method::NAMED:
      result = p_object->apply (interp, nset, d_name, args);
      break;
    case Method::QUARK:
      result = p_object->apply (interp, nset, d_quark, args);
      break;
    case Method::OBJECT:
      result = p_object->apply (interp, nset, p_method, args);
      break;
    }
    return result;
  }
}
