// ---------------------------------------------------------------------------
// - t_nametable.cpp                                                         -
// - standard object library - name table class tester                       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2000 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "NameTable.hpp"

int main (int, char**) {
  using namespace aleph;

  NameTable* ntable = new NameTable;
  String*    hello  = new String ("hello");
  String*    world  = new String ("world");
  Object*    object = nilp;
  String*    string = nilp;

  // insert out favorite message
  ntable->add ("hello",hello);
  ntable->add ("world",world);

  // check for our keys
  if (ntable->exists ("hello") == false) return 1;
  if (ntable->exists ("world") == false) return 1;

  // get the first key
  object = ntable->get ("hello");
  string = dynamic_cast <String*> (object);

  // check for string
  if (string  == nilp)    return 1;
  if (*string != "hello") return 1;

  // get the second key
  object = ntable->get ("world");
  string = dynamic_cast <String*> (object);
  if (string  == nilp)    return 1;
  if (*string != "world") return 1;

  // get a vector of strings and check for data
  Strvec data = ntable->names ();
  if (data.length () != 2) return 1;

  // remove a key
  ntable->remove ("hello");
  if (ntable->exists ("hello") == true) return 1;

  // delete everything
  delete ntable;
  return 0;
}
