#ifndef _MISSING_H
#define _MISSING_H

#ifndef DeleteBitmap
#define DeleteBitmap(hbm)       DeleteObject((HGDIOBJ)(HBITMAP)(hbm))
#endif
#ifndef DeleteBrush
#define DeleteBrush(hbr)	DeleteObject((HGDIOBJ)(HBRUSH)(hbr))
#endif
#ifndef DeleteFont
#define DeleteFont(hfont)	DeleteObject((HGDIOBJ)(HFONT)(hfont))
#endif
#ifndef DeletePalette
#define DeletePalette(hpal)     DeleteObject((HGDIOBJ)(HPALETTE)(hpal))
#endif
#ifndef DeletePen
#define DeletePen(hpen)		DeleteObject((HGDIOBJ)(HPEN)(hpen))
#endif
#ifndef SelectBitmap
#define SelectBitmap(hdc, hbm)  ((HBITMAP)SelectObject((hdc), (HGDIOBJ)(HBITMAP)(hbm)))
#endif
#ifndef SelectBrush
#define SelectBrush(hdc, hbr)   ((HBRUSH)SelectObject((hdc), (HGDIOBJ)(HBRUSH)(hbr)))
#endif
#ifndef SelectFont
#define SelectFont(hdc, hfont)  ((HFONT)SelectObject((hdc), (HGDIOBJ)(HFONT)(hfont)))
#endif
#ifndef SelectPen
#define SelectPen(hdc, hpen)    ((HPEN)SelectObject((hdc), (HGDIOBJ)(HPEN)(hpen)))
#endif
#ifndef GetNextWindow
#define GetNextWindow(hWnd,wCmd) GetWindow((hWnd),(wCmd))
#endif
#ifndef GetStockBrush
#define GetStockBrush(i)     ((HBRUSH)GetStockObject(i))
#endif
#ifndef GetStockPen
#define GetStockPen(i)       ((HPEN)GetStockObject(i))
#endif


#define DM_SPECVERSION 0x0401

#define DMPAPER_ISO_B4              42	/* B4 (ISO) 250 x 353 mm              */
#define DMPAPER_JAPANESE_POSTCARD   43	/* Japanese Postcard 100 x 148 mm     */
#define DMPAPER_9X11                44	/* 9 x 11 in                          */
#define DMPAPER_10X11               45	/* 10 x 11 in                         */
#define DMPAPER_15X11               46	/* 15 x 11 in                         */
#define DMPAPER_ENV_INVITE          47	/* Envelope Invite 220 x 220 mm       */
#define DMPAPER_RESERVED_48         48	/* RESERVED--DO NOT USE               */
#define DMPAPER_RESERVED_49         49	/* RESERVED--DO NOT USE               */
#define DMPAPER_LETTER_EXTRA        50	/* Letter Extra 9 \275 x 12 in        */
#define DMPAPER_LEGAL_EXTRA         51	/* Legal Extra 9 \275 x 15 in         */
#define DMPAPER_TABLOID_EXTRA       52	/* Tabloid Extra 11.69 x 18 in        */
#define DMPAPER_A4_EXTRA            53	/* A4 Extra 9.27 x 12.69 in           */
#define DMPAPER_LETTER_TRANSVERSE   54	/* Letter Transverse 8 \275 x 11 in   */
#define DMPAPER_A4_TRANSVERSE       55	/* A4 Transverse 210 x 297 mm         */
#define DMPAPER_LETTER_EXTRA_TRANSVERSE 56	/* Letter Extra Transverse 9\275 x 12 in */
#define DMPAPER_A_PLUS              57	/* SuperA/SuperA/A4 227 x 356 mm      */
#define DMPAPER_B_PLUS              58	/* SuperB/SuperB/A3 305 x 487 mm      */
#define DMPAPER_LETTER_PLUS         59	/* Letter Plus 8.5 x 12.69 in         */
#define DMPAPER_A4_PLUS             60	/* A4 Plus 210 x 330 mm               */
#define DMPAPER_A5_TRANSVERSE       61	/* A5 Transverse 148 x 210 mm         */
#define DMPAPER_B5_TRANSVERSE       62	/* B5 (JIS) Transverse 182 x 257 mm   */
#define DMPAPER_A3_EXTRA            63	/* A3 Extra 322 x 445 mm              */
#define DMPAPER_A5_EXTRA            64	/* A5 Extra 174 x 235 mm              */
#define DMPAPER_B5_EXTRA            65	/* B5 (ISO) Extra 201 x 276 mm        */
#define DMPAPER_A2                  66	/* A2 420 x 594 mm                    */
#define DMPAPER_A3_TRANSVERSE       67	/* A3 Transverse 297 x 420 mm         */
#define DMPAPER_A3_EXTRA_TRANSVERSE 68	/* A3 Extra Transverse 322 x 445 mm   */
#define DMPAPER_LAST                DMPAPER_A3_EXTRA_TRANSVERSE

#define DMPAPER_USER                256

/* bin selections */
#define DMBIN_FIRST         DMBIN_UPPER
#define DMBIN_UPPER         1
#define DMBIN_ONLYONE       1
#define DMBIN_LOWER         2
#define DMBIN_MIDDLE        3
#define DMBIN_MANUAL        4
#define DMBIN_ENVELOPE      5
#define DMBIN_ENVMANUAL     6
#define DMBIN_AUTO          7
#define DMBIN_TRACTOR       8
#define DMBIN_SMALLFMT      9
#define DMBIN_LARGEFMT      10
#define DMBIN_LARGECAPACITY 11
#define DMBIN_CASSETTE      14
#define DMBIN_FORMSOURCE    15
#define DMBIN_LAST          DMBIN_FORMSOURCE

#define DMBIN_USER          256	/* device specific bins start here */

/* print qualities */
#define DMRES_DRAFT         (-1)
#define DMRES_LOW           (-2)
#define DMRES_MEDIUM        (-3)
#define DMRES_HIGH          (-4)

#define DMTT_DOWNLOAD_OUTLINE 4	/* download TT fonts as outline soft fonts */

/*
 * Access rights for printers
 */

#define PRINTER_ACCESS_ADMINISTER   0x00000004
#define PRINTER_ACCESS_USE          0x00000008

#define PRINTER_ALL_ACCESS    (STANDARD_RIGHTS_REQUIRED     |\
                               PRINTER_ACCESS_ADMINISTER    |\
                               PRINTER_ACCESS_USE)

#define PRINTER_READ          (STANDARD_RIGHTS_READ         |\
                               PRINTER_ACCESS_USE)

#define PRINTER_WRITE         (STANDARD_RIGHTS_WRITE        |\
                               PRINTER_ACCESS_USE)

#define PRINTER_EXECUTE       (STANDARD_RIGHTS_EXECUTE      |\
                               PRINTER_ACCESS_USE)

#define PRINTER_CONTROL_PAUSE            1
#define PRINTER_CONTROL_RESUME           2
#define PRINTER_CONTROL_PURGE            3
#define PRINTER_CONTROL_SET_STATUS       4

#define PRINTER_STATUS_PAUSED            0x00000001
#define PRINTER_STATUS_ERROR             0x00000002
#define PRINTER_STATUS_PENDING_DELETION  0x00000004
#define PRINTER_STATUS_PAPER_JAM         0x00000008
#define PRINTER_STATUS_PAPER_OUT         0x00000010
#define PRINTER_STATUS_MANUAL_FEED       0x00000020
#define PRINTER_STATUS_PAPER_PROBLEM     0x00000040
#define PRINTER_STATUS_OFFLINE           0x00000080
#define PRINTER_STATUS_IO_ACTIVE         0x00000100
#define PRINTER_STATUS_BUSY              0x00000200
#define PRINTER_STATUS_PRINTING          0x00000400
#define PRINTER_STATUS_OUTPUT_BIN_FULL   0x00000800
#define PRINTER_STATUS_NOT_AVAILABLE     0x00001000
#define PRINTER_STATUS_WAITING           0x00002000
#define PRINTER_STATUS_PROCESSING        0x00004000
#define PRINTER_STATUS_INITIALIZING      0x00008000
#define PRINTER_STATUS_WARMING_UP        0x00010000
#define PRINTER_STATUS_TONER_LOW         0x00020000
#define PRINTER_STATUS_NO_TONER          0x00040000
#define PRINTER_STATUS_PAGE_PUNT         0x00080000
#define PRINTER_STATUS_USER_INTERVENTION 0x00100000
#define PRINTER_STATUS_OUT_OF_MEMORY     0x00200000
#define PRINTER_STATUS_DOOR_OPEN         0x00400000
#define PRINTER_STATUS_SERVER_UNKNOWN    0x00800000
#define PRINTER_STATUS_POWER_SAVE        0x01000000


#define PRINTER_ATTRIBUTE_QUEUED         0x00000001
#define PRINTER_ATTRIBUTE_DIRECT         0x00000002
#define PRINTER_ATTRIBUTE_DEFAULT        0x00000004
#define PRINTER_ATTRIBUTE_SHARED         0x00000008
#define PRINTER_ATTRIBUTE_NETWORK        0x00000010
#define PRINTER_ATTRIBUTE_HIDDEN         0x00000020
#define PRINTER_ATTRIBUTE_LOCAL          0x00000040

#define PRINTER_ATTRIBUTE_ENABLE_DEVQ       0x00000080
#define PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS   0x00000100
#define PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST 0x00000200

#define PRINTER_ATTRIBUTE_WORK_OFFLINE   0x00000400
#define PRINTER_ATTRIBUTE_ENABLE_BIDI    0x00000800
#define PRINTER_ATTRIBUTE_RAW_ONLY       0x00001000

#define NO_PRIORITY   0
#define MAX_PRIORITY 99
#define MIN_PRIORITY  1
#define DEF_PRIORITY  1

#define PRINTER_ENUM_DEFAULT     0x00000001
#define PRINTER_ENUM_LOCAL       0x00000002
#define PRINTER_ENUM_CONNECTIONS 0x00000004
#define PRINTER_ENUM_FAVORITE    0x00000004
#define PRINTER_ENUM_NAME        0x00000008
#define PRINTER_ENUM_REMOTE      0x00000010
#define PRINTER_ENUM_SHARED      0x00000020
#define PRINTER_ENUM_NETWORK     0x00000040

#define PRINTER_ENUM_EXPAND      0x00004000
#define PRINTER_ENUM_CONTAINER   0x00008000

#define PRINTER_ENUM_ICONMASK    0x00ff0000
#define PRINTER_ENUM_ICON1       0x00010000
#define PRINTER_ENUM_ICON2       0x00020000
#define PRINTER_ENUM_ICON3       0x00040000
#define PRINTER_ENUM_ICON4       0x00080000
#define PRINTER_ENUM_ICON5       0x00100000
#define PRINTER_ENUM_ICON6       0x00200000
#define PRINTER_ENUM_ICON7       0x00400000
#define PRINTER_ENUM_ICON8       0x00800000


#ifdef UNICODE
BOOL
WINAPI
EnumPrintersW(
    DWORD Flags,
    LPWSTR Name,
    DWORD Level,
    LPBYTE pPrinterEnum,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumPrinters  EnumPrintersW
#else
BOOL
WINAPI
EnumPrintersA(
    DWORD Flags,
    LPSTR Name,
    DWORD Level,
    LPBYTE pPrinterEnum,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumPrinters  EnumPrintersA
#endif /* // !UNICODE */

#define PRINTER_ENUM_DEFAULT     0x00000001
#define PRINTER_ENUM_LOCAL       0x00000002
#define PRINTER_ENUM_CONNECTIONS 0x00000004
#define PRINTER_ENUM_FAVORITE    0x00000004
#define PRINTER_ENUM_NAME        0x00000008
#define PRINTER_ENUM_REMOTE      0x00000010
#define PRINTER_ENUM_SHARED      0x00000020
#define PRINTER_ENUM_NETWORK     0x00000040

#define PRINTER_ENUM_EXPAND      0x00004000
#define PRINTER_ENUM_CONTAINER   0x00008000

#define PRINTER_ENUM_ICONMASK    0x00ff0000
#define PRINTER_ENUM_ICON1       0x00010000
#define PRINTER_ENUM_ICON2       0x00020000
#define PRINTER_ENUM_ICON3       0x00040000
#define PRINTER_ENUM_ICON4       0x00080000
#define PRINTER_ENUM_ICON5       0x00100000
#define PRINTER_ENUM_ICON6       0x00200000
#define PRINTER_ENUM_ICON7       0x00400000
#define PRINTER_ENUM_ICON8       0x00800000

#ifdef UNICODE
BOOL WINAPI
     OpenPrinterW(
    LPWSTR pPrinterName,
    LPHANDLE phPrinter,
    LPPRINTER_DEFAULTSW pDefault
);
#define OpenPrinter  OpenPrinterW
#else
BOOL WINAPI
     OpenPrinterA(
    LPSTR pPrinterName,
    LPHANDLE phPrinter,
    LPPRINTER_DEFAULTSA pDefault
);
#define OpenPrinter  OpenPrinterA
#endif

#ifdef UNICODE
BOOL WINAPI
     ResetPrinterW(
    HANDLE hPrinter,
    LPPRINTER_DEFAULTSW pDefault
);
#define ResetPrinter  ResetPrinterW
#else
BOOL WINAPI
     ResetPrinterA(
    HANDLE hPrinter,
    LPPRINTER_DEFAULTSA pDefault
);
#define ResetPrinter  ResetPrinterA
#endif

#ifdef UNICODE
BOOL WINAPI
     SetJobA(
    HANDLE hPrinter,
    DWORD JobId,
    DWORD Level,
    LPBYTE pJob,
    DWORD Command
);
#define SetJob  SetJobW
#else
BOOL WINAPI
     SetJobW(
    HANDLE hPrinter,
    DWORD JobId,
    DWORD Level,
    LPBYTE pJob,
    DWORD Command
);
#define SetJob  SetJobA
#endif

#ifdef UNICODE
BOOL WINAPI
     GetJobW(
    HANDLE hPrinter,
    DWORD JobId,
    DWORD Level,
    LPBYTE pJob,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetJob  GetJobW
#else
BOOL WINAPI
     GetJobA(
    HANDLE hPrinter,
    DWORD JobId,
    DWORD Level,
    LPBYTE pJob,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetJob  GetJobA
#endif

#ifdef UNICODE
BOOL WINAPI
     EnumJobsW(
    HANDLE hPrinter,
    DWORD FirstJob,
    DWORD NoJobs,
    DWORD Level,
    LPBYTE pJob,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumJobs  EnumJobsW
#else
BOOL WINAPI
     EnumJobsA(
    HANDLE hPrinter,
    DWORD FirstJob,
    DWORD NoJobs,
    DWORD Level,
    LPBYTE pJob,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumJobs  EnumJobsA
#endif

#ifdef UNICODE
HANDLE WINAPI
       AddPrinterA(
    LPSTR pName,
    DWORD Level,
    LPBYTE pPrinter
);
#define AddPrinter  AddPrinterW
#else
HANDLE WINAPI
       AddPrinterW(
    LPWSTR pName,
    DWORD Level,
    LPBYTE pPrinter
);
#define AddPrinter  AddPrinterA
#endif

BOOL WINAPI
     DeletePrinter(
    HANDLE hPrinter
);

#ifdef UNICODE
BOOL WINAPI
     SetPrinterW(
    HANDLE hPrinter,
    DWORD Level,
    LPBYTE pPrinter,
    DWORD Command
);
#define SetPrinter  SetPrinterW
#else
BOOL WINAPI
     SetPrinterA(
    HANDLE hPrinter,
    DWORD Level,
    LPBYTE pPrinter,
    DWORD Command
);
#define SetPrinter  SetPrinterA
#endif

#ifdef UNICODE
BOOL WINAPI
     GetPrinterW(
    HANDLE hPrinter,
    DWORD Level,
    LPBYTE pPrinter,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetPrinter  GetPrinterW
#else
BOOL WINAPI
     GetPrinterA(
    HANDLE hPrinter,
    DWORD Level,
    LPBYTE pPrinter,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetPrinter  GetPrinterA
#endif

#ifdef UNICODE
BOOL WINAPI
     AddPrinterDriverW(
    LPWSTR pName,
    DWORD Level,
    LPBYTE pDriverInfo
);
#define AddPrinterDriver  AddPrinterDriverW
#else
BOOL WINAPI
     AddPrinterDriverA(
    LPSTR pName,
    DWORD Level,
    LPBYTE pDriverInfo
);
#define AddPrinterDriver  AddPrinterDriverA
#endif

#ifdef UNICODE
BOOL WINAPI
     EnumPrinterDriversW(
    LPWSTR pName,
    LPWSTR pEnvironment,
    DWORD Level,
    LPBYTE pDriverInfo,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumPrinterDrivers  EnumPrinterDriversW
#else
BOOL WINAPI
     EnumPrinterDriversA(
    LPSTR pName,
    LPSTR pEnvironment,
    DWORD Level,
    LPBYTE pDriverInfo,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumPrinterDrivers  EnumPrinterDriversA
#endif

#ifdef UNICODE
BOOL WINAPI
     GetPrinterDriverW(
    HANDLE hPrinter,
    LPWSTR pEnvironment,
    DWORD Level,
    LPBYTE pDriverInfo,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetPrinterDriver  GetPrinterDriverW
#else
BOOL WINAPI
     GetPrinterDriverA(
    HANDLE hPrinter,
    LPSTR pEnvironment,
    DWORD Level,
    LPBYTE pDriverInfo,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetPrinterDriver  GetPrinterDriverA
#endif

#ifdef UNICODE
BOOL WINAPI
     GetPrinterDriverDirectoryW(
    LPWSTR pName,
    LPWSTR pEnvironment,
    DWORD Level,
    LPBYTE pDriverDirectory,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetPrinterDriverDirectory  GetPrinterDriverDirectoryW
#else
BOOL WINAPI
     GetPrinterDriverDirectoryA(
    LPSTR pName,
    LPSTR pEnvironment,
    DWORD Level,
    LPBYTE pDriverDirectory,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetPrinterDriverDirectory  GetPrinterDriverDirectoryA
#endif

#ifdef UNICODE
BOOL WINAPI
     DeletePrinterDriverW(
    LPWSTR pName,
    LPWSTR pEnvironment,
    LPWSTR pDriverName
);
#define DeletePrinterDriver  DeletePrinterDriverW
#else
BOOL WINAPI
     DeletePrinterDriverA(
    LPSTR pName,
    LPSTR pEnvironment,
    LPSTR pDriverName
);
#define DeletePrinterDriver  DeletePrinterDriverA
#endif


#ifdef UNICODE
BOOL WINAPI
     AddPrintProcessorW(
    LPWSTR pName,
    LPWSTR pEnvironment,
    LPWSTR pPathName,
    LPWSTR pPrintProcessorName
);
#define AddPrintProcessor  AddPrintProcessorW
#else
BOOL WINAPI
     AddPrintProcessorA(
    LPSTR pName,
    LPSTR pEnvironment,
    LPSTR pPathName,
    LPSTR pPrintProcessorName
);
#define AddPrintProcessor  AddPrintProcessorA
#endif


#ifdef UNICODE
BOOL WINAPI
     EnumPrintProcessorsW(
    LPWSTR pName,
    LPWSTR pEnvironment,
    DWORD Level,
    LPBYTE pPrintProcessorInfo,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumPrintProcessors  EnumPrintProcessorsW
#else
BOOL WINAPI
     EnumPrintProcessorsA(
    LPSTR pName,
    LPSTR pEnvironment,
    DWORD Level,
    LPBYTE pPrintProcessorInfo,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumPrintProcessors  EnumPrintProcessorsA
#endif

#ifdef UNICODE
BOOL WINAPI
     GetPrintProcessorDirectoryW(
    LPWSTR pName,
    LPWSTR pEnvironment,
    DWORD Level,
    LPBYTE pPrintProcessorInfo,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetPrintProcessorDirectory  GetPrintProcessorDirectoryW
#else
BOOL WINAPI
     GetPrintProcessorDirectoryA(
    LPSTR pName,
    LPSTR pEnvironment,
    DWORD Level,
    LPBYTE pPrintProcessorInfo,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define GetPrintProcessorDirectory  GetPrintProcessorDirectoryA
#endif

#ifdef UNICODE
BOOL WINAPI
     EnumPrintProcessorDatatypesW(
    LPWSTR pName,
    LPWSTR pPrintProcessorName,
    DWORD Level,
    LPBYTE pDatatypes,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumPrintProcessorDatatypes  EnumPrintProcessorDatatypesW
#else
BOOL WINAPI
     EnumPrintProcessorDatatypesA(
    LPSTR pName,
    LPSTR pPrintProcessorName,
    DWORD Level,
    LPBYTE pDatatypes,
    DWORD cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
#define EnumPrintProcessorDatatypes  EnumPrintProcessorDatatypesA
#endif

#ifdef UNICODE
BOOL WINAPI
     DeletePrintProcessorW(
    LPWSTR pName,
    LPWSTR pEnvironment,
    LPWSTR pPrintProcessorName
);
#define DeletePrintProcessor  DeletePrintProcessorW
#else
BOOL WINAPI
     DeletePrintProcessorA(
    LPSTR pName,
    LPSTR pEnvironment,
    LPSTR pPrintProcessorName
);
#define DeletePrintProcessor  DeletePrintProcessorA
#endif

#ifdef UNICODE
DWORD WINAPI
      StartDocPrinterW(
    HANDLE hPrinter,
    DWORD Level,
    LPBYTE pDocInfo
);
#define StartDocPrinter  StartDocPrinterW
#else
DWORD WINAPI
      StartDocPrinterA(
    HANDLE hPrinter,
    DWORD Level,
    LPBYTE pDocInfo
);
#define StartDocPrinter  StartDocPrinterA
#endif

BOOL WINAPI
     StartPagePrinter(
    HANDLE hPrinter
);

BOOL WINAPI
     WritePrinter(
    HANDLE hPrinter,
    LPVOID pBuf,
    DWORD cbBuf,
    LPDWORD pcWritten
);

BOOL WINAPI
     EndPagePrinter(
    HANDLE hPrinter
);

BOOL WINAPI
     AbortPrinter(
    HANDLE hPrinter
);

BOOL WINAPI
     ReadPrinter(
    HANDLE hPrinter,
    LPVOID pBuf,
    DWORD cbBuf,
    LPDWORD pNoBytesRead
);

BOOL WINAPI
     EndDocPrinter(
    HANDLE hPrinter
);

#ifdef UNICODE
BOOL WINAPI
     AddJobW(
    HANDLE hPrinter,
    DWORD Level,
    LPBYTE pData,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define AddJob  AddJobW
#else
BOOL WINAPI
     AddJobA(
    HANDLE hPrinter,
    DWORD Level,
    LPBYTE pData,
    DWORD cbBuf,
    LPDWORD pcbNeeded
);
#define AddJob  AddJobA
#endif

BOOL WINAPI
     ScheduleJob(
    HANDLE hPrinter,
    DWORD JobId
);

BOOL WINAPI
     PrinterProperties(
    HWND hWnd,
    HANDLE hPrinter
);

#ifdef UNICODE
LONG WINAPI
     DocumentPropertiesW(
    HWND hWnd,
    HANDLE hPrinter,
    LPWSTR pDeviceName,
    PDEVMODEW pDevModeOutput,
    PDEVMODEW pDevModeInput,
    DWORD fMode
);
#define DocumentProperties  DocumentPropertiesW
#else
LONG WINAPI
     DocumentPropertiesA(
    HWND hWnd,
    HANDLE hPrinter,
    LPSTR pDeviceName,
    PDEVMODEA pDevModeOutput,
    PDEVMODEA pDevModeInput,
    DWORD fMode
);
#define DocumentProperties  DocumentPropertiesA
#endif

#ifdef UNICODE
LONG WINAPI
     AdvancedDocumentPropertiesW(
    HWND hWnd,
    HANDLE hPrinter,
    LPWSTR pDeviceName,
    PDEVMODEW pDevModeOutput,
    PDEVMODEW pDevModeInput
);
#define AdvancedDocumentProperties  AdvancedDocumentPropertiesW
LONG WINAPI
     AdvancedDocumentPropertiesA(
    HWND hWnd,
    HANDLE hPrinter,
    LPSTR pDeviceName,
    PDEVMODEA pDevModeOutput,
    PDEVMODEA pDevModeInput
);
#else
#define AdvancedDocumentProperties  AdvancedDocumentPropertiesA
#endif

#ifdef UNICODE
DWORD WINAPI
      GetPrinterDataW(
    HANDLE hPrinter,
    LPWSTR pValueName,
    LPDWORD pType,
    LPBYTE pData,
    DWORD nSize,
    LPDWORD pcbNeeded
);
#define GetPrinterData  GetPrinterDataW
#else
DWORD WINAPI
      GetPrinterDataA(
    HANDLE hPrinter,
    LPSTR pValueName,
    LPDWORD pType,
    LPBYTE pData,
    DWORD nSize,
    LPDWORD pcbNeeded
);
#define GetPrinterData  GetPrinterDataA
#endif

#ifdef UNICODE
DWORD WINAPI
      EnumPrinterDataW(
    HANDLE hPrinter,
    DWORD dwIndex,
    LPWSTR pValueName,
    DWORD cbValueName,
    LPDWORD pcbValueName,
    LPDWORD pType,
    LPBYTE pData,
    DWORD cbData,
    LPDWORD pcbData
);
#define EnumPrinterData  EnumPrinterDataW
#else
DWORD WINAPI
      EnumPrinterDataA(
    HANDLE hPrinter,
    DWORD dwIndex,
    LPSTR pValueName,
    DWORD cbValueName,
    LPDWORD pcbValueName,
    LPDWORD pType,
    LPBYTE pData,
    DWORD cbData,
    LPDWORD pcbData
);
#define EnumPrinterData  EnumPrinterDataA
#endif


#ifdef UNICODE
DWORD WINAPI
      SetPrinterDataW(
    HANDLE hPrinter,
    LPWSTR pValueName,
    DWORD Type,
    LPBYTE pData,
    DWORD cbData
);
#define SetPrinterData  SetPrinterDataW
#else
DWORD WINAPI
      SetPrinterDataA(
    HANDLE hPrinter,
    LPSTR pValueName,
    DWORD Type,
    LPBYTE pData,
    DWORD cbData
);
#define SetPrinterData  SetPrinterDataA
#endif

#ifdef UNICODE
DWORD WINAPI
      DeletePrinterDataW(
    HANDLE hPrinter,
    LPWSTR pValueName
);
#define DeletePrinterData  DeletePrinterDataW
#else
DWORD WINAPI
      DeletePrinterDataA(
    HANDLE hPrinter,
    LPSTR pValueName
);
#define DeletePrinterData  DeletePrinterDataA
#endif

#endif /* _MISSING_H */
