/********************************************************************************
*                                                                               *
*                       S t a t u s b a r   W i d g e t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXStatusbar.h,v 1.5 1999/11/09 23:58:37 jeroen Exp $                     *
********************************************************************************/
#ifndef FXSTATUSBAR_H
#define FXSTATUSBAR_H

enum FXStatusbarStyle {
  STATUSBAR_WITH_DRAGCORNER = 0x00008000
  };


// Status line
class FXAPI FXStatusline : public FXFrame {
  FXDECLARE(FXStatusline)
protected:
  FXString  status;             // Current status message
  FXString  normal;             // Normally displayed message
  FXFont   *font;               // Font
  FXColor   textColor;          // Status text color
  FXColor   textHighlightColor; // Status text highlight color
protected:
  FXStatusline();
  static const FXchar defaultMessage[];
private:
  FXStatusline(const FXStatusline&);
  FXStatusline& operator=(const FXStatusline&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onUpdate(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
public:
  FXStatusline(FXComposite* p,FXObject* tgt=NULL,FXSelector sel=0);
  virtual void create();
  virtual void detach();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  void setText(const FXString& text);
  FXString getText() const { return status; }
  void setNormalText(const FXString& text);
  FXString getNormalText() const { return normal; }
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  FXColor getTextHighlightColor() const { return textHighlightColor; }
  void setTextHighlightColor(FXColor clr);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXStatusline();
  };

  
  
class FXDragCorner;

  
// Status bar
class FXAPI FXStatusbar : public FXHorizontalFrame {
  FXDECLARE(FXStatusbar)
protected:
  FXDragCorner *corner;
  FXStatusline *status;
protected:
  FXStatusbar(){}
  virtual void layout();
private:
  FXStatusbar(const FXStatusbar&);
  FXStatusbar& operator=(const FXStatusbar&);
public:
  FXStatusbar(FXComposite* p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=3,FXint pr=3,FXint pt=2,FXint pb=2,FXint hs=4,FXint vs=0);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  FXStatusline *getStatusline() const { return status; }
  FXDragCorner *getDragCorner() const { return corner; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXStatusbar();
  };


#endif
