/********************************************************************************
*                                                                               *
*                                 Data Target Test                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* $Id: datatarget.cpp,v 1.1 1999/09/14 13:42:43 jeroen Exp $                   *
********************************************************************************/
#include "fx.h"


/*******************************************************************************/


// Mini application object
class DataTargetWindow : public FXMainWindow {
  FXDECLARE(DataTargetWindow)
protected:
  FXMenuBar*         menubar;
  FXMenuPane*        filemenu;
  FXMatrix*          matrix;
  FXint              some_int;
  FXdouble           some_double;
  FXString           some_string;
  FXColor            some_color;
  FXDataTarget*      int_target;
  FXDataTarget*      double_target;
  FXDataTarget*      string_target;
  FXDataTarget*      color_target;
public:
  DataTargetWindow(){}
public:
  DataTargetWindow(FXApp *a);
  void create();
  };


  
/*******************************************************************************/
  
// Object implementation
FXIMPLEMENT(DataTargetWindow,FXMainWindow,NULL,0)


// Make some windows
DataTargetWindow::DataTargetWindow(FXApp* a):FXMainWindow(a,"Data Target Test",NULL,NULL,DECOR_ALL,0,0,0,0){
  
  // Menubar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  filemenu=new FXMenuPane(this);
    new FXMenuCommand(filemenu,"&Quit\tCtl-Q",NULL,getApp(),FXApp::ID_QUIT,0);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  
  // Arange nicely
  matrix=new FXMatrix(this,6,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  some_int = 10;
  some_double = 3.1415927;
  some_string = "FOX";
  some_color = FXRGB(255,0,0);
  
  
  // Make INTEGER target
  int_target = new FXDataTarget(some_int);
  
  // Make DOUBLE target
  double_target = new FXDataTarget(some_double);
  
  // Make STRING target
  string_target = new FXDataTarget(some_string);
  
  // Make COLOR target
  color_target = new FXDataTarget(some_color);
  
  // First row
  new FXLabel(matrix,"Integer",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  
  new FXTextField(matrix,10,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  
  new FXTextField(matrix,10,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  
  new FXSlider(matrix,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FILL_ROW|LAYOUT_FIX_WIDTH,0,0,100);
  
  new FXDial(matrix,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FILL_ROW|LAYOUT_FIX_WIDTH|DIAL_HORIZONTAL|DIAL_HAS_NOTCH,0,0,100);
  
  new FXProgressBar(matrix,int_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|FRAME_SUNKEN|FRAME_THICK|PROGRESSBAR_PERCENTAGE|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Second row
  new FXLabel(matrix,"Real",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  
  new FXTextField(matrix,10,double_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  
  new FXTextField(matrix,10,double_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  
  new FXSlider(matrix,double_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FILL_ROW|LAYOUT_FIX_WIDTH,0,0,100);
  
  new FXDial(matrix,double_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X|LAYOUT_FILL_ROW|LAYOUT_FIX_WIDTH|DIAL_HORIZONTAL|DIAL_HAS_NOTCH,0,0,100);

  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Third row
  new FXLabel(matrix,"String",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  
  new FXTextField(matrix,10,string_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  
  new FXTextField(matrix,10,string_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Fourth row
  new FXLabel(matrix,"Color",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  
  new FXColorWell(matrix,0,color_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
  
  new FXColorWell(matrix,0,color_target,FXDataTarget::ID_VALUE,LAYOUT_CENTER_Y|LAYOUT_FILL_X,0,0,0,0, 0,0,0,0);
  
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  new FXFrame(matrix,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
  
  // Install an accelerator
  getAccelTable()->addAccel(fxparseaccel("Ctl-Q"),getApp(),MKUINT(FXApp::ID_QUIT,SEL_COMMAND));
  }
  

// Start
void DataTargetWindow::create(){
  FXMainWindow::create();
  show();
  }


/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){

  // Make application
  FXApp* application=new FXApp("DataTarget","Test");
  
  // Open display
  application->init(argc,argv);
  
  // Main window
  new DataTargetWindow(application);
  
  // Create app
  application->create();
  
  // Run
  application->run();
  }
