/*
**	mapping info to map iso10646 characters to IBM codepage 437
*/

#define	NONE	0x00

static unsigned char fi00[256] =
{	0x00, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
	0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
	0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
	0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
	0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
	0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
	0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
	0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
	0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
	0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
	0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	0xff, 0xad, 0x9b, 0x9c, NONE, 0x9d, NONE, 0x15,
	NONE, NONE, 0xa6, 0xae, 0xaa, NONE, NONE, NONE,
	0xf8, 0xf1, 0xfd, NONE, NONE, 0xe6, 0x14, 0xfa,
	NONE, NONE, 0xa7, 0xaf, 0xac, 0xab, NONE, 0xa8,
	NONE, NONE, NONE, NONE, 0x8e, 0x8f, 0x92, 0x80,
	NONE, 0x90, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, 0xa5, NONE, NONE, NONE, NONE, 0x99, NONE,
	NONE, NONE, NONE, NONE, 0x9a, NONE, NONE, 0xe1,
	0x85, 0xa0, 0x83, NONE, 0x84, 0x86, 0x91, 0x87,
	0x8a, 0x82, 0x88, 0x89, 0x8d, 0xa1, 0x8c, 0x8b,
	NONE, 0xa4, 0x95, 0xa2, 0x93, NONE, 0x94, 0xf6,
	NONE, 0x97, 0xa3, 0x96, 0x81, NONE, NONE, 0x98
};

static ggi_cellinfo fi01[] =
{	{ 0x0192, 1 },
	{ 0x0192, 0x9f }
};

static ggi_cellinfo fi03[] =
{	{ 0x03c6, 12 },
	{ 0x0393, 0xe2 }, { 0x0398, 0xe9 }, { 0x03a3, 0xe4 }, { 0x03a6, 0xe8 },
	{ 0x03a9, 0xea }, { 0x03b1, 0xe0 }, { 0x03b4, 0xeb }, { 0x03b5, 0xee },
	{ 0x03c0, 0xe3 }, { 0x03c3, 0xe5 }, { 0x03c4, 0xe7 }, { 0x03c6, 0xed }
};

static ggi_cellinfo fi20[] =
{	{ 0x20a7, 4 },
	{ 0x2022, 0x07 }, { 0x203c, 0x13 }, { 0x207f, 0xfc }, { 0x20a7, 0x9e }
};

static ggi_cellinfo fi21[] =
{	{ 0x21a8, 7 },
	{ 0x2190, 0x1b }, { 0x2191, 0x18 }, { 0x2192, 0x1a }, { 0x2193, 0x19 },
	{ 0x2194, 0x1d }, { 0x2195, 0x12 }, { 0x21a8, 0x17 }
};

static ggi_cellinfo fi22[] =
{	{ 0x2265, 9 },
	{ 0x2219, 0xf9 }, { 0x221a, 0xfb }, { 0x221e, 0xec }, { 0x221f, 0x1c },
	{ 0x2229, 0xef }, { 0x2248, 0xf7 }, { 0x2261, 0xf0 }, { 0x2264, 0xf3 },
	{ 0x2265, 0xf2 }
};

static ggi_cellinfo fi23[] =
{	{ 0x2321, 4 },
	{ 0x2302, 0x7f }, { 0x2310, 0xa9 }, { 0x2320, 0xf4 }, { 0x2321, 0xf5 }
};

static unsigned char fi25[256] =
{	0xc4, NONE, 0xb3, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, 0xda, NONE, NONE, NONE,
	0xbf, NONE, NONE, NONE, 0xc0, NONE, NONE, NONE,
	0xd9, NONE, NONE, NONE, 0xc3, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, 0xb4, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, 0xc2, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, 0xc1, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, 0xc5, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	0xcd, 0xba, 0xd5, 0xd6, 0xc9, 0xb8, 0xb7, 0xbb,
	0xd4, 0xd3, 0xc8, 0xbe, 0xbd, 0xbc, 0xc6, 0xc7,
	0xcc, 0xb5, 0xb6, 0xb9, 0xd1, 0xd2, 0xcb, 0xcf,
	0xd0, 0xca, 0xd8, 0xd7, 0xce, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	0xdf, NONE, NONE, NONE, 0xdc, NONE, NONE, NONE,
	0xdb, NONE, NONE, NONE, 0xdd, NONE, NONE, NONE,
	0xde, 0xb0, 0xb1, 0xb2, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	0xfe, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, 0x16, NONE, NONE, NONE,
	NONE, NONE, 0x1e, NONE, NONE, NONE, 0x10, NONE,
	NONE, NONE, NONE, NONE, 0x1f, NONE, NONE, NONE,
	0x11, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, 0x09, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	0x08, 0x0a, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE,
	NONE, NONE, NONE, NONE, NONE, NONE, NONE, NONE
};

static ggi_cellinfo fi26[] =
{	{ 0x266b, 11 },
	{ 0x263a, 0x01 }, { 0x263b, 0x02 }, { 0x263c, 0x0f }, { 0x2640, 0x0c },
	{ 0x2642, 0x0b }, { 0x2660, 0x06 }, { 0x2663, 0x05 }, { 0x2665, 0x03 },
	{ 0x2666, 0x04 }, { 0x266a, 0x0d }, { 0x266b, 0x0e }
};

static struct kgi_fontinfo ibm_cp437 =
{
	256,		/* number font positions	*/
	'?' /* NONE */,		/* default font position	*/
	{	0x00000001, 0x00000020, 0x00000000, 0x00000000,
		0x00000000, 0x00000000, 0x00000000, 0x00000000
	},
	{	fi00, fi01, NULL, fi03, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		fi20, fi21, fi22, fi23, NULL, fi25, fi26, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
		NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	},
	{	0x0000, 0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
		0x25d8, 0x25cb, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266b, 0x263c,
		0x25b6, 0x25c0, 0x2195, 0x203c, 0x00b6, 0x00a7, 0x25ac, 0x21a8,
		0x2191, 0x2193, 0x2192, 0x2190, 0x221f, 0x2194, 0x25b2, 0x25bc,
		0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
		0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
		0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
		0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
		0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
		0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
		0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
		0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
		0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
		0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
		0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
		0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x2302,
		0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
		0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
		0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
		0x00ff, 0x00d6, 0x00dc, 0x00a2, 0x00a3, 0x00a5, 0x20a7, 0x0192,
		0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
		0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
		0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
		0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
		0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
		0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
		0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b,
		0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
		0x03b1, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4,
		0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229,
		0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248,
		0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, 0x25a0, 0x00a0
	}
};

#define	IBM_CP437	(&ibm_cp437)

#ifdef KGI_9x16_FONT
	#include "ibm-cp437.09x16.inc"
#endif
#ifdef KGI_8x14_FONT
	#include "ibm-cp437.08x14.inc"
#endif
#ifdef KGI_8x8_FONT
	#include "ibm-cp437.08x08.inc"
#endif
