/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998, 1999  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_audio_c.h,v 1.2 1999/11/23 19:01:40 hercules Exp $";
#endif

/* Functions and variables exported from SDL_audio.c for SDL_sysaudio.c */

/* The public audio format -- not necessarily the one used by the hardware */
extern SDL_AudioSpec audio_spec;

/* An audio conversion block for audio format emulation */
extern SDL_AudioCVT convert;

/* Flags: is audio playing enabled? paused? */
#ifdef FORK_HACK
extern int *_audioenabled;
extern int *_audiopaused;
#define SDL_AudioEnabled	(*_audioenabled)
#define SDL_AudioPaused		(*_audiopaused)
#else
extern int SDL_AudioEnabled;
extern int SDL_AudioPaused;
#endif

/* Functions to get a list of "close" audio formats */
extern Uint16 SDL_FirstAudioFormat(Uint16 format);
extern Uint16 SDL_NextAudioFormat(void);

/* Function to calculate the size and silence for a SDL_AudioSpec */
extern void SDL_CalculateAudioSpec(SDL_AudioSpec *spec);

