/*								-*- C++ -*-
 * $Id: WIN_panel.cpp,v 1.3 1997-01-30 09:56:06+01 mho Exp $
 *
 * Purpose: base class for all panels
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_panel.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxButton
#define  Uses_wxFrame
#define  Uses_wxListBox
#define  Uses_wxPanel
#include "wx.h"
#define  Uses_BoardWidget
#define  Uses_EnforcerWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// initialize static variables of wxPanel
//-----------------------------------------------------------------------------

int     wxPanel::drag_startx  = 0;
int     wxPanel::drag_starty  = 0;
int     wxPanel::drag_startw  = 0;
int     wxPanel::drag_starth  = 0;
int     wxPanel::drag_rectx   = 0;
int     wxPanel::drag_recty   = 0;
int     wxPanel::drag_rectw   = 0;
int     wxPanel::drag_recth   = 0;
int     wxPanel::drag_startcx = 0;
int     wxPanel::drag_startcy = 0;
wxItem* wxPanel::drag_item    = NULL;
int     wxPanel::drag_handle  = -1;
Bool    wxPanel::drag_moved   = FALSE;

//-----------------------------------------------------------------------------
// wxPanel create and destroy
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxPanel, wxWindow)

wxPanel::wxPanel(void) : wxWindow()
{
    __type = wxTYPE_PANEL;

    default_item = NULL;
    label_font = wxLABEL_FONT;
    button_colour = wxBLACK;
    label_colour = wxBLACK;
    label_pos = wxHORIZONTAL;
    orientation = wxHORIZONTAL;
    cursor_x = cursor_y = 0;
    h_margin = PANEL_HMARGIN;
    v_margin = PANEL_VMARGIN;
    h_space = PANEL_HSPACING;
    v_space = PANEL_VSPACING;
    line_extent = 0;
    fit_one_child = FALSE;
}

//-----------------------------------------------------------------------------
// compatibility, I like the typesave constructor more
//-----------------------------------------------------------------------------

wxPanel::wxPanel(wxWindow *panel, int x, int y, int width, int height,
		 int style, Constdata char *name) : wxWindow()
{
    __type = wxTYPE_PANEL;

    default_item = NULL;
    label_font = wxSWISS_FONT;
    button_colour = wxBLACK;
    label_colour = wxBLACK;
    label_pos = wxHORIZONTAL;
    cursor_x = cursor_y = 0;
    h_margin = PANEL_HMARGIN;
    v_margin = PANEL_VMARGIN;
    h_space = PANEL_HSPACING;
    v_space = PANEL_VSPACING;
    line_extent = 0;
    fit_one_child = FALSE;
    Create(panel, x, y, width, height, style, name);
}

Bool wxPanel::Create(wxWindow *_panel, int x, int y, int width, int height,
		     int _style, Constdata char *name)
{
    if (!_panel || !_panel->IsKindOf(CLASSINFO(wxPanel)))
	wxFatalError("parent has to be a wxFrame, wxPanel, or any subtype", "wxPanel");

    wxPanel *panel = (wxPanel*)_panel;
    style          = _style;
    button_colour  = panel->GetButtonColour();
    label_colour   = panel->GetLabelColour();
    label_font     = panel->GetLabelFont();
    font           = panel->font;
    fg             = panel->fg;
    bg             = panel->bg;
    orientation    = ((style & wxVERTICAL) ? wxVERTICAL : wxHORIZONTAL);

    if (!(style & wxPRIVATE_CHILD)) {
	parent = _panel;
	parent->AddChild(this);
    }

    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(panel),
	 XtNbackground,		bg.GetPixel(&cmap),
	 XtNforeground,		fg.GetPixel(&cmap),
	 XtNfont,		font.GetInternalFont(),
	 XtNhighlightThickness, 0,
	 XtNtraversalOn,	(style & wxNO_KEYB_TRAVERSAL ? FALSE : TRUE),
	 XtNouterOffset,	(style & wxBORDER ? 4 : 0),
	 XtNframeWidth,		(style & wxBORDER ? 2 : 0),
	 XtNframeType,		XfwfSunken,
	 XtNinnerHOffset,	Dimension(h_margin),
	 XtNinnerVOffset,	Dimension(v_margin),
	 NULL);
    // internal representation
    HWidget() = XtVaCreateManagedWidget
	(name, xfwfBoardWidgetClass, FWidget(),
	 XtNbackground,		bg.GetPixel(&cmap),
	 XtNforeground,		fg.GetPixel(&cmap),
	 XtNfont,		font.GetInternalFont(),
	 XtNhighlightThickness, 0,
	 XtNtraversalOn,	(style & wxNO_KEYB_TRAVERSAL ? FALSE : TRUE),
	 NULL);
    // Initialize PanelDC
    if (!(style & wxNO_DC)) {
	CreateDC();
    }
    // position in panel/frame
    panel->PositionItem(this, x, y, width, height);
    // add event handlers
    AddEventHandlers();
    // ready
    return TRUE;
}

//-----------------------------------------------------------------------------
// if setting own background, change colours of item labels
//-----------------------------------------------------------------------------

void wxPanel::SetBackgroundColour(wxColour &col)
{
    // inherit from window
    wxWindow::SetBackgroundColour(col);
    // change children's label background colours
    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxWindow *child  = (wxWindow*)node->Data();
	if (wxIsItem(child) || wxIsPanel(child))
	    child->ChangeColours();
    }
}

//-----------------------------------------------------------------------------
// fit panel around items
//-----------------------------------------------------------------------------

void wxPanel::Fit(void)
{
    int hsize=0, vsize=0;

    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxWindow *child = (wxWindow*)(node->Data());
	// skip frames
	if (wxIsFrame(child)) continue;
	// get maximal sizes
	int x, y, w, h;
	child->GetPosition(&x, &y); child->GetSize(&w, &h);
	hsize = wxMax(hsize, x + w);
	vsize = wxMax(vsize, y + h);
    }
    SetClientSize(hsize, vsize);
}

void wxPanel::SetClientSize(int WXUNUSED(x), int WXUNUSED(y), int width, int height)
{
    // !!! x and y are ignored since wxPanel has it's own policy !!!

    int border = (style & wxBORDER) ? 6 : 0;

    SetSize(width  + 2*border + 2*h_margin,
	    height + 2*border + 2*v_margin);
}

//-----------------------------------------------------------------------------
// positioning of items
//-----------------------------------------------------------------------------

void wxPanel::GetCursor(int *x, int *y)
{
    *x = cursor_x; *y = cursor_y;
}

void wxPanel::NewLine(void)
{
    NewLine((orientation == wxHORIZONTAL) ? v_space : h_space);
}

void wxPanel::NewLine(int pixels)
{
    if (orientation == wxHORIZONTAL) {
	cursor_x = 0;
	cursor_y += line_extent + pixels;
    } else {
	cursor_x += line_extent + pixels;
	cursor_y = 0;
    }
    line_extent = 0;
}

void wxPanel::PositionItem(wxWindow *item, int x, int y, int width, int height)
{
    // position child
    if (x > -1) cursor_x = x;
    if (y > -1) cursor_y = y;
    item->Move(cursor_x, cursor_y);
    // move cursor and compute height of line
    if ( width > -1 || height > -1 )	item->SetSize(width, height);
    if ( width <  0 || height <  0 )	item->GetSize(&width, &height);
    if (orientation == wxHORIZONTAL) {
	cursor_x += width + h_space;
	line_extent = wxMax(line_extent, height);
    } else {
	line_extent = wxMax(line_extent, width);
	cursor_y += height + v_space;
    }
}

void wxPanel::SetHorizontalMargin(int m)
{
    h_margin = m;
    if (XtIsSubclass(FWidget(), xfwfFrameWidgetClass))
	// automatically resizes child
	XtVaSetValues(FWidget(), XtNinnerHOffset, Dimension(h_margin), NULL);
    else
	// resizeing and positioning is done by PreResize
	PreResize();
}

void wxPanel::SetVerticalMargin(int m)
{
    v_margin = m;
    if (XtIsSubclass(FWidget(), xfwfFrameWidgetClass))
	// automatically resizes child
	XtVaSetValues(FWidget(), XtNinnerVOffset, Dimension(v_margin), NULL);
    else
	// resizeing and positioning is done by PreResize
	PreResize();
}

void wxPanel::Tab(void)
{
    Tab((orientation == wxHORIZONTAL) ? h_space : v_space);
}

void wxPanel::Tab(int pixels)
{
    if (orientation == wxHORIZONTAL)
	cursor_x += pixels;
    else
	cursor_y += pixels;
}

//-----------------------------------------------------------------------------
// methods for panel item placement
//-----------------------------------------------------------------------------

/*
 * Beginning the ButtonPress event all mouse events are delivered to the
 * widget, where the ButtonPress occured. This stops with the ButtonRelease
 * event. Because of this, it is not necessary to care, where the pointer
 * is after the button press.
 *   - Move events occur in wxItem -> wxPanel::OnItemEvent
 *   - Resize events occur in wxPanel -> wxPanel::OnEvent
 * The pointer grabbing is used to display a different cursor.
 * Unlike the standard implementation I use only the left button for
 * moving and resizing.
 */

void wxPanel::OnEvent(wxMouseEvent& event)
{
    if (GetUserEditMode()) {
	// translate logical to device coordinates
	int x    = LogicalToDeviceX(event.x);
	int y    = LogicalToDeviceY(event.y);
	int keys = (event.ControlDown() ? wxKEY_CTRL  : 0)
		   | (event.ShiftDown() ? wxKEY_SHIFT : 0);
	// if we're dragging a resize handle, continue ...
	if (drag_item) {
	    ProcessItemEvent(drag_item, event, x, y, keys, drag_handle);
	    return;
	}
	// if we're pushing left button on a resize handle, start dragging
	if (event.LeftDown())
	    for (wxNode *node = GetChildren()->First(); node; node = node->Next())
		if ( wxIsItem((wxWindow*)node->Data()) ) {
		    wxItem *item = (wxItem*)node->Data();
		    if ((drag_handle = item->SelectionHandleHitTest(x, y)) != -1) {
			ProcessItemEvent(item, event, x, y, keys, drag_handle);
			return;
		    }
		}
	// if we have a left or right click on panel, call event handlers
	if (event.LeftUp())
	    GetEventHandler()->OnLeftClick(x, y, keys);
	if (event.RightUp())
	    GetEventHandler()->OnRightClick(x, y, keys);
    } else
	wxWindow::OnEvent(event);
}

void wxPanel::OnItemEvent(wxItem *item, wxMouseEvent &event)
{
    int x, y, keys;

    item->GetPosition(&x, &y);
    x   += LogicalToDeviceX(event.x);
    y   += LogicalToDeviceY(event.y);
    keys = (event.ControlDown() ? wxKEY_CTRL  : 0)
	   | (event.ShiftDown() ? wxKEY_SHIFT : 0);
    ProcessItemEvent(item, event, x, y, keys, -1);
}

//-----------------------------------------------------------------------------
// implementation of user edit mode
//-----------------------------------------------------------------------------

void wxPanel::ProcessItemEvent(wxItem *item, wxMouseEvent &event,
			       int x, int y, int keys, int handle)
{
    if (event.LeftDown())
	DoDragStart(item, x, y, keys, handle);
    else if (event.LeftIsDown() && event.Dragging())
	DoDragContinue(item, x, y, keys, handle);
    else if (event.LeftUp())
	DoDragEnd(item, x, y, keys, handle);
    else if (event.RightUp())
	GetEventHandler()->OnItemRightClick(item, x, y, keys);
}

void wxPanel::DoDragStart(wxItem *item, int x, int y, int WXUNUSED(keys), int handle)
{
    item->GetPosition(&drag_startx, &drag_starty);
    item->GetSize(&drag_startw, &drag_starth);

    drag_startcx = x;
    drag_startcy = y;
    drag_item    = item;
    drag_handle  = handle;
    drag_moved   = FALSE;
}

void wxPanel::DoDragContinue(wxItem *item, int x, int y, int keys, int handle)
{
    // adjust x,y by start offset
    x -= drag_startcx; y -= drag_startcy;
    if (!drag_moved) {
	// grab pointer and server for resizing and moving respectively
	XtGrabPointer(((handle == -1) ? item->HWidget() : HWidget()),
		      FALSE,
		      (ButtonMotionMask | PointerMotionHintMask |
		       ButtonReleaseMask | ButtonPressMask),
		      GrabModeAsync, GrabModeAsync,
		      XtWindow(HWidget()), wxMOVE_CURSOR->GetCursor(), CurrentTime);
	XGrabServer(XtDisplay(HWidget()));
	item->DrawSelectionHandles(TRUE); // erase resize handles
    }
    // get border gc for drawing
    Display* dpy = XtDisplay(HWidget());
    Window   win = XtWindow(HWidget());
    GC gc, dummy;
    if (XfwfGetFrameGCs(HWidget(), &dummy, &dummy, &gc, &dummy)) {
	// use GXxor function for drawing
	wxMakeXorGC(dpy, gc, bg.GetPixel(&cmap));
	// erase old move/resize rectangle
	if (drag_moved)
	    XDrawRectangle(dpy, win, gc, drag_rectx, drag_recty, drag_rectw, drag_recth);
	// draw new resize rectangle
	drag_rectx = drag_startx; drag_recty = drag_starty;
	drag_rectw = drag_startw; drag_recth = drag_starth;
	/*
	 * handles are       701
	 * numbered this     6 2
	 * way:              543
	 */
	if (keys & (wxKEY_SHIFT | wxKEY_CTRL)) {
	    switch (handle) {
	    case -1: drag_rectx += x; drag_recty += y; break;
	    case 0:  drag_recty += y; drag_recth -= 2*y; break;
	    case 1:  drag_rectx -= x; drag_rectw += 2*x; drag_recty += y; drag_recth -= 2*y; break;
	    case 2:  drag_rectx -= x; drag_rectw += 2*x; break;
	    case 3:  drag_rectx -= x; drag_rectw += 2*x; drag_recty -= y; drag_recth += 2*y; break;
	    case 4:  drag_recty -= y; drag_recth += 2*y; break;
	    case 5:  drag_rectx += x; drag_rectw -= 2*x; drag_recty -= y; drag_recth += 2*y; break;
	    case 6:  drag_rectx += x; drag_rectw -= 2*x; break;
	    case 7:  drag_rectx += x; drag_rectw -= 2*x; drag_recty += y; drag_recth -= 2*y; break;
	    }
	} else {
	    switch (handle) {
	    case -1: drag_rectx += x; drag_recty +=y; break;
	    case 0:  drag_recty += y; drag_recth -= y; break;
	    case 1:  drag_rectw += x; drag_recty += y; drag_recth -= y; break;
	    case 2:  drag_rectw += x; break;
	    case 3:  drag_rectw += x; drag_recth += y; break;
	    case 4:  drag_recth += y; break;
	    case 5:  drag_rectx += x; drag_rectw -= x; drag_recth += y; break;
	    case 6:  drag_rectx += x; drag_rectw -= x; break;
	    case 7:  drag_rectx += x; drag_rectw -= x; drag_recty += y; drag_recth -= y; break;
	    }
	}
	drag_rectx = wxMax(drag_rectx, 0)+1; drag_rectw = wxMax(drag_rectw, 6)-2;
	drag_recty = wxMax(drag_recty, 0)+1; drag_recth = wxMax(drag_recth, 6)-2;
	XDrawRectangle(dpy, win, gc, drag_rectx, drag_recty, drag_rectw, drag_recth);
	// change back function to GXcopy
	wxMakeCopyGC(dpy, gc, bg.GetPixel(&cmap));
    }
    // the cursor has moved
    drag_moved  = TRUE;
}

void wxPanel::DoDragEnd(wxItem *item, int x, int y, int keys, int handle)
{
    if (drag_moved) {
	GC gc, dummy;
	if (XfwfGetFrameGCs(HWidget(), &dummy, &dummy, &gc, &dummy)) {
	    Display *dpy = XtDisplay(HWidget());
	    // erase old rectangle and move/resize item
	    wxMakeXorGC(dpy, gc, bg.GetPixel(&cmap));
	    XDrawRectangle(dpy, XtWindow(HWidget()), gc,
			   drag_rectx, drag_recty, drag_rectw, drag_recth);
	    wxMakeCopyGC(dpy, gc, bg.GetPixel(&cmap));
	    item->SetSize(drag_rectx-1, drag_recty-1, drag_rectw+2, drag_recth+2);
	}
	item->DrawSelectionHandles(!item->IsSelected()); // redraw resize handles
	// ungrab pointer and server
	XUngrabServer(XtDisplay(HWidget()));
	XtUngrabPointer(((handle == -1) ? item->HWidget() : HWidget()), CurrentTime);
    } else {
	// OnItemLeftClick may change the selection state and draw the selection handles
	GetEventHandler()->OnItemLeftClick(item, x, y, keys);
	// draw the selection handles nontheless, because wxBuilder "clears" the background
	item->DrawSelectionHandles(!item->IsSelected());
    }
    drag_item   = NULL;
    drag_handle = -1;
}

//-----------------------------------------------------------------------------
// painting of resize handles
//-----------------------------------------------------------------------------

void wxPanel::OnPaint(void)
{
    wxWindow::OnPaint();
    DrawAllStaticItems();
    PaintSelectionHandles(FALSE);
}

void wxPanel::PaintSelectionHandles(Bool erase)
{
    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxWindow *child = (wxWindow*)node->Data();
	if (child != drag_item
	&&  child->IsSelected()
	&&  wxIsItem(child))
	    ((wxItem*)child)->DrawSelectionHandles(erase);
    }
}

//-----------------------------------------------------------------------------
// default item handling
//-----------------------------------------------------------------------------

// when a wxButton sets itself as a default item, it uses SetDefaultItem.
// SetDefaultItem assigns the button to all panel and sub-panels inside the
// frame and for the frame too, so that is is everywhere available for a
// wxListBox double click or for a wxText enter

void wxPanel::SetDefaultItem(wxButton *button)
{
    if (default_item == button) return; // the job is already done for this panel

    // set default item for this panel
    default_item = button;

    // set default item for all sub-panels but not for child-frames
    wxNode *node;
    for (node = GetChildren()->First(); node; node = node->Next()) {
	wxWindow *child = (wxWindow*)(node->Data());
	if (wxIsPanel(child) && !wxIsFrame(child))
	    ((wxPanel*)child)->SetDefaultItem(button);
    }

    // set default item for parent too, this is not a frame
    if (!wxIsFrame(this) && GetParent())
	((wxPanel*)GetParent())->SetDefaultItem(button);
}

// OnDefaultAction has two options:
// 1) a default item was assigned for the frame or dialog box => execute command
// 2) no default item was assigned => the user may have overriden an OnDefaultAction
//    for this panel or any panel up to the frame. wxFrame stops the rooting.

void wxPanel::OnDefaultAction(wxItem *item)
{
    // call listbox callback if available
    if (item->IsKindOf(CLASSINFO(wxListBox)) && item->callback) {
	wxListBox *lbox = (wxListBox*)item;
	wxCommandEvent event(wxEVENT_TYPE_LISTBOX_DCLICK_COMMAND);
	event.commandInt = -1;
	if ((lbox->GetWindowStyleFlag() & wxLB_SINGLE)
	    || (lbox->GetSelectionMode() == wxSINGLE))
	{
	    event.commandString = copystring(lbox->GetStringSelection());
	    event.commandInt = lbox->GetSelection();
	    event.clientData = lbox->wxListBox::GetClientData(event.commandInt);
	}
	event.eventObject = lbox;
	lbox->ProcessCommand(event);
	if (event.commandString)
	    delete[] event.commandString;
	return;
    }

    // if a default item is associated with this panel, execute it
    if (default_item) {
	wxCommandEvent event(wxEVENT_TYPE_BUTTON_COMMAND);
	// make item available for callback or OnCommand
	event.clientData = (char*)item;
	default_item->Command(event);
	return;
    }

    // I don't know the default item for this panel
    // => root upwards to frame that contains <this> panel
    if (GetParent() && GetParent()->GetEventHandler()) {
	GetParent()->GetEventHandler()->OnDefaultAction(item);
    }
}

//-----------------------------------------------------------------------------
// handling of hotkeys
//-----------------------------------------------------------------------------

Bool wxPanel::OnHotKey(wxKeyEvent& event)
{
    return wxWindow::OnHotKey(event);
}

//-----------------------------------------------------------------------------
// drawing  of static items
//-----------------------------------------------------------------------------

void wxPanel::DrawStaticLine(int x, int y, int length, Bool vertical)
{
    Display* dpy = XtDisplay(HWidget());
    Window   win = XtWindow(FWidget());

    GC light, dark, dummy;

    if (XfwfGetFrameGCs(HWidget(), &light, &dark, &dummy, &dummy)) {
	wxMakeNoClipGC(dpy, light);
	wxMakeNoClipGC(dpy, dark);
	XfwfDrawLine(FWidget(), win, light, dark, dummy, dummy,
		     x, y, length, 2, vertical, XfwfChiseled, False, False);
	wxMakeClipGC(dpy, light);
	wxMakeClipGC(dpy, dark);
    }
}

void wxPanel::DrawStaticBox(int x, int y, int w, int h)
{
    Display* dpy = XtDisplay(HWidget());
    Window   win = XtWindow(FWidget());

    GC light, dark, dummy;

    if (XfwfGetFrameGCs(HWidget(), &light, &dark, &dummy, &dummy)) {
	wxMakeNoClipGC(dpy, light);
	wxMakeNoClipGC(dpy, dark);
	XfwfDrawRectangle(FWidget(), win, light, dark, dummy, dummy,
			  x, y, w, h, 2, XfwfChiseled);
	wxMakeClipGC(dpy, light);
	wxMakeClipGC(dpy, dark);
    }
}

void wxPanel::AddStaticItem(wxStaticItem *WXUNUSED(the_item))
{
}

void wxPanel::RemoveStaticItem(wxStaticItem *WXUNUSED(the_item))
{
}

void wxPanel::DestroyStaticItem(wxStaticItem *WXUNUSED(the_item))
{
}

void wxPanel::DrawAllStaticItems(void)
{
}

//-----------------------------------------------------------------------------
// fit one only child into panel
//-----------------------------------------------------------------------------

void wxPanel::PreResize(int x, int y, int width, int height)
{
    if (fit_one_child) {
	// resize ONE child to fit into the frame
	wxWindow *one_child = NULL;
	for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	    wxWindow *child = (wxWindow*)(node->Data());
	    // skip frames
	    if (wxIsFrame(child)) continue;
	    if (one_child) { one_child = NULL; break; }
	    else	   { one_child = child;       }
	}
	// ONE child shall fit into frame
	if (one_child) one_child->SetSize(-1, -1, -1, -1, wxSIZE_FIT_ONE);
    }
    // chain to wxWindow method
    wxWindow::PreResize(x, y, width, height);
}
