/*
                 YIFF Configurator CallBack Handers

	Functions:

	void YCSignalHandler(int s)
	int YCTimeoutCB(gpointer data)
	void YCExitCB(
	        GtkWidget *widget,
	        GdkEvent *event,
	        gpointer data
	)
	void YCPageChangeCB(gint new_page_num) 
	void YCBackBtnCB(GtkWidget *widget, gpointer data)
	void YCNextBtnCB(GtkWidget *widget, gpointer data)

	void YCDoNotStartServerBtnCB(GtkWidget *widget, gpointer data)

	void YCAddModeBtnCB(GtkWidget *widget, gpointer data)
	void YCRemoveModeBtnCB(GtkWidget *widget, gpointer data)
	void YCModeShiftUpBtnCB(GtkWidget *widget, gpointer data)
	void YCModeShiftDownBtnCB(GtkWidget *widget, gpointer data)
	void YCAudioModesListCB(
	        GtkWidget *clist,
	        gint row,
	        gint column,
	        GdkEventButton *event,
	        gpointer data
	)
	void YCCalculateBtnCB(GtkWidget *widget, gpointer data)
	void YCCycleScaleCB(GtkAdjustment *adj, GtkWidget *scale)
	void YCApplyChangesBtnCB(GtkWidget *widget, gpointer data)

	void YCRemoveSoundPathBtnCB(GtkWidget *widget, gpointer data)
	void YCAddSoundPathBtnCB(GtkWidget *widget, gpointer data)
	void YCSoundPathShiftUpBtnCB(GtkWidget *widget, gpointer data)
	void YCSoundPathShiftDownBtnCB(GtkWidget *widget, gpointer data)
	void YCSoundPathListCB(
	        GtkWidget *clist,
	        gint row,
	        gint column,
	        GdkEventButton *event,
	        gpointer data
	)

	---

 */

#include <sys/stat.h>
#include <unistd.h>

#include <signal.h>
#include "yiffconfig.h"


void YCSignalHandler(int s)
{
	switch(s)
	{
	  case SIGINT:
	  case SIGTERM:
	  case SIGKILL:
	    YCExitCB(NULL, NULL, NULL);
	    break;
	}


	return;
}

int YCTimeoutCB(gpointer data)
{
        YEvent event;
        yc_win_struct *ycw;


	ycw = &yc_win;

	if(ycw->con != NULL)
	{
	    while(YGetNextEvent(ycw->con, &event, False) > 0)
            {
	        switch(event.type)
                {






                  default:
                    break;
		}
            }  
        }

	return(TRUE);
}

void YCExitCB(
        GtkWidget *widget, 
        GdkEvent *event,
        gpointer data
)
{
	YCDestroy();
	AddModeDestroy();
	GenDialogDestroy(&dialog);


	/* Shut down widget set. */
	gtk_main_quit();


	return;
}

/*
 *	Checks for change in page, if there is change then
 *	makes needed changes to resources and updates current
 *	page number.
 */
void YCPageChangeCB(gint new_page_num)
{
	gint i, status, old_page_num, change_back_labels = FALSE;
	gchar *strptr;
        yc_win_struct *ycw;
	GtkWidget *w;
	gchar text[PATH_MAX + NAME_MAX + 256];


        ycw = &yc_win;


	/* Get and sanitize old page number. */
	old_page_num = ycw->cur_page;
	if(old_page_num >= YC_TOTAL_PAGES)
	    old_page_num = YC_TOTAL_PAGES - 1;
	if(old_page_num < 0)
	    old_page_num = 0;


        /* No change in page number? */
        if(new_page_num == old_page_num)
            return;


	/* Exited? */
	if(new_page_num < 0)
	{
	    new_page_num = 0;

	    YCExitCB(NULL, NULL, NULL);
	    return;
	}
	/* Finished? */
	else if(new_page_num >= YC_TOTAL_PAGES)
	{
	    new_page_num = YC_TOTAL_PAGES - 1;

	    /* Get value from rcfile name text entry. */
            strptr = gtk_entry_get_text(
                GTK_ENTRY(ycw->rcfile_name_text)
            );
	    if(strptr != NULL)
		strncpy(fname.rcfile, strptr, PATH_MAX + NAME_MAX);
	    fname.rcfile[PATH_MAX + NAME_MAX - 1] = '\0';

	    /* Save changes. */
	    status = RCSaveToFile(fname.rcfile);
	    if(status)
	    {
		sprintf(text,
"Error saving configuration file:\n\
\n\
    %s\n\
\n\
Check if the directory you are saving to exists\n\
and has write permission. You always save the configuration\n\
file to /tmp and then move it to the appropriate directory\n\
later.",
		    fname.rcfile
		);
		dprint(&dialog, text);
	    }
	    else
	    {
	        YCExitCB(NULL, NULL, NULL);
		return;
	    }
	}
	/* Connect to Y server page? */
	else if((new_page_num == 0) &&
	        (YC_TOTAL_PAGES > 0)
	)
	{
	    gtk_widget_show(ycw->page_toplevel[0]);







	    /* Change back button label to exit. */
	    gtk_widget_destroy(ycw->back_btn_label);
            w = gtk_label_new("Exit");
            ycw->back_btn_label = w;
            gtk_container_add(GTK_CONTAINER(ycw->back_btn), w);
            gtk_widget_show(w);

            /* Set new page number. */
            ycw->cur_page = new_page_num;
	}
	/* Audio modes page? */
	else if((new_page_num == 1) &&
	        (YC_TOTAL_PAGES > 1)
	)
	{
	    gchar start_cmd[PATH_MAX + NAME_MAX];
	    gchar connect_arg[256];


            gtk_widget_show(ycw->page_toplevel[1]);


	    /* (Re)connect if previous page was 0. */
	    if(old_page_num == 0)
	    {
		/* Close existing connection if connected. */
		YCloseConnection(ycw->con, False);
		ycw->con = NULL;

		if(!GTK_TOGGLE_BUTTON(ycw->no_start_svr_btn)->active)
		{
		    strptr = gtk_entry_get_text(
                            GTK_ENTRY(ycw->svr_start_cmd_text)
                    );
		    strncpy(
			start_cmd,
			((strptr == NULL) ? DEF_YSERVER_START_CMD : strptr),
			PATH_MAX + NAME_MAX
		    );
		    start_cmd[PATH_MAX + NAME_MAX - 1] = '\0';

                    strptr = gtk_entry_get_text(
                            GTK_ENTRY(ycw->svr_addr_text)
                    );
                    strncpy(
                        connect_arg,
                        ((strptr == NULL) ? DEF_YSERVER_ADDRESS : strptr),
                        256
                    );
                    connect_arg[256 - 1] = '\0';


		    ycw->con = YOpenConnection(
			start_cmd, connect_arg
		    );
		    if(ycw->con == NULL)
		    {
			dprint(&dialog,
"Unable to connect to the YIFF Sound Server. This program can\n\
continue, however if you want to run the YIFF Sound Server\n\
during this configuration then you will need to click on\n\
the `Back' button and verify that the start and connect\n\
arguments are correct."
			);
		    }
		}
	    }



            /* Need to change back button labels. */
            change_back_labels = TRUE;

            /* Set new page number. */
            ycw->cur_page = new_page_num;
	}
	/* Server parameters page? */
	else if((new_page_num == 2) &&
	        (YC_TOTAL_PAGES > 2)
	)
	{
            gtk_widget_show(ycw->page_toplevel[2]);


            /* Check if Audio modes were defined if previous
	     * page was 1.
	     */
            if(old_page_num == 1)
            {
		if(ycw->total_audio_modes <= 0)
		{
		    dprint(&dialog,
"Warning: No Audio modes defined, you should have at least\n\
one Audio mode defined."
		    );
		}
	    }



	    /* Need to change back button labels. */
	    change_back_labels = TRUE;

            /* Set new page number. */
            ycw->cur_page = new_page_num;
	}
	/* Sound paths page? */
        else if((new_page_num == 3) &&
                (YC_TOTAL_PAGES > 3)
        )
        {
            gtk_widget_show(ycw->page_toplevel[3]);







            /* Need to change back button labels. */
            change_back_labels = TRUE;

            /* Set new page number. */
            ycw->cur_page = new_page_num;
        }
        /* Save configuration page (finish comfermation)? */
	else if((new_page_num == 4) &&
	        (YC_TOTAL_PAGES > 4)
	)
	{
            gtk_widget_show(ycw->page_toplevel[4]);


            /* Change next button label to finish. */
            gtk_widget_destroy(ycw->next_btn_label);
            w = gtk_label_new("Finish");
            ycw->next_btn_label = w;
            gtk_container_add(GTK_CONTAINER(ycw->next_btn), w);
            gtk_widget_show(w);

            /* Set new page number. */
            ycw->cur_page = new_page_num;
	}


	/* Hide all toplevel pages except new_page_num. */
        for(i = 0; i < YC_TOTAL_PAGES; i++)
	{
	    if(i == new_page_num)
		continue;

            gtk_widget_hide(ycw->page_toplevel[i]);
	}


	/* Change back and next button labels? */
	if(change_back_labels)
	{
            gtk_widget_destroy(ycw->back_btn_label);
            w = gtk_label_new("Back");
            ycw->back_btn_label = w;
            gtk_container_add(GTK_CONTAINER(ycw->back_btn), w);
            gtk_widget_show(w);

            gtk_widget_destroy(ycw->next_btn_label);
            w = gtk_label_new("Next");
            ycw->next_btn_label = w;
            gtk_container_add(GTK_CONTAINER(ycw->next_btn), w);
            gtk_widget_show(w);

	    /* Set new page number. */
	    ycw->cur_page = new_page_num;
	}


	return;
}

/*
 *	Back button callback.
 */
void YCBackBtnCB(GtkWidget *widget, gpointer data)
{
        yc_win_struct *ycw;
        
        
        ycw = (yc_win_struct *)data;
        if(ycw == NULL)
            return;

	YCPageChangeCB(ycw->cur_page - 1);

	return;
}

/*
 *	Next button callback.
 */
void YCNextBtnCB(GtkWidget *widget, gpointer data)
{
        yc_win_struct *ycw;


        ycw = (yc_win_struct *)data;
	if(ycw == NULL)
	    return;

        YCPageChangeCB(ycw->cur_page + 1);

	return;
}

/*
 *	Do not start or connect to server toggle button
 *	callback.
 */
void YCDoNotStartServerBtnCB(GtkWidget *widget, gpointer data)
{
        yc_win_struct *ycw;
              
              
        ycw = (yc_win_struct *)data;
        if(ycw == NULL)
            return;

	if(GTK_TOGGLE_BUTTON(widget)->active)
	{
            gtk_entry_set_editable(
		GTK_ENTRY(ycw->svr_addr_text), FALSE
	    );
            gtk_entry_set_editable(
                GTK_ENTRY(ycw->svr_start_cmd_text), FALSE
            );
	}
	else
	{
            gtk_entry_set_editable(
                GTK_ENTRY(ycw->svr_addr_text), TRUE  
            );
            gtk_entry_set_editable(
                GTK_ENTRY(ycw->svr_start_cmd_text), TRUE
            );
	}

	return;
}


/*
 *	Add Audio mode button callback.
 */
void YCAddModeBtnCB(GtkWidget *widget, gpointer data)
{
	add_mode_dialog_struct *amd;
        yc_win_struct *ycw;
	GtkWidget *w;

        ycw = (yc_win_struct *)data;


	amd = &add_mode_dialog;
	amd->ref_ycw = ycw;

	w = amd->toplevel;
	gtk_widget_show(w);


        return;
}

/*
 *	Remove Audio mode button callback.
 */
void YCRemoveModeBtnCB(GtkWidget *widget, gpointer data)  
{
	gint i, sel_row;
        yc_win_struct *ycw;


        ycw = (yc_win_struct *)data;

	/* Get selected row number. */
        sel_row = ycw->cur_sel_audio_mode;
        if(sel_row < 0)
            return;

	/* Remove item on list widget. */
        gtk_clist_remove(
            (GtkCList *)ycw->audio_modes_list,
            sel_row
        );

	/* Remove audio mode. */
	if((sel_row >= 0) && (sel_row < ycw->total_audio_modes))
	{
	    free(ycw->audio_mode[sel_row]);

	    /* Reduce total. */
	    ycw->total_audio_modes--;

	    /* Shift pointer array down. */
	    for(i = sel_row; i < ycw->total_audio_modes; i++)
	        ycw->audio_mode[i] = ycw->audio_mode[i + 1];

	    if(ycw->total_audio_modes > 0)
	    {
		ycw->audio_mode = (audio_mode_struct **)realloc(
		    ycw->audio_mode,
		    ycw->total_audio_modes * sizeof(audio_mode_struct *)
		);
		if(ycw->audio_mode == NULL)
		{
		    ycw->total_audio_modes = 0;
		    return;
		}
	    }
	    else
	    {
		free(ycw->audio_mode);
		ycw->audio_mode = NULL;

		ycw->total_audio_modes = 0;
	    }
	}


	/* Unselect. */
        ycw->cur_sel_audio_mode = -1;

        return;
}

void YCModeShiftUpBtnCB(GtkWidget *widget, gpointer data)
{
        gint sel_row, target_row;
        yc_win_struct *ycw;
	gchar *strptr;
	GtkCList *clist;
	audio_mode_struct *mode_ptr;
	gchar text1[256], text2[256];


        ycw = (yc_win_struct *)data;
	if(ycw == NULL)
	    return;

	clist = GTK_CLIST(ycw->audio_modes_list);
	if(clist == NULL)
	    return;

        /* Get selected row number. */
        sel_row = ycw->cur_sel_audio_mode;
        if((sel_row < 1) || (sel_row >= ycw->total_audio_modes))
            return;

	target_row = sel_row - 1;


        /* This will set audio mode to match widget values. */
        YCAudioModesListCB(GTK_WIDGET(clist), sel_row, 0, NULL, ycw);


	/* Get clist item names. */
	strptr = NULL;
	gtk_clist_get_text(clist, sel_row, 0, &strptr);
	strncpy(text1, ((strptr == NULL) ? "" : strptr), 256);
	text1[256 - 1] = '\0';

        strptr = NULL;
        gtk_clist_get_text(clist, target_row, 0, &strptr);
        strncpy(text2, ((strptr == NULL) ? "" : strptr), 256);
	text2[256 - 1] = '\0';

	/* Set new item names on clist. */
	gtk_clist_set_text(
	    clist,
            sel_row, 0,		/* Row, colum. */
	    text2
	);
        gtk_clist_set_text( 
            clist,
            target_row, 0,	/* Row, colum. */
            text1
        );


	/* Need to unselect current audio mode for what we're
	 * about to do.
	 */
	ycw->cur_sel_audio_mode = -1;

	/* Swap audio mode pointers. */
	mode_ptr = ycw->audio_mode[sel_row];
	ycw->audio_mode[sel_row] = ycw->audio_mode[target_row];
	ycw->audio_mode[target_row] = mode_ptr;

	/* Force change in row selection on clist. */
	gtk_clist_unselect_row(clist, sel_row, 0);
	gtk_clist_select_row(clist, target_row, 0);


	return;
}

void YCModeShiftDownBtnCB(GtkWidget *widget, gpointer data)
{
        gint sel_row, target_row;
        yc_win_struct *ycw;
        gchar *strptr;
        GtkCList *clist;
        audio_mode_struct *mode_ptr;
        gchar text1[256], text2[256];


        ycw = (yc_win_struct *)data;
        if(ycw == NULL)
            return;

        clist = GTK_CLIST(ycw->audio_modes_list);
        if(clist == NULL)
            return;


        /* Get selected row number. */
        sel_row = ycw->cur_sel_audio_mode;
        if((sel_row < 0) || (sel_row >= (ycw->total_audio_modes - 1)))
            return;

        target_row = sel_row + 1;


	/* This will set audio mode to match widget values. */
	YCAudioModesListCB(GTK_WIDGET(clist), sel_row, 0, NULL, ycw);


        /* Get clist item names. */
        strptr = NULL;
        gtk_clist_get_text(clist, sel_row, 0, &strptr);
        strncpy(text1, ((strptr == NULL) ? "" : strptr), 256);
        text1[256 - 1] = '\0';

        strptr = NULL;
        gtk_clist_get_text(clist, target_row, 0, &strptr);
        strncpy(text2, ((strptr == NULL) ? "" : strptr), 256);
        text2[256 - 1] = '\0';

        /* Set new item names on clist. */
        gtk_clist_set_text(
            clist,
            sel_row, 0,         /* Row, colum. */
            text2
        );
        gtk_clist_set_text(
            clist,
            target_row, 0,      /* Row, colum. */
            text1
        );


        /* Need to unselect current audio mode for what we're
         * about to do.
         */
        ycw->cur_sel_audio_mode = -1;

        /* Swap audio mode pointers. */
        mode_ptr = ycw->audio_mode[sel_row];
        ycw->audio_mode[sel_row] = ycw->audio_mode[target_row];
        ycw->audio_mode[target_row] = mode_ptr;

        /* Force change in row selection on clist. */
        gtk_clist_unselect_row(clist, sel_row, 0);
        gtk_clist_select_row(clist, target_row, 0);


	return;
}

/*
 *	Applies values from widgets to previously selected mode
 *	(if was selected) and fetches values from mode to widgets
 *	of newly selected mode.
 *
 *	Does NOT update values on the YIFF sound server, see
 *	YCApplyChangesBtnCB() for that.
 */
void YCAudioModesListCB(
        GtkWidget *clist,
        gint row,
        gint column,
        GdkEventButton *event,
        gpointer data
)
{
        gint i, old_sel_row, new_sel_row;
	gchar *strptr;
        yc_win_struct *ycw;
        audio_mode_struct *mode_ptr;
	GtkWidget *w;
	GtkAdjustment *gadj;
	char text[256];


        ycw = &yc_win;


	/* Get previous and newly selected row numbers. */
	old_sel_row = ycw->cur_sel_audio_mode;
        new_sel_row = row;


	/* Get pointer to previously selected row. */
	if((old_sel_row >= 0) && (old_sel_row < ycw->total_audio_modes))
	    mode_ptr = ycw->audio_mode[old_sel_row];
	else
	    mode_ptr = NULL;

	/* Set Audio mode to match widget values. */
	if(mode_ptr != NULL)
	{
            /* Sample rate. */
            w = ycw->sample_rate_combo;
            strptr = gtk_entry_get_text(
                GTK_ENTRY(GTK_COMBO(w)->entry)
            );
            if(strptr != NULL)
            { 
                mode_ptr->sample_rate = atoi(strptr);
            }

            /* Channels. */
            w = ycw->channels_tb1;
            if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
            {
                i = 1;
            }
            else
            {
                w = ycw->channels_tb2;
                if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
                    i = 2;
		else
		    i = 1;
            }
            mode_ptr->channels = i;  

            /* Fragment size. */
	    w = ycw->fragment_size_combo;
            strptr = gtk_entry_get_text(
		GTK_ENTRY(GTK_COMBO(w)->entry)
	    );
	    if(strptr != NULL)
	    {
	        mode_ptr->fragment_size = atoi(strptr);
	    }

	    /* Get bits. */
	    w = ycw->sample_size_tb8;
            if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
            {
		i = 8;
	    }
	    else
	    {
		w = ycw->sample_size_tb16;
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
		    i = 16;
                else
		    i = 8;
	    }
            mode_ptr->sample_size = i;

	    /* Cycle. */
	    gadj = gtk_range_get_adjustment(
		GTK_RANGE(ycw->cycle_scale)
	    );
	    if(gadj != NULL)
		mode_ptr->cycle_us = gadj->value;

	    /* Write ahead (force set to 1.5 times cycle for now. */
	    mode_ptr->write_ahead_us = mode_ptr->cycle_us * 1.5;
	}


        /* Get pointer to newly selected row. */
        if((new_sel_row >= 0) && (new_sel_row < ycw->total_audio_modes))
            mode_ptr = ycw->audio_mode[new_sel_row];
        else
            mode_ptr = NULL;

	/* Set widget values to match Audio mode. */
        if(mode_ptr != NULL)
        {
            /* Sample rate. */
            w = ycw->sample_rate_combo;
            sprintf(text, "%i", mode_ptr->sample_rate);
            gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(w)->entry), text);

            /* Channels. */
            w = ycw->channels_tb1;
            gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(w),
                ((mode_ptr->channels == 1) ? TRUE : FALSE)
            );
            w = ycw->channels_tb2;
            gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(w),
                ((mode_ptr->channels == 2) ? TRUE : FALSE)
            );

            /* Fragment size. */
            w = ycw->fragment_size_combo;
            sprintf(text, "%i", mode_ptr->fragment_size);
            gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(w)->entry), text);

            /* Bits. */
            w = ycw->sample_size_tb8;
            gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(w),
                ((mode_ptr->sample_size == 8) ? TRUE : FALSE)
            );
            w = ycw->sample_size_tb16;
            gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(w),
                ((mode_ptr->sample_size == 16) ? TRUE : FALSE)
            );

            /* Cycle. */
            gadj = gtk_range_get_adjustment(
                GTK_RANGE(ycw->cycle_scale)
            );
            if(gadj != NULL)
            {
                gadj->value = mode_ptr->cycle_us;
                gtk_signal_emit_by_name(GTK_OBJECT(gadj), "changed");
            }
        }


	/* Update selected row number. */
	ycw->cur_sel_audio_mode = new_sel_row;


        return;
}

/*
 *	Applies values from widgets to the currently selected
 *	Audio mode, updates the Audio mode values to the Y server,
 *	calculates the `theoretical' cycle value for the current
 *	Audio mode values, updates the cycle scale bar, and applies
 *	the new cycle value to the Y server.
 */
void YCCalculateBtnCB(GtkWidget *widget, gpointer data)
{
	gint sel_mode;
        yc_win_struct *ycw;
	audio_mode_struct *mode_ptr;
	GtkAdjustment *gadj;

        
        ycw = &yc_win;


	/* Apply changes to currently selected audio mode. */
	YCApplyChangesBtnCB(NULL, ycw);


	sel_mode = ycw->cur_sel_audio_mode;
	if((sel_mode >= 0) && (sel_mode < ycw->total_audio_modes))
	    mode_ptr = ycw->audio_mode[sel_mode];
	else
	    mode_ptr = NULL;

	if(mode_ptr != NULL)
	{
	    mode_ptr->cycle_us = YCalculateCycle(
                ycw->con,
                mode_ptr->sample_rate, mode_ptr->channels,
                mode_ptr->sample_size, mode_ptr->fragment_size
            );

	    gadj = gtk_range_get_adjustment(
		GTK_RANGE(ycw->cycle_scale)
	    );
	    if(gadj != NULL)
	    {
		gadj->value = mode_ptr->cycle_us;
		gtk_signal_emit_by_name(GTK_OBJECT(gadj), "changed");
	    }
	}


        return;
}

/*
 *	Cycle scale bar callback.
 */
void YCCycleScaleCB(GtkAdjustment *adj, GtkWidget *scale)
{
        gint i;
        audio_mode_struct *mode_ptr;
        yc_win_struct *ycw;
	GtkAdjustment *gadj;


        ycw = &yc_win;


        i = ycw->cur_sel_audio_mode;
        if((i < 0) || (i >= ycw->total_audio_modes))
            mode_ptr = NULL;
        else   
            mode_ptr = ycw->audio_mode[i];

	if(mode_ptr != NULL)
	{
	    gadj = gtk_range_get_adjustment(
		GTK_RANGE(ycw->cycle_scale)
	    );
	    if(gadj != NULL)
	    {
		mode_ptr->cycle_us = (long)gadj->value;
		YSetCycle(ycw->con, mode_ptr->cycle_us);
	    }
	}

	return;
}

/*
 *	Fetches values from widgets and stores into selected
 *	Audio mode, then applies the same Audio mode values to
 *	the Y server.
 */
void YCApplyChangesBtnCB(GtkWidget *widget, gpointer data)
{
	gint i;
	audio_mode_struct *mode_ptr;
        yc_win_struct *ycw;


        ycw = &yc_win;


	if(ycw->cur_sel_audio_mode < 0)
	    return;

	YCAudioModesListCB(
            ycw->audio_modes_list,
	    ycw->cur_sel_audio_mode, 0,	/* Row, colum. */
	    NULL,
	    ycw
	);


	/* Update Audio mode values to YIFF Sound Server. */
	i = ycw->cur_sel_audio_mode;
	if((i < 0) || (i >= ycw->total_audio_modes))
	    mode_ptr = NULL;
	else
	    mode_ptr = ycw->audio_mode[i];

	if(mode_ptr != NULL)
	{
	    YSetAudioModeValues(  
	        ycw->con,
                mode_ptr->sample_size,
                mode_ptr->channels,
                mode_ptr->sample_rate,
		mode_ptr->direction,	/* Play or record. */
                mode_ptr->allow_fragmenting,	/* Allow fragmenting. */
                mode_ptr->num_fragments,	/* Number of fragments. */
                mode_ptr->fragment_size		/* In bytes. */
            );

	    YSetCycle(ycw->con, mode_ptr->cycle_us);
	}


        return;
}


/*
 *	Removes the currently selected sound path.
 */
void YCRemoveSoundPathBtnCB(GtkWidget *widget, gpointer data)
{
        gint i, sel_row;
        yc_win_struct *ycw;
	GtkCList *clist;


        ycw = (yc_win_struct *)data;
	if(ycw == NULL)
	    return;
	clist = GTK_CLIST(ycw->sound_paths_list);
	if(clist == NULL)
	    return;


        /* Get selected row number. */
        sel_row = ycw->cur_sel_sound_path;
        if(sel_row < 0)
            return;

        /* Remove item on list widget. */ 
        gtk_clist_remove(clist, sel_row);


	/* Reduce global total. */
	ycw->total_sound_paths--;

	if(ycw->total_sound_paths < 0)
	    ycw->total_sound_paths = 0;


        /* Unselect current sound path. */
        ycw->cur_sel_sound_path = -1;


	return;
}

void YCAddSoundPathBtnCB(GtkWidget *widget, gpointer data)
{
        gint i, sel_row;
	gchar *strptr, *strptr2;
        yc_win_struct *ycw;
        GtkCList *clist;
	gchar *text[1];
	gchar text2[PATH_MAX + NAME_MAX + 512];
	struct stat stat_buf;


        ycw = (yc_win_struct *)data;
        if(ycw == NULL)
            return;
        clist = GTK_CLIST(ycw->sound_paths_list);
        if(clist == NULL)
            return;


        /* Sanitize total. */
        if(ycw->total_sound_paths < 0)
            ycw->total_sound_paths = 0;


        /* Get new name entered on amd's name text widget. */
        strptr = gtk_entry_get_text(
            GTK_ENTRY(ycw->sound_path_add_text)
        );
        /* Check if name is valid. */
        if(strptr == NULL)
        {
            dprint(&dialog,
 "Cannot get sound path from entry (internal error)."
            );
            return;
        }
        if(strlen(strptr) <= 0)
        {
	    /* Used didn't type in any characters. */
            dprint(&dialog,
 "Enter a Sound Path (a directory) first, then press `Add'."
            );
            return;
        }
	if(stat(strptr, &stat_buf))
	{
	    sprintf(text2,
"Warning, Sound Path:\n\n\
    %s\n\n\
Does not exist on this physical computer.",
                strptr
            );
            dprint(&dialog, text2);
	}
	else
	{
	    if(!S_ISDIR(stat_buf.st_mode))
	    {
                sprintf(text2,
"Warning, Sound Path:\n\n\
    %s\n\n\
Is not a directory type object, Sound Paths must be directories.",
                    strptr
                );
                dprint(&dialog, text2);
	    }
	}
	for(i = 0; i < ycw->total_sound_paths; i++)
	{
	    strptr2 = NULL;
	    gtk_clist_get_text(clist, i, 0, &strptr2);
	    if(strptr2 == NULL)
		continue;

	    if(!strcmp(strptr, strptr2))
	    {
		sprintf(text2,
"Warning, Sound Path:\n\n\
    %s\n\n\
Already exists in the Sound Paths list.",
		    strptr
		);
		dprint(&dialog, text2);
		break;
	    }
	}

	/* Set text array index 0 to point to the entry input. */
	text[0] = strptr;

        sel_row = ycw->cur_sel_sound_path;
        /* If not selected, then append. */
        if(sel_row < 0)
        {
            gtk_clist_append(clist, text);
        }
        else
        {
            gtk_clist_insert(clist, sel_row, text);

            /* Change selected row number. */
            ycw->cur_sel_sound_path++;
        }

	/* Increment total. */
	ycw->total_sound_paths++;

	return;
}

void YCSoundPathShiftUpBtnCB(GtkWidget *widget, gpointer data)
{
        gint sel_row, target_row;
        yc_win_struct *ycw;
        gchar *strptr;
        GtkCList *clist;
        gchar text1[PATH_MAX + NAME_MAX], text2[PATH_MAX + NAME_MAX];


        ycw = (yc_win_struct *)data;
        if(ycw == NULL)
            return;

        clist = GTK_CLIST(ycw->sound_paths_list);
        if(clist == NULL)
            return;

        /* Get selected row number. */
        sel_row = ycw->cur_sel_sound_path;
        if((sel_row < 1) || (sel_row >= ycw->total_sound_paths))
            return;

        target_row = sel_row - 1;


        /* Match up list with widget values. */
        YCSoundPathListCB(GTK_WIDGET(clist), sel_row, 0, NULL, ycw);


        /* Get clist item names. */
        strptr = NULL;
        gtk_clist_get_text(clist, sel_row, 0, &strptr);
        strncpy(text1, ((strptr == NULL) ? "" : strptr), PATH_MAX + NAME_MAX);
        text1[PATH_MAX + NAME_MAX - 1] = '\0';

        strptr = NULL;
        gtk_clist_get_text(clist, target_row, 0, &strptr);
        strncpy(text2, ((strptr == NULL) ? "" : strptr), PATH_MAX + NAME_MAX);
        text2[PATH_MAX + NAME_MAX - 1] = '\0';

        /* Set new item names on clist. */
        gtk_clist_set_text(
            clist,
            sel_row, 0,         /* Row, colum. */
            text2  
        );
        gtk_clist_set_text(
            clist,
            target_row, 0,      /* Row, colum. */
            text1
        );


	/* Need to unselect current item for what we're about to do. */
	ycw->cur_sel_sound_path = -1;

        /* Force change in row selection on clist. */
        gtk_clist_unselect_row(clist, sel_row, 0);
        gtk_clist_select_row(clist, target_row, 0);


	return;
}

void YCSoundPathShiftDownBtnCB(GtkWidget *widget, gpointer data)
{
        gint sel_row, target_row;
        yc_win_struct *ycw;
        gchar *strptr;
        GtkCList *clist;
        gchar text1[PATH_MAX + NAME_MAX], text2[PATH_MAX + NAME_MAX];


        ycw = (yc_win_struct *)data;
        if(ycw == NULL)
            return;

        clist = GTK_CLIST(ycw->sound_paths_list);
        if(clist == NULL)
            return;

        /* Get selected row number. */
        sel_row = ycw->cur_sel_sound_path;
        if((sel_row < 0) || (sel_row >= (ycw->total_sound_paths - 1)))
            return;

        target_row = sel_row + 1;


        /* Match up list with widget values. */
        YCSoundPathListCB(GTK_WIDGET(clist), sel_row, 0, NULL, ycw);


        /* Get clist item names. */
        strptr = NULL;
        gtk_clist_get_text(clist, sel_row, 0, &strptr);
        strncpy(text1, ((strptr == NULL) ? "" : strptr), PATH_MAX + NAME_MAX);
        text1[PATH_MAX + NAME_MAX - 1] = '\0';

        strptr = NULL;
        gtk_clist_get_text(clist, target_row, 0, &strptr);
        strncpy(text2, ((strptr == NULL) ? "" : strptr), PATH_MAX + NAME_MAX);
        text2[PATH_MAX + NAME_MAX - 1] = '\0';

        /* Set new item names on clist. */
        gtk_clist_set_text(
            clist,
            sel_row, 0,         /* Row, colum. */
            text2  
        );
        gtk_clist_set_text(
            clist,
            target_row, 0,      /* Row, colum. */
            text1
        );


	/* Need to unselect current item for what we're about to do. */
	ycw->cur_sel_sound_path = -1;

        /* Force change in row selection on clist. */
        gtk_clist_unselect_row(clist, sel_row, 0);
        gtk_clist_select_row(clist, target_row, 0);


	return;
}

void YCSoundPathListCB(
	GtkWidget *clist,
	gint row,
	gint column,
	GdkEventButton *event,
	gpointer data
)
{
        yc_win_struct *ycw;


        ycw = (yc_win_struct *)data;
	if(ycw == NULL)
	    return;

	/* Update currently selected row. */
	ycw->cur_sel_sound_path = row;


	return;
}
