/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "cercle.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *font_gc;

// Common methods for circle object
void cercle_c::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this circle %1"));
  strinsmsg (nom_type, nom, "%1");
}
point_s cercle_c::
centre (void)
{
  return (C->coordonnees ());
}
void cercle_c::
dessine (GdkPixmap * ecran, char force)
{
  int x, y, r;
  point_s co;
  if ((masque == OBJET_MACRO) || (masque && !force) || !existe)
    return;
  co = centre ();
  x = ECRx (co.x);
  y = ECRy (co.y);
  r = int (rayon () * ECHELLE);
  if ((style & 128) == 0)
    {
      switch (epaisseur)
	{
	case 0:
	  dotted_circle (ecran, x, y, r, couleur, 1);
	  break;
	case 1:
	  dotted_circle (ecran, x, y, r, couleur, 2);
	  break;
	case 2:
	  gcircle (ecran, x, y, r, couleur);
	  break;
	case 3:
	  thick_circle (ecran, x, y, r, couleur, EPAIS);
	  break;
	}
    }
  else
    circlefilled (ecran, x, y, r, couleur);
}
char cercle_c::
appartient (int xm, int ym)
{
  double d, x, y;
  point_s co;
  co = centre ();
  x = MONx (xm) - co.x;
  y = MONy (ym) - co.y;
  d = fabs (sqrt (x * x + y * y) - rayon ());
  if (d <= RI)
    return TRUE;
  else
    return FALSE;
}
void cercle_c::
move (int xm, int ym)
{
}
// Member function of class 'cercle1', circle defined by its center and a point on the circle
char cercle1::
dependance (figure_c * fig)
{
  return (C == fig || A == fig);
}
void cercle1::
actualise (void)
{
  if (!A->existe || !C->existe)
    {
      existe = FALSE;
      return;
    }
  if (rayon () == 0)
    existe = FALSE;
  else
    existe = TRUE;
}
double cercle1::
rayon ()
{
  point_s co, c;
  double ra;
  c = centre ();
  co = A->coordonnees ();
  co.x -= c.x;
  co.y -= c.y;
  ra = co.x * co.x + co.y * co.y;
  ra = sqrt (ra);
  return (ra);
}
liste_elem *cercle1::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) C);
  liste_parent->ajoute ((void *) A);
  return liste_parent;
}
void cercle1::
move (int xm, int ym)
{
  A->move (xm, ym);
  C->move (xm, ym);
  actualise ();
}
void cercle1::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) C);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) A);
  fwrite (&pos, 1, sizeof (pos), f);
}
void cercle1::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  C = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  A = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// Member function of class 'cercle2', circle defined by its center and radius (given by a segment's length)
char cercle2::
dependance (figure_c * fig)
{
  return (S == fig || C == fig);
}
void cercle2::
actualise (void)
{
  if (!S->existe || !C->existe)
    {
      existe = FALSE;
      return;
    }
  if (rayon () == 0)
    existe = FALSE;
  else
    existe = TRUE;
}
double cercle2::
rayon ()
{
  return (S->longueur ());
}
liste_elem *cercle2::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) C);
  liste_parent->ajoute ((void *) S);
  return liste_parent;
}
void cercle2::
move (int xm, int ym)
{
  C->move (xm, ym);
  actualise ();
}
void cercle2::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) C);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) S);
  fwrite (&pos, 1, sizeof (pos), f);
}
void cercle2::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  C = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  S = (segment_c *) liste_figure.lire (pos);
  init_nom ();
}
// Member functions of class 'cercle3', circle defined by its center and radius (given number)
char cercle3::
dependance (figure_c * fig)
{
  return (V == fig || C == fig);
}
void cercle3::
actualise (void)
{
  if (V->valeur () <= 0 || !V->existe || !C->existe)
    existe = FALSE;
  else
    existe = TRUE;
}
double cercle3::
rayon ()
{
  return (V->valeur ());
}
liste_elem *cercle3::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) C);
  liste_parent->ajoute ((void *) V);
  return liste_parent;
}
void cercle3::
move (int xm, int ym)
{
  C->move (xm, ym);
  actualise ();
}
void cercle3::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) C);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) V);
  fwrite (&pos, 1, sizeof (pos), f);
}
void cercle3::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  C = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  V = (valeur_c *) liste_figure.lire (pos);
  init_nom ();
}
// Transformed circle
// By reflexion
char reflexion_cercle::
dependance (figure_c * fig)
{
  return (axe == fig || cercle == fig);
}
void reflexion_cercle::
actualise (void)
{
  if (!cercle->existe || !axe->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
}
double reflexion_cercle::
rayon ()
{
  return (cercle->rayon ());
}
point_s reflexion_cercle::
centre ()
{
  return reflexion_p (axe, cercle->centre ());
}
liste_elem *reflexion_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) axe);
  liste_parent->ajoute ((void *) cercle);
  return liste_parent;
}
void reflexion_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) axe);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) cercle);
  fwrite (&pos, 1, sizeof (pos), f);
}
void reflexion_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  axe = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  cercle = (cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
// By symetry
char symetrie_cercle::
dependance (figure_c * fig)
{
  return (symetrie == fig || cercle == fig);
}
void symetrie_cercle::
actualise (void)
{
  if (!cercle->existe || !symetrie->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
}
double symetrie_cercle::
rayon ()
{
  return (cercle->rayon ());
}
point_s symetrie_cercle::
centre ()
{
  return (2 * symetrie->coordonnees () - cercle->centre ());
}
liste_elem *symetrie_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) symetrie);
  liste_parent->ajoute ((void *) cercle);
  return liste_parent;
}
void symetrie_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) symetrie);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) cercle);
  fwrite (&pos, 1, sizeof (pos), f);
}
void symetrie_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  symetrie = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  cercle = (cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
// By translation
char translation_cercle::
dependance (figure_c * fig)
{
  return (v == fig || cercle == fig);
}
void translation_cercle::
actualise (void)
{
  if (!cercle->existe || !v->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
}
double translation_cercle::
rayon ()
{
  return (cercle->rayon ());
}
point_s translation_cercle::
centre ()
{
  return (v->vecteur () + cercle->centre ());
}
liste_elem *translation_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) v);
  liste_parent->ajoute ((void *) cercle);
  return liste_parent;
}
void translation_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) cercle);
  fwrite (&pos, 1, sizeof (pos), f);
}
void translation_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  v = (vecteur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  cercle = (cercle_c *) liste_figure.lire (pos);
  init_nom ();
}
// By rotation
char rotation_cercle::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || cercle == fig);
}
void rotation_cercle::
actualise (void)
{
  if (!cercle->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
}
double rotation_cercle::
rayon ()
{
  return (cercle->rayon ());
}
point_s rotation_cercle::
centre ()
{
  return rotation_p (c, v, cercle->centre ());
}
liste_elem *rotation_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) v);
  liste_parent->ajoute ((void *) c);
  liste_parent->ajoute ((void *) cercle);
  return liste_parent;
}
void rotation_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) cercle);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void rotation_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  cercle = (cercle_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// By homothetie
char homothetie_cercle::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || cercle == fig);
}
void homothetie_cercle::
actualise (void)
{
  if (!cercle->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
}
double homothetie_cercle::
rayon ()
{
  return (cercle->rayon () * fabs (v->val));
}
point_s homothetie_cercle::
centre ()
{
  return (c->p + (cercle->centre () - c->p) * v->val);
}
liste_elem *homothetie_cercle::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) v);
  liste_parent->ajoute ((void *) c);
  liste_parent->ajoute ((void *) cercle);
  return liste_parent;
}
void homothetie_cercle::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) cercle);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void homothetie_cercle::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  cercle = (cercle_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
