/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef demi_droite_h
#define demi_droite_h

#include <string.h>
#include <libintl.h>
#include <math.h>

#include "classbase.h"
#include "complexe.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

// Class derived from the base class demi_droite_c (half-line)
// Class 'demi_droite1', half-line defines by two points, its origin and a point of the half-line
class demi_droite1:public demi_droite_c
{
  public:
  point_c * M2;
  demi_droite1 (void):demi_droite_c ()
  {
    classe = DD_2PT;
  }
  demi_droite1 (liste_elem & lp):demi_droite_c ()
  {
    M1 = (point_c *) lp.lire (1);
    M2 = (point_c *) lp.lire (2);
    init_nom ();
    classe = DD_2PT;
  }
  demi_droite1 (char a, char b, char c, char d, liste_elem & lp):demi_droite_c (a, b, c, d)
  {
    M1 = (point_c *) lp.lire (1);
    M2 = (point_c *) lp.lire (2);
    init_nom ();
    classe = DD_2PT;
  }
  void actualise (void);
  liste_elem *parents (liste_elem * liste_parent);
  void move (int xm, int ym);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
  droite_s coordonnees (void);
  void init_nom (void);
};
// Transformed half-line
// By reflexion
class reflexion_demi_droite:public demi_droite_c
{
  public:
  droite_c * axe;
  demi_droite_c *demi_droite;
    reflexion_demi_droite (void):demi_droite_c ()
  {
    classe = DD_RE;
  }
  reflexion_demi_droite (liste_elem & lp):demi_droite_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_DROITE)
      {
	demi_droite = (demi_droite_c *) f2;
	axe = (droite_c *) f1;
      }
    else
      {
	demi_droite = (demi_droite_c *) f1;
	axe = (droite_c *) f2;
      }
    actualise ();
    classe = DD_RE;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By symetry
class symetrie_demi_droite:public demi_droite_c
{
  public:
  point_c * symetrie;
  demi_droite_c *demi_droite;
    symetrie_demi_droite ():demi_droite_c ()
  {
    classe = DD_SY;
  }
  symetrie_demi_droite (liste_elem & lp):demi_droite_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_POINT)
      {
	demi_droite = (demi_droite_c *) f2;
	symetrie = (point_c *) f1;
      }
    else
      {
	demi_droite = (demi_droite_c *) f1;
	symetrie = (point_c *) f2;
      }
    actualise ();
    classe = DD_SY;
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By translation
class translation_demi_droite:public demi_droite_c
{
  public:
  vecteur_c * v;
  demi_droite_c *demi_droite;
    translation_demi_droite ():demi_droite_c ()
  {
    classe = DD_TR;
  }
  translation_demi_droite (liste_elem & lp):demi_droite_c ()
  {
    figure_c *f1, *f2;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    if (f1->type == FIG_VECTEUR)
      {
	demi_droite = (demi_droite_c *) f2;
	v = (vecteur_c *) f1;
      }
    else
      {
	demi_droite = (demi_droite_c *) f1;
	v = (vecteur_c *) f2;
      }
    actualise ();
    classe = DD_TR;
    init_nom ();
  }
  droite_s coordonnees (void);
  liste_elem *parents (liste_elem * liste_parent);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By rotation
class rotation_demi_droite:public demi_droite_c
{
  public:
  valeur_c * v;
  point_c *c;
  demi_droite_c *demi_droite;
    rotation_demi_droite ():demi_droite_c ()
  {
    classe = DD_RO;
  }
  rotation_demi_droite (liste_elem & lp):demi_droite_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    classe = DD_RO;
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    demi_droite = (demi_droite_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    demi_droite = (demi_droite_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    demi_droite = (demi_droite_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    demi_droite = (demi_droite_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    demi_droite = (demi_droite_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    demi_droite = (demi_droite_c *) f1;
	  }
      }
    actualise ();
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};
// By homothetie
class homothetie_demi_droite:public demi_droite_c
{
  public:
  valeur_c * v;
  point_c *c;
  demi_droite_c *demi_droite;
    homothetie_demi_droite ():demi_droite_c ()
  {
    classe = DD_HO;
  }
  homothetie_demi_droite (liste_elem & lp):demi_droite_c ()
  {
    figure_c *f1, *f2, *f3;
    f1 = (figure_c *) lp.lire (1);
    f2 = (figure_c *) lp.lire (2);
    f3 = (figure_c *) lp.lire (3);
    classe = DD_HO;
    if (f1->type == FIG_POINT)
      {
	c = (point_c *) f1;
	if (f2->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f2;
	    demi_droite = (demi_droite_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    demi_droite = (demi_droite_c *) f2;
	  }
      }
    else if (f2->type == FIG_POINT)
      {
	c = (point_c *) f2;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    demi_droite = (demi_droite_c *) f3;
	  }
	else
	  {
	    v = (valeur_c *) f3;
	    demi_droite = (demi_droite_c *) f1;
	  }
      }
    else
      {
	c = (point_c *) f3;
	if (f1->type == FIG_VALEUR)
	  {
	    v = (valeur_c *) f1;
	    demi_droite = (demi_droite_c *) f2;
	  }
	else
	  {
	    v = (valeur_c *) f2;
	    demi_droite = (demi_droite_c *) f1;
	  }
      }
    actualise ();
    init_nom ();
  }
  droite_s coordonnees (void);
  void actualise (void);
  vecteur_s normal (void);
  vecteur_s directeur (void);
  void sauve_disk (FILE * f);
  void lire_disk (FILE * f);
  char dependance (figure_c * fig);
};

#endif
