
/* Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <libintl.h>

#include "define.h"

extern char papier_peint, compteur, affiche_repere;
extern int objet_issue_macro_construction;
extern double ORIGIN_W, ORIGIN_H;
// Fonctions de traitements
#include "geoclass.h"
#include "mode_obj.h"
#include "gui.h"
#include "traite.h"
#include <string.h>
#include "main.h"
#include "tree.h"

extern liste_elem liste_figure, liste_figure_libre, liste_macro, selection,
 *flashing_list;
extern macro *selected_macro;
extern GdkPixmap *current_screen, *ecran1;
extern GtkWidget *menu, *main_window, *figure_drawing_area, *savefigure,
 *loadfigure;
extern GtkWidget *input_buildmacro, *macrolist;
extern GdkColor tab_couleur[];
extern char nom_fichier[];
extern int mode, mx, my;
extern int w_ecran, h_ecran;

char flashing = TRUE;

void
tapisser (GdkPixmap * ecran)
{
/*
   char nbx, nby, nb;
   int larg, haut;
   larg = ((GdkPixmap *) (datafile[PAPIER].dat))->w;
   haut = ((GdkPixmap *) (datafile[PAPIER].dat))->h;
   if (papier_peint)
   {
   nbx = (char (SCREEN_W / larg)) +1;
   nby = (char (SCREEN_H / haut)) +1;
   for (nb = nbx * nby; nb >= 0; nb--)
   blit ((GdkPixmap *) (datafile[PAPIER].dat), ecran, 0, 0, larg * (nb % nbx), haut * (char (nb / nbx)), larg, haut);
   }
   else
 */
  gdk_draw_rectangle (ecran,
		      figure_drawing_area->style->white_gc,
		      TRUE,
		      0, 0,
		      figure_drawing_area->allocation.width,
		      figure_drawing_area->allocation.height);

//  afficher_repere ();
}
void 
swap ()
{
  gdk_draw_pixmap (figure_drawing_area->window,
		   main_window->style->black_gc,
		   current_screen,
		   0, 0,
		   0, 0,
		   w_ecran, h_ecran);
}



void
type_souris (char type)
{
}
/*
   switch (type)
   {
   case CRAYON:
   show_mouse (NULL);
   set_mouse_sprite ((GdkPixmap *) datafile[SOURIS].dat);
   set_mouse_sprite_focus (0, 33);
   break;
   case TIRER:
   show_mouse (NULL);
   set_mouse_sprite ((GdkPixmap *) datafile[SOURIS_OVER].dat);
   set_mouse_sprite_focus (6, 2);
   break;
   }
   }
 */
// Test si la fig est sous la souris et si elle conviemt pour le type d'objet a creer
char
fig_sous_souris (liste_elem * sous_souris, creer_figure_c * creer_fig, liste_elem * selection)
{
  char trouve = FALSE;
  int Mx, My, a, nb;
  figure_c *fig;
  gtk_widget_get_pointer (figure_drawing_area, &Mx, &My);
  nb = liste_figure.nb_elem;
  liste_figure.init_lire ();
  sous_souris->vide ();
  for (a = 1; a <= nb; a++)
    {
      fig = (figure_c *) liste_figure.lire (0);
      if (fig->appartient (Mx, My) && creer_fig->utilisable1 (fig, *selection, fig) && fig->existe && (fig->masque == FALSE))
	{
	  sous_souris->ajoute ((void *) fig);
	  trouve = TRUE;
	}
    }
  return trouve;
}
// verifie si sous la souris se trouve un objet de type 'type'
char
fig_sous_souris (liste_elem * sous_souris, int type)
{
  char trouve = FALSE;
  int Mx, My, a, nb;
  figure_c *fig;
  gtk_widget_get_pointer (figure_drawing_area, &Mx, &My);
  nb = liste_figure.nb_elem;
  liste_figure.init_lire ();
  sous_souris->vide ();
  for (a = 1; a <= nb; a++)
    {
      fig = (figure_c *) liste_figure.lire (0);
      if (fig->appartient (Mx, My) && fig->existe && (fig->masque == FALSE) && fig->type == type)
	{
// Test si la fig est sous la souris et si elle conviemt pour le type d'objet a creer
	  sous_souris->ajoute ((void *) fig);
	  trouve = TRUE;
	}
    }
  return trouve;
}
// Test si des objets de liste_figure, non masques, qui exsite physiquement sont sous la souris
// Retourne leur liste dans sous_souris
char
fig_sous_souris (liste_elem * sous_souris)
{
  char trouve = FALSE;
  int Mx, My, a, nb;
  figure_c *fig;
  gtk_widget_get_pointer (figure_drawing_area, &Mx, &My);
  nb = liste_figure.nb_elem;
  liste_figure.init_lire ();
  sous_souris->vide ();
  for (a = 1; a <= nb; a++)
    {
      fig = (figure_c *) liste_figure.lire (0);
      if (fig->appartient (Mx, My) && fig->existe && (fig->masque == FALSE))
	{
	  sous_souris->ajoute ((void *) fig);
	  trouve = TRUE;
	}
    }
  return trouve;
}
// Verfifie s'il exsite des dependances relatives a cette objet (utile apres avoir efface un objet)
char
fig_utilisee (figure_c * fig)
{
  int n;
  char dependance = FALSE;
  n = liste_figure.nb_elem;
  liste_figure.init_lire ();
  while (n-- != 0 && dependance == FALSE)
    dependance = ((figure_c *) liste_figure.lire (0))->dependance (fig);
  return dependance;
}
char
fig_existe (figure_c * fig)
{
  liste_elem parent_orig, parent;
  int nb_figure;
  figure_c *obj;
  nb_figure = liste_figure.nb_elem;
  liste_figure.init_lire ();
  fig->parents (&parent_orig);
  while (nb_figure--)
    {
      obj = (figure_c *) liste_figure.lire (0);
      if (obj->classe == fig->classe)
	{
	  obj->parents (&parent);
	  if (liste_elem_egale (parent_orig, parent))
	    return TRUE;
	}
    }
  return FALSE;
}

char
fig_du_plan_sous_souris (liste_elem * sous_souris, liste_elem * liste, int toute)
{
/*
   fig sous la souris sans contrainte de creation d'obj. Pour selec de fig a mettre en forme 
 */
  char trouve = FALSE, point = FALSE;
  int Mx, My, a, nb;
  figure_c *fig;
  gtk_widget_get_pointer (figure_drawing_area, &Mx, &My);
  nb = liste->nb_elem;
  liste->init_lire ();
  sous_souris->vide ();
  for (a = 1; a <= nb; a++)
    {
      fig = (figure_c *) liste->lire (0);
      if (fig->appartient (Mx, My) && fig->masque != OBJET_MACRO && (fig->masque != OBJET_MASQUE || toute == TRUE))
	{
// Test si la fig est sous la souris et si elle conviemt pour le type d'objet a creer
	  sous_souris->ajoute ((void *) fig);
	  trouve = TRUE;
	  if (fig->type == FIG_POINT)
	    point = TRUE;
	}
    }
  // if we have one point, we remove all line on the mouse selection
  if (point)
    {
      sous_souris->init_lire ();
      nb = sous_souris->nb_elem;
      do
	{
	  fig = (figure_c *) sous_souris->lire (0);
	  if (fig->type == FIG_DROITE || fig->type == FIG_DEMI_DROITE ||
	      fig->type == FIG_SEGMENT || fig->type == FIG_VECTEUR ||
	      fig->type == FIG_CERCLE || fig->type == FIG_LIEU_PT ||
	      fig->type == FIG_ARC_CERCLE)
	    sous_souris->supprime ((void *) fig);
	}
      while (--nb != 0);
    }
  return trouve;
}

void
mise_a_jour (void)
{
  int a, nb;

  figure_c *fig;
  nb = liste_figure.nb_elem;

  for (a = 1; a <= nb; a++)
    {
      fig = (figure_c *) liste_figure.lire (a);
      fig->actualise ();
    }
}

// mise a jour des figures a partir de la figure numero indicei jusqu'a indicef
void
mise_a_jour (int indicei, int indicef, char mise_a_jour_lieu)
{
  int a;
  figure_c *fig;

  if (indicef < indicei)
    indicef = liste_figure.nb_elem;

  for (a = indicei; a <= indicef; a++)
    {
      fig = (figure_c *) liste_figure.lire (a);
      if (fig->type != FIG_LIEU_PT || mise_a_jour_lieu == TRUE)
	fig->actualise ();
    }
}

gint
clignote (gpointer data)
{
  int nb, a;
  char couleur;
  figure_c *fig;

  if (!flashing)
    return TRUE;
  ++compteur &= 63;
  nb = flashing_list->nb_elem;
  if (nb == 0)
    return TRUE;
  if (compteur == 44)
    {
      flashing_list->init_lire ();
      for (a = 1; a <= nb; a++)
	{
	  fig = (figure_c *) flashing_list->lire (0);
	  couleur = fig->couleur;
	  fig->couleur = GRIS_CLAIR;
	  if (mode == MISE_EN_FORME_MODE)
	    fig->dessine (figure_drawing_area->window, TRUE);
	  else
	    fig->dessine (figure_drawing_area->window, FALSE);
	  fig->couleur = couleur;
	}
    }
  else if (compteur == 63)
    {
      flashing_list->init_lire ();
      for (a = 1; a <= nb; a++)
	{
	  fig = (figure_c *) flashing_list->lire (0);
	  if (mode == MISE_EN_FORME_MODE)
	    fig->dessine (figure_drawing_area->window, TRUE);
	  else
	    fig->dessine (figure_drawing_area->window, FALSE);
	}
    }
  return TRUE;
}
void 
fin_clignote (liste_elem * selection)
{
  fin_clignote_no_vide (selection);
  selection->vide ();
}
void 
fin_clignote_no_vide (liste_elem * selection)
{
  int a, nb;
  figure_c *fig;
// disable flashing on selected object while we put them back to normal state 
  flashing = FALSE;
  nb = selection->nb_elem;
  if (nb == 0)
    {
      flashing = TRUE;
      return;
    }
  selection->init_lire ();
  for (a = 1; a <= nb; a++)
    {
      fig = (figure_c *) selection->lire (0);
      if (mode == MISE_EN_FORME_MODE)
	fig->dessine (figure_drawing_area->window, TRUE);
      else
	fig->dessine (figure_drawing_area->window, FALSE);
    }
  flashing = TRUE;
}

void
dessine_figure (void)
{
  int a, nb;
  figure_c *fig;
  nb = liste_figure.nb_elem;
  liste_figure.init_lire ();
  for (a = 1; a <= nb; a++)
    {
      fig = (figure_c *) liste_figure.lire (0);
      fig->dessine (current_screen, FALSE);
    }
}

void
dessine_tout (void)
{
  int a, nb;
  figure_c *fig;
  nb = liste_figure.nb_elem;
  liste_figure.init_lire ();
  for (a = 1; a <= nb; a++)
    {
      fig = (figure_c *) liste_figure.lire (0);
      if (mode == MISE_EN_FORME_MODE)
	fig->dessine (current_screen, TRUE);
      else
	fig->dessine (current_screen, FALSE);
    }
}

// When there is several object under the mouse, popup a menu to choose one element 
void
choisir_elem (liste_elem * sous_souris, int xe, int ye, guint32 time)
{
  GtkWidget *menu_item;
  int nb, a;
  figure_c *choix;

  if (menu)
    gtk_object_unref (GTK_OBJECT (menu));

  menu = gtk_menu_new ();
  nb = sous_souris->nb_elem;
  sous_souris->init_lire ();
  for (a = 0; a < nb; a++)
    {
      choix = (figure_c *) sous_souris->lire (0);
      menu_item = gtk_menu_item_new_with_label (choix->nom_type);
      gtk_menu_append (GTK_MENU (menu), menu_item);
      // the callback will be called with the choix pointer, so we can know wich figure object was choosen 
      gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
			  GTK_SIGNAL_FUNC (choose_object_menu_item),
			  (gpointer) choix);
      gtk_widget_show (menu_item);
    }
  mx = xe;
  my = ye;
  gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
		  1, time);
}

gint
choose_object_menu_item (GtkWidget * widget, gpointer choix)
{
  switch (mode)
    {
    case POINT_MODE:
      point_libre (mx, my, (figure_c *) choix);
      break;
    case POINT_MILIEU_MODE:
      point_milieu (mx, my, (figure_c *) choix);
      break;
    case POINT_INTER_MODE:
      point_inter (mx, my, (figure_c *) choix);
      break;
    case POINT_REPERE_MODE:
      point_repere (mx, my, (figure_c *) choix);
      break;
    case DROITE_MODE:
      droite (mx, my, (figure_c *) choix);
      break;
    case DEMI_DROITE_MODE:
      demi_droite (mx, my, (figure_c *) choix);
      break;
    case SEGMENT_MODE:
      segment (mx, my, (figure_c *) choix);
      break;
    case VECTEUR_MODE:
      vecteur (mx, my, (figure_c *) choix);
      break;
    case CERCLE_MODE:
      cercle (mx, my, (figure_c *) choix);
      break;
    case ARC_CERCLE_MODE:
      arc_cercle (mx, my, (figure_c *) choix);
      break;
    case LIEU_POINT_MODE:
      lieu_objet (mx, my, (figure_c *) choix);
      break;
    case DROITE_PARALLELE_MODE:
      droite_parallele (mx, my, (figure_c *) choix);
      break;
    case DROITE_ORTHOGONALE_MODE:
      droite_orthogonale (mx, my, (figure_c *) choix);
      break;
    case REFLEXION_MODE:
      reflexion (mx, my, (figure_c *) choix);
      break;
    case SYMETRIE_MODE:
      symetrie (mx, my, (figure_c *) choix);
      break;
    case TRANSLATION_MODE:
      translation (mx, my, (figure_c *) choix);
      break;
    case ROTATION_MODE:
      rotation (mx, my, (figure_c *) choix);
      break;
    case HOMOTHETIE_MODE:
      homothetie (mx, my, (figure_c *) choix);
      break;
    case NUMERIQUE_MODE:
      numerique (mx, my, (figure_c *) choix);
      break;
    case ANGLE_MODE:
      angle (mx, my, (figure_c *) choix);
      break;
    case COORDONNEES_MODE:
      coordonnees (mx, my, (figure_c *) choix);
      break;
    case MACRO_ENREGISTRE_MODE:
      macro_enregistre ((figure_c *) choix, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (input_buildmacro)) ? 0 : 1);
      break;
    case MACRO_PLAY_MODE:
      macro_play ((figure_c *) choix);
      break;
    case SOURIS_SELECT_MODE:
      // Ok we choose an object among other, we put it in selection
      selection.ajoute ((void *) choix);
      // Now we wait the user to move this point, so she should click again on it   
      break;
    case MISE_EN_FORME_MODE:
      // Ok we choose an object among other, we put it in selection
      selection.ajoute ((void *) choix);
      // Now the user can change the style of the object   
      break;
    case EFFACE_OBJET_MODE:
      efface_objet ((figure_c *) choix, 0);
      break;
    }
  return TRUE;
}

char
sauver_figure (GtkWidget * widget, gpointer data)
  // data = 0 we want to save a GEO file
  // data = 1 we want to save a MAC file
  // data = 2 we want to save the figure as XML file
  // data = 3 we want to save a macro as XML file
  // data = 3 we want to save an EPS file
{
  int nb, a, c, version = GEO_VERSION;
  char *pt;
  FILE *fichier;

  a = (int) data;

  switch (a)
    {
    case 0:
      // Get the filename choosen by the user
      strcpy (nom_fichier, gtk_file_selection_get_filename (GTK_FILE_SELECTION (savefigure)));
      if ((pt = strrchr (nom_fichier, '.')) == NULL)
	{
	  // no extension in the filename provided, let's append .geo at its end
	  strcat (nom_fichier, ".geo");
	  pt = strrchr (nom_fichier, '.');
	}
      // c : int type for the class type and number items
      fichier = fopen (nom_fichier, "w");
      if (fichier == NULL)
	{
	  g_print (_ ("Can't create the file %s\n"), nom_fichier);
	  gtk_widget_hide (savefigure);
	  return FALSE;
	}
      fwrite (&version, sizeof (version), 1, fichier);
      // Sauvegarde la liste de l'ensemble des objets geometriques
      nb = liste_figure.nb_elem;
      liste_figure.init_lire ();
      fwrite (&nb, sizeof (nb), 1, fichier);
      for (a = 1; a <= nb; a++)
	{
	  c = ((figure_c *) liste_figure.lire (0))->classe;
	  fwrite (&c, sizeof (c), 1, fichier);
	}
      // Puis sauvegarde la position dans 'liste_figure' des objets
      // geometriques libres
      nb = liste_figure_libre.nb_elem;
      liste_figure_libre.init_lire ();
      fwrite (&nb, sizeof (nb), 1, fichier);
      for (a = 1; a <= nb; a++)
	{
	  c = liste_figure.position (liste_figure_libre.lire (0));
	  fwrite (&c, sizeof (c), 1, fichier);
	}
      // Et enfin sauvegarde les parametres de chaque objet geometrique
      nb = liste_figure.nb_elem;
      liste_figure.init_lire ();
      for (a = 1; a <= nb; a++)
	{
	  ((figure_c *) liste_figure.lire (0))->sauve_disk (fichier);
	}
      fclose (fichier);
      gtk_widget_hide (savefigure);
      return TRUE;

    case 1:
      {
	char macrofilename[512];
	macro *mac;
	noyau_macro *n;

	// Get the filename choosen by the user
	strcpy (macrofilename, gtk_file_selection_get_filename (GTK_FILE_SELECTION (savefigure)));
	if ((pt = strrchr (macrofilename, '.')) == NULL)
	  {
	    // no extension in the filename provided, let's append .mac at its end
	    strcat (macrofilename, ".mac");
	    pt = strrchr (macrofilename, '.');
	  }

	nb = selected_macro->nb_noyau;
	fichier = fopen (macrofilename, "w");
	if (fichier == NULL)
	  {
	    g_print (_ ("Can't create the file %s\n"), macrofilename);
	    gtk_widget_hide (savefigure);
	    return FALSE;
	  }
	fwrite (&(selected_macro->version), sizeof (selected_macro->version), 1, fichier);
	a = strlen (selected_macro->nom) + 1;
	if (a > MACRO_NAME_WIDTH)
	  a = MACRO_NAME_WIDTH;
	fwrite (&a, sizeof (a), 1, fichier);
	fwrite (selected_macro->nom, a, 1, fichier);

	a = strlen (selected_macro->info) + 1;
	if (a > MACRO_TEXT_INFO)
	  a = MACRO_TEXT_INFO;
	fwrite (&a, sizeof (a), 1, fichier);
	fwrite (selected_macro->info, a, 1, fichier);
	// info texte sur la macro

	fwrite (&nb, sizeof (nb), 1, fichier);
	// nb de noyau

	fwrite (&(selected_macro->param_i), sizeof (selected_macro->param_i), 1, fichier);
	// nb param i

	fwrite (&(selected_macro->param_f), sizeof (selected_macro->param_f), 1, fichier);
	// nb param f

	selected_macro->init_lire ();
	while (nb-- != 0)
	  {
	    n = selected_macro->lire (0);

	    fwrite (&(n->type), sizeof (n->type), 1, fichier);
	    // type noyau

	    fwrite (&(n->param_f), sizeof (n->param_f), 1, fichier);
	    // flag noyau de figure final

	    fwrite (&(n->signe), sizeof (n->signe), 1, fichier);
	    // signe

	    if (n->liste_parent == NULL)
	      {
		// noyau sans parent, ce sont les param d'entree
		a = 0;
		fwrite (&a, sizeof (a), 1, fichier);
	      }
	    else
	      {
		a = *(n->liste_parent);		// nb de parent

		fwrite (n->liste_parent, 1, (a + 1) * sizeof (int), fichier);
		// sauver la liste de  parent
	      }
	  }
	fclose (fichier);
	gtk_widget_hide (savefigure);
	return TRUE;
      }
    }
  return FALSE;
}

char 
lire_figurefs (GtkWidget * widget, gpointer data)
{
  // the following nit is not usefull now !
  // data = 0 we want to load a GEO file
  // data = 1 we want to load a MAC file
  // data = 2 we want to load the figure as XML file
  char *pt, loaded = FALSE;
  char filetoload[512];
  char c;

  strcpy (filetoload, gtk_file_selection_get_filename (GTK_FILE_SELECTION (loadfigure)));

// if no extension we refuse to load the file
  if ((pt = strrchr (filetoload, '.')) == NULL)
    {
      g_print (_ ("The file %s hasn't a compatible extension\n"), filetoload);
      return FALSE;
    }

  c = (char) data;
  switch (c)
    {
    case 0:
      // we check for acceptable extension
      if (strcasecmp (pt + 1, "geo") == 0)
	loaded = lire_figure (filetoload);
      else
	{
	  g_print (_ ("The file %s hasn't a compatible extension\n"), filetoload);
	  return FALSE;
	}
      if (loaded)
	{
	  // refresh the pixmap
	  tapisser (current_screen);
	  mise_a_jour ();
	  dessine_figure ();
	  swap ();
	  // Display the figure tree
	  // create_tree ();
	}
      break;
    case 1:
      // we check for acceptable extension
      if (strcasecmp (pt + 1, "mac") == 0)
	loaded = lire_figure (filetoload);
      else
	{
	  g_print (_ ("The file %s hasn't a compatible extension\n"), filetoload);
	  return FALSE;
	}
      break;
    }
  // if we are here, we try loading, do we finish ?
  gtk_widget_hide (loadfigure);
  return loaded;
}

char
lire_figure (char *filename)
{
  char *pt;
  int pos, a, nb_total, version;
  FILE *fichier;
  pt = strrchr (filename, '.');
  if (access (filename, R_OK | F_OK) != 0)
    {
      g_print (_ ("The file %s doesn't exist or its access is not allowed\n"), filename);
      return FALSE;
    }
  if ((fichier = fopen (filename, "r")) == NULL)
    {
      g_print (_ ("Can't access the file %s\n"), filename);
      return FALSE;
    }

  if (strcasecmp (pt + 1, "geo") == 0)
    {
      //Est-ce un fichier Geo, est-ce la bonne version ?
      fread (&version, 1, sizeof (version), fichier);
      if (version > GEO_VERSION)
	{
	  g_print (_ ("Not compatible geo file\n"));
	  fclose (fichier);
	  return false;
	}
      effacer_figure ();
      liste_figure.vide ();
      liste_figure_libre.vide ();
      // creation des objets (sans parametre) et creation de la liste liste_figure
      fread (&nb_total, sizeof (nb_total), 1, fichier);
      for (a = 1; a <= nb_total; a++)
	{
	  fread (&pos, sizeof (pos), 1, fichier);
	  switch (pos)
	    {
	    case POINT_PL:
	      liste_figure.ajoute ((void *) new point2 ());
	      break;
	    case POINT_DR:
	      liste_figure.ajoute ((void *) new point_sur_droite ());
	      break;
	    case POINT_DD:
	      liste_figure.ajoute ((void *) new point_sur_demi_droite ());
	      break;
	    case POINT_SE:
	      liste_figure.ajoute ((void *) new point_sur_segment ());
	      break;
	    case POINT_CE:
	      liste_figure.ajoute ((void *) new point_sur_cercle ());
	      break;
	    case POINT_CO:
	      liste_figure.ajoute ((void *) new point1 ());
	      break;
	    case POINT_DR_DR:
	      liste_figure.ajoute ((void *) new point_sur_droite_et_droite ());
	      break;
	    case POINT_DR_DD:
	      liste_figure.ajoute ((void *) new point_sur_droite_et_demi_droite ());
	      break;
	    case POINT_DR_SE:
	      liste_figure.ajoute ((void *) new point_sur_droite_et_segment ());
	      break;
	    case POINT_DR_CE:
	      liste_figure.ajoute ((void *) new point_sur_cercle_et_droite ());
	      break;
	    case POINT_MI_SE:
	      liste_figure.ajoute ((void *) new point_milieu_segment ());
	      break;
	    case POINT_DD_DD:
	      liste_figure.ajoute ((void *) new point_sur_demi_droite_et_demi_droite ());
	      break;
	    case POINT_DD_SE:
	      liste_figure.ajoute ((void *) new point_sur_demi_droite_et_segment ());
	      break;
	    case POINT_DD_CE:
	      liste_figure.ajoute ((void *) new point_sur_cercle_et_demi_droite ());
	      break;
	    case POINT_MI_2PT:
	      liste_figure.ajoute ((void *) new point_milieu_2points ());
	      break;
	    case POINT_SE_SE:
	      liste_figure.ajoute ((void *) new point_sur_segment_et_segment ());
	      break;
	    case POINT_SE_CE:
	      liste_figure.ajoute ((void *) new point_sur_cercle_et_segment ());
	      break;
	    case POINT_CE_CE:
	      liste_figure.ajoute ((void *) new point_sur_cercle_et_cercle ());
	      break;
	    case POINT_TR:
	      liste_figure.ajoute ((void *) new translation_point ());
	      break;
	    case POINT_SY:
	      liste_figure.ajoute ((void *) new symetrie_point ());
	      break;
	    case POINT_RE:
	      liste_figure.ajoute ((void *) new reflexion_point ());
	      break;
	    case POINT_AR:
	      liste_figure.ajoute ((void *) new point_sur_arc_cercle ());
	      break;
	    case POINT_DR_AR:
	      liste_figure.ajoute ((void *) new point_sur_arc_cercle_et_droite ());
	      break;
	    case POINT_DD_AR:
	      liste_figure.ajoute ((void *) new point_sur_arc_cercle_et_demi_droite ());
	      break;
	    case POINT_SE_AR:
	      liste_figure.ajoute ((void *) new point_sur_arc_cercle_et_segment ());
	      break;
	    case POINT_CE_AR:
	      liste_figure.ajoute ((void *) new point_sur_arc_cercle_et_cercle ());
	      break;
	    case POINT_AR_AR:
	      liste_figure.ajoute ((void *) new point_sur_arc_cercle_et_arc_cercle ());
	      break;
	    case DR_2PT:
	      liste_figure.ajoute ((void *) new droite1 ());
	      break;
	    case DD_2PT:
	      liste_figure.ajoute ((void *) new demi_droite1 ());
	      break;
	    case SE_2PT:
	      liste_figure.ajoute ((void *) new segment1 ());
	      break;
	    case VE_2PT:
	      liste_figure.ajoute ((void *) new vecteur1 ());
	      break;
	    case CE_2PT:
	      liste_figure.ajoute ((void *) new cercle1 ());
	      break;
	    case CE_SE:
	      liste_figure.ajoute ((void *) new cercle2 ());
	      break;
	    case CE_VA:
	      liste_figure.ajoute ((void *) new cercle3 ());
	      break;
	    case AC_3PT:
	      liste_figure.ajoute ((void *) new arc_cercle1 ());
	      break;
	    case DR_PA_DR:
	      liste_figure.ajoute ((void *) new droite_parallele1 ());
	      break;
	    case DR_PA_2PT:
	      liste_figure.ajoute ((void *) new droite_parallele2 ());
	      break;
	    case DR_OR_DR:
	      liste_figure.ajoute ((void *) new droite_orthogonale1 ());
	      break;
	    case DR_OR_2PT:
	      liste_figure.ajoute ((void *) new droite_orthogonale2 ());
	      break;
	    case DR_TR:
	      liste_figure.ajoute ((void *) new translation_droite ());
	      break;
	    case DR_SY:
	      liste_figure.ajoute ((void *) new symetrie_droite ());
	      break;
	    case DR_RE:
	      liste_figure.ajoute ((void *) new reflexion_droite ());
	      break;
	    case DD_TR:
	      liste_figure.ajoute ((void *) new translation_demi_droite ());
	      break;
	    case DD_SY:
	      liste_figure.ajoute ((void *) new symetrie_demi_droite ());
	      break;
	    case DD_RE:
	      liste_figure.ajoute ((void *) new reflexion_demi_droite ());
	      break;
	    case SE_TR:
	      liste_figure.ajoute ((void *) new translation_segment ());
	      break;
	    case SE_SY:
	      liste_figure.ajoute ((void *) new symetrie_segment ());
	      break;
	    case SE_RE:
	      liste_figure.ajoute ((void *) new reflexion_segment ());
	      break;
	    case CE_TR:
	      liste_figure.ajoute ((void *) new translation_cercle ());
	      break;
	    case CE_SY:
	      liste_figure.ajoute ((void *) new symetrie_cercle ());
	      break;
	    case CE_RE:
	      liste_figure.ajoute ((void *) new reflexion_cercle ());
	      break;
	    case AR_RE:
	      liste_figure.ajoute ((void *) new reflexion_arc_cercle ());
	      break;
	    case AR_SY:
	      liste_figure.ajoute ((void *) new symetrie_arc_cercle ());
	      break;
	    case AR_TR:
	      liste_figure.ajoute ((void *) new translation_arc_cercle ());
	      break;
	    case AR_RO:
	      liste_figure.ajoute ((void *) new rotation_arc_cercle ());
	      break;
	    case VE_TR:
	      liste_figure.ajoute ((void *) new translation_vecteur ());
	      break;
	    case VE_RE:
	      liste_figure.ajoute ((void *) new reflexion_vecteur ());
	      break;
	    case VA_LO_SE:
	      liste_figure.ajoute ((void *) new longueur_segment ());
	      break;
	    case VA_NO_VE:
	      liste_figure.ajoute ((void *) new norme_vecteur ());
	      break;
	    case VA_DI_PT_PT:
	      liste_figure.ajoute ((void *) new distance_pt_pt ());
	      break;
	    case VA_DI_PT_CE:
	      liste_figure.ajoute ((void *) new distance_point_cercle ());
	      break;
	    case VA_DI_PT_DR:
	      liste_figure.ajoute ((void *) new distance_point_droite ());
	      break;
	    case VA_PE_CE:
	      liste_figure.ajoute ((void *) new perimetre_cercle ());
	      break;
	    case VA_AN_3PT:
	      liste_figure.ajoute ((void *) new angle_3points ());
	      break;
	    case VA_AN_2VE:
	      liste_figure.ajoute ((void *) new angle_2vecteurs ());
	      break;
	    case VA_AB_PT:
	      liste_figure.ajoute ((void *) new abscisse_point ());
	      break;
	    case VA_OR_PT:
	      liste_figure.ajoute ((void *) new ordonnee_point ());
	      break;
	    case VA_AB_VE:
	      liste_figure.ajoute ((void *) new abscisse_vecteur ());
	      break;
	    case VA_OR_VE:
	      liste_figure.ajoute ((void *) new ordonnee_vecteur ());
	      break;
	    case VA_LI:
	      liste_figure.ajoute ((void *) new valeur_libre ());
	      break;
	    case VA_PE_DR:
	      liste_figure.ajoute ((void *) new pente_droite ());
	      break;
	    case EQ_DR:
	      liste_figure.ajoute ((void *) new equation_droite ());
	      break;
	    case EQ_CE:
	      liste_figure.ajoute ((void *) new equation_cercle ());
	      break;
	    case POINT_RO:
	      liste_figure.ajoute ((void *) new rotation_point ());
	      break;
	    case DR_RO:
	      liste_figure.ajoute ((void *) new rotation_droite ());
	      break;
	    case DD_RO:
	      liste_figure.ajoute ((void *) new rotation_demi_droite ());
	      break;
	    case SE_RO:
	      liste_figure.ajoute ((void *) new rotation_segment ());
	      break;
	    case VE_RO:
	      liste_figure.ajoute ((void *) new rotation_vecteur ());
	      break;
	    case CE_RO:
	      liste_figure.ajoute ((void *) new rotation_cercle ());
	      break;
	    case POINT_HO:
	      liste_figure.ajoute ((void *) new homothetie_point ());
	      break;
	    case DR_HO:
	      liste_figure.ajoute ((void *) new homothetie_droite ());
	      break;
	    case DD_HO:
	      liste_figure.ajoute ((void *) new homothetie_demi_droite ());
	      break;
	    case SE_HO:
	      liste_figure.ajoute ((void *) new homothetie_segment ());
	      break;
	    case VE_HO:
	      liste_figure.ajoute ((void *) new homothetie_vecteur ());
	      break;
	    case CE_HO:
	      liste_figure.ajoute ((void *) new homothetie_cercle ());
	      break;
	    case AR_HO:
	      liste_figure.ajoute ((void *) new homothetie_arc_cercle ());
	      break;
	    case LI_PT_DR:
	      liste_figure.ajoute ((void *) new lieu_point_mobile_sur_droite ());
	      break;
	    case LI_PT_DD:
	      liste_figure.ajoute ((void *) new lieu_point_mobile_sur_demi_droite ());
	      break;
	    case LI_PT_SE:
	      liste_figure.ajoute ((void *) new lieu_point_mobile_sur_segment ());
	      break;
	    case LI_PT_CE:
	      liste_figure.ajoute ((void *) new lieu_point_mobile_sur_cercle ());
	      break;
	    case POINT_LI:
	      liste_figure.ajoute ((void *) new point_sur_lieu ());
	      break;
	    }
	}
      // creation de la liste_figure_libre
      // nombre d'objets libre
      fread (&nb_total, sizeof (nb_total), 1, fichier);
      for (a = 1; a <= nb_total; a++)
	{
	  // position dans liste_figure de cet objet libre
	  fread (&pos, sizeof (pos), 1, fichier);
	  liste_figure_libre.ajoute (liste_figure.lire (pos));
	}
      // mise a jour des parametres des objets geometriques
      nb_total = liste_figure.nb_elem;
      liste_figure.init_lire ();
      for (a = 1; a <= nb_total; a++)
	{
	  figure_c *fig;
	  fig = (figure_c *) liste_figure.lire (0);
	  fig->lire_disk (fichier);	// lit les parametre de l'objet

	  fig->init_nom ();	// initialise le nom de l'objet

	}
      fclose (fichier);
      return TRUE;
    }
  else if (strcasecmp (pt + 1, "mac") == 0)
    {
      macro *mac;
      char info_mac[MACRO_TEXT_INFO], name[MACRO_NAME_WIDTH], *ptn, *pt[1];
      int *par, i, f, nb;

      // on cree la nouvelle macro version
      fread (&version, 1, sizeof (version), fichier);
      if (version > MAC_VERSION)
	{
	  g_print (_ ("Not compatible mac file\n"));
	  fclose (fichier);
	  return false;
	}

      fread (&nb, 1, sizeof (nb), fichier);	// name size

      if (nb > MACRO_NAME_WIDTH)
	{
	  g_print (_ ("Macro name too big\n"));
	  return FALSE;
	}
      fread ((void *) name, 1, nb, fichier);
      name[nb] = 0;

      fread (&nb, 1, sizeof (nb), fichier);	// info buffer size

      if (nb > MACRO_TEXT_INFO)
	{
	  g_print (_ ("Macro info buffer too big\n"));
	  return FALSE;
	}
      fread ((void *) info_mac, 1, nb, fichier);
      info_mac[nb] = 0;

      fread (&nb_total, 1, sizeof (nb_total), fichier);
      // nb de noyau

      fread (&i, 1, sizeof (i), fichier);
      fread (&f, 1, sizeof (f), fichier);
      mac = new macro (i, f, name);
      strcpy ((char *) mac->nom, (char *) name);
      strcpy ((char *) mac->info, (char *) info_mac);
      g_print ("%s\n", mac->nom);
      while (nb_total-- != 0)
	{
	  int type, flag, signe, nb_parent;
	  fread (&type, 1, sizeof (type), fichier);
	  // type noyau

	  fread (&flag, 1, sizeof (flag), fichier);
	  // flag noyau de figure final

	  fread (&signe, 1, sizeof (signe), fichier);
	  // signe (info supplementaire)

	  fread (&nb_parent, 1, sizeof (nb_parent), fichier);
	  // nb parent pour ce noyau

	  if (nb_parent == 0)	// pas de parent

	    par = NULL;
	  else
	    {
	      par = new int[nb_parent + 1];	// prepare la liste...

	      par[0] = nb_parent;	// ... des parents de ce noyau. nb parent

	      fread (par + 1, 1, nb_parent * sizeof (int), fichier);
	      // sauver la liste de parent
	    }
	  mac->ajoute (par, type, NULL, flag, signe);
	}
      fclose (fichier);
      liste_macro.ajoute ((void *) mac);
      // we also add to the GtkCList widget
      pt[0] = ((macro *) (liste_macro.lire (liste_macro.nb_elem)))->nom;
      g_print ("Nom de la macro : %s\n", pt[0]);
      gtk_clist_append (GTK_CLIST (macrolist), pt);

      return TRUE;
    }
  return FALSE;
}
void
effacer_figure ()
{
  int nb;
  nb = liste_figure.nb_elem;
  liste_figure.init_lire ();
  while (nb != 0)
    {
      delete ((figure_c *) liste_figure.lire (0));
      nb--;
    }
}
// Construction de la macro et des noyaux de macro
// Retourne la position du noyau de l'objet fig dans la macro
int
position_noyau (macro & M, figure_c * fig, liste_elem & l_f)
{
  liste_elem parent, *ret;
  int *noyau_parent, nb;
  nb = M.position ((void *) fig);

  // cette objet n'est pas dans la macro
  if (nb == 0)
    {
      if ((ret = fig->parents (&parent)) == NULL)
	return -1;		// erreur dans macro

      else
	{
	  nb = parent.nb_elem;
	  noyau_parent = new int[nb + 1];
	  noyau_parent[0] = nb;
	  parent.init_lire ();
	  {
	    int a, b;
	    for (a = 1; a <= nb; a++)
	      {
		b = position_noyau (M, (figure_c *) parent.lire (0), l_f);
		if (b == -1)
		  {
		    delete[]noyau_parent;
		    return b;
		  }
		else
		  noyau_parent[a] = b;
	      }
	  }
	  return M.ajoute (noyau_parent, fig->classe, (void *) fig, l_f.position (fig) ? TRUE : FALSE, fig->signe);
	}
    }
  return nb;
}
// Verification de la validite de la macro
char
verifie_validite_macro (liste_elem & l_i, liste_elem & l_f)
{
  liste_elem liste = l_f, parent, *ret, l2;
  figure_c *objet;
  int nb;
  char possible = TRUE;
  while (!(contenue (liste, l_i)) && possible)
    {
      liste.init_lire ();
      nb = liste.nb_elem;
      while (nb != 0)
	{
	  nb--;
	  objet = (figure_c *) liste.lire (0);
	  ret = objet->parents (&parent);
	  liste.supprime ((void *) objet);
	  if (((ret == NULL) && (l_i.position ((void *) objet) == 0)) || (objet->type == FIG_LIEU_PT))
	    possible = FALSE;
	  // sans parents (ie objet libre ou semi-libre (point libre sur
	  // droite,etc) ou indetermine (ie intersection cercle-droite,etc.)
	  else
	    {
	      if (l_i.position ((void *) objet) == 0)
		concatene (l2, parent);		// inserer les parents dans
	      // l2 car ce n'est pas un
	      // param initial

	      else if (l2.position ((void *) objet) == 0)
		l2.ajoute ((void *) objet);	// objet sans parent et il
	      // est un parametre initial

	    }
	}
      concatene (liste, l2);
      l2.vide ();
    }
  return possible;
}
// Execute la macro M avec comme parametre d'entree la liste l_e
void
play_macro (macro & M, liste_elem & l_e)
{
  int a, nb;
  noyau_macro *n;
  liste_elem l_p;
  nb = l_e.nb_elem;
  M.init_lire ();
  l_e.init_lire ();
  while (nb-- != 0)
    M.lire (0)->fig = l_e.lire (0);	// copie l'@ des parametres d'entree

  nb = M.nb_noyau - M.param_i;	// nb d'objets intermediaires+finaux a creer

  while (nb-- != 0)
    {
      n = M.lire (0);
      if (!n->param_f)
	objet_issue_macro_construction = TRUE;
      else
	objet_issue_macro_construction = FALSE;
      n->fig = (void *) creer_objet (trouve_parent (n->liste_parent, M, l_p), n);
    }
  nb = M.nb_noyau;
  objet_issue_macro_construction = FALSE;
  for (a = M.param_i + 1; a <= nb; a++)
    {
      liste_figure.ajoute (M.lire (a)->fig);
      if (((figure_c *) M.lire (a)->fig)->libre == TRUE && ((figure_c *) M.lire (a)->fig)->masque != OBJET_MACRO)
	liste_figure_libre.ajoute (M.lire (a)->fig);
      // si c'est un objet de type libre et final de la macro (c-a-d visible)
    }
}

liste_elem & trouve_parent (int *l, macro & M, liste_elem & l_p)
{
  int nb, a;
  nb = l[0];
  l_p.vide ();
  for (a = 1; a <= nb; a++)
    l_p.ajoute (M.lire (l[a])->fig);
  return l_p;
}

figure_c *
creer_objet (liste_elem & l_p, noyau_macro * n)
{
  figure_c *fig;
  switch (n->type)
    {
    case POINT_CO:
      return new point1 (l_p);
    case POINT_DR_DR:
      return new point_sur_droite_et_droite (l_p);
    case POINT_DR_DD:
      return new point_sur_droite_et_demi_droite (l_p);
    case POINT_DR_SE:
      return new point_sur_droite_et_segment (l_p);
    case POINT_DR_CE:
      return new point_sur_cercle_et_droite (l_p, n->signe);
    case POINT_DD_CE:
      return new point_sur_cercle_et_demi_droite (l_p, n->signe);
    case POINT_SE_CE:
      return new point_sur_cercle_et_segment (l_p, n->signe);
    case POINT_CE_CE:
      return new point_sur_cercle_et_cercle (l_p, n->signe);
    case POINT_DR_AR:
      return new point_sur_arc_cercle_et_droite (l_p, n->signe);
    case POINT_DD_AR:
      return new point_sur_arc_cercle_et_demi_droite (l_p, n->signe);
    case POINT_SE_AR:
      return new point_sur_arc_cercle_et_segment (l_p, n->signe);
    case POINT_CE_AR:
      return new point_sur_arc_cercle_et_cercle (l_p, n->signe);
    case POINT_AR_AR:
      return new point_sur_arc_cercle_et_arc_cercle (l_p, n->signe);
    case POINT_MI_SE:
      return new point_milieu_segment (l_p);
    case POINT_DD_DD:
      return new point_sur_demi_droite_et_demi_droite (l_p);
    case POINT_DD_SE:
      return new point_sur_demi_droite_et_segment (l_p);
    case POINT_MI_2PT:
      return new point_milieu_2points (l_p);
    case POINT_SE_SE:
      return new point_sur_segment_et_segment (l_p);
    case POINT_TR:
      return new translation_point (l_p);
    case POINT_SY:
      return new symetrie_point (l_p);
    case POINT_RE:
      return new reflexion_point (l_p);
    case DR_2PT:
      return new droite1 (l_p);
    case DD_2PT:
      return new demi_droite1 (l_p);
    case SE_2PT:
      return new segment1 (l_p);
    case VE_2PT:
      return new vecteur1 (l_p);
    case CE_2PT:
      return new cercle1 (l_p);
    case CE_SE:
      return new cercle2 (l_p);
    case CE_VA:
      return new cercle3 (l_p);
    case AC_3PT:
      return new arc_cercle1 (l_p);
    case DR_PA_DR:
      return new droite_parallele1 (l_p);
    case DR_PA_2PT:
      return new droite_parallele2 (l_p);
    case DR_OR_DR:
      return new droite_orthogonale1 (l_p);
    case DR_OR_2PT:
      return new droite_orthogonale2 (l_p);
    case DR_TR:
      return new translation_droite (l_p);
    case DR_SY:
      return new symetrie_droite (l_p);
    case DR_RE:
      return new reflexion_droite (l_p);
    case DD_TR:
      return new translation_demi_droite (l_p);
    case DD_SY:
      return new symetrie_demi_droite (l_p);
    case DD_RE:
      return new reflexion_demi_droite (l_p);
    case SE_TR:
      return new translation_segment (l_p);
    case SE_SY:
      return new symetrie_segment (l_p);
    case SE_RE:
      return new reflexion_segment (l_p);
    case CE_TR:
      return new translation_cercle (l_p);
    case CE_SY:
      return new symetrie_cercle (l_p);
    case CE_RE:
      return new reflexion_cercle (l_p);
    case AR_RE:
      return new reflexion_arc_cercle (l_p);
    case AR_SY:
      return new symetrie_arc_cercle (l_p);
    case AR_TR:
      return new translation_arc_cercle (l_p);
    case AR_RO:
      return new rotation_arc_cercle (l_p);
    case VE_TR:
      return new translation_vecteur (l_p);
    case VE_RE:
      return new reflexion_vecteur (l_p);
    case VA_LO_SE:
      fig = new longueur_segment (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_NO_VE:
      fig = new norme_vecteur (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_DI_PT_PT:
      fig = new distance_pt_pt (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_DI_PT_CE:
      fig = new distance_point_cercle (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_DI_PT_DR:
      fig = new distance_point_droite (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_PE_CE:
      fig = new perimetre_cercle (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_AN_3PT:
      fig = new angle_3points (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_AN_2VE:
      fig = new angle_2vecteurs (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_AB_PT:
      fig = new abscisse_point (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_OR_PT:
      fig = new ordonnee_point (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_AB_VE:
      fig = new abscisse_vecteur (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_OR_VE:
      fig = new ordonnee_vecteur (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_LI:
      fig = new valeur_libre (l_p);
      fig->libre = TRUE;
      return fig;
    case VA_PE_DR:
      fig = new pente_droite (l_p);
      fig->libre = TRUE;
      return fig;
    case EQ_DR:
      fig = new equation_droite (l_p);
      fig->libre = TRUE;
      return fig;
    case EQ_CE:
      fig = new equation_cercle (l_p);
      fig->libre = TRUE;
      return fig;
    case POINT_RO:
      return new rotation_point (l_p);
    case DR_RO:
      return new rotation_droite (l_p);
    case DD_RO:
      return new rotation_demi_droite (l_p);
    case SE_RO:
      return new rotation_segment (l_p);
    case VE_RO:
      return new rotation_vecteur (l_p);
    case CE_RO:
      return new rotation_cercle (l_p);
    case POINT_HO:
      return new homothetie_point (l_p);
    case DR_HO:
      return new homothetie_droite (l_p);
    case DD_HO:
      return new homothetie_demi_droite (l_p);
    case SE_HO:
      return new homothetie_segment (l_p);
    case VE_HO:
      return new homothetie_vecteur (l_p);
    case CE_HO:
      return new homothetie_cercle (l_p);
    case AR_HO:
      return new homothetie_arc_cercle (l_p);
    }
  return NULL;
}
void
afficher_repere (void)
{
}
/*
   int c, oh, ow, e;
   oh = (int) ORIGIN_H;
   ow = (int) ORIGIN_W;
   e = (int) ECHELLE;
   if (affiche_repere)
   {
   line (current_screen, 0, oh, SCREEN_W, oh, tab_couleur[NOIR]);
   line (current_screen, ow, 0, ow, SCREEN_H, tab_couleur[NOIR]);
   for (c = ow + e; c < SCREEN_W; c += e)
   line (current_screen, c, oh - 1, c, oh + 1, tab_couleur[NOIR]);
   for (c = ow - e; c >= 0; c -= e)
   line (current_screen, c, oh - 1, c, oh + 1, tab_couleur[NOIR]);
   for (c = oh + e; c < SCREEN_H; c += e)
   line (current_screen, ow - 1, c, ow + 1, c, tab_couleur[NOIR]);
   for (c = oh - e; c >= 0; c -= e)
   line (current_screen, ow - 1, c, ow + 1, c, tab_couleur[NOIR]);
   }
   }
 */

void
scan_touche_fonction (void)
{
}
/*
   char touche_fonction_pressee = FALSE;
   // scan  si une touche function a t presse et entrprend l'action correspondante.
   if (key[KEY_F1])
   {
   touche_fonction_pressee = TRUE;
   affiche_repere = !affiche_repere;
   while (key[KEY_F1]);
   }
   if (key[KEY_PLUS_PAD])
   {
   touche_fonction_pressee = TRUE;
   ECHELLE += 1;
   if (ECHELLE > 100)
   ECHELLE = 100;
   MON_L = MONx (0);
   MON_R = MONx (SCREEN_W);
   MON_T = MONy (0);
   MON_B = MONy (SCREEN_H);
   }
   if (key[KEY_MINUS_PAD])
   {
   touche_fonction_pressee = TRUE;
   ECHELLE -= 1;
   if (ECHELLE <= 0)
   ECHELLE = 1;
   MON_L = MONx (0);
   MON_R = MONx (SCREEN_W);
   MON_T = MONy (0);
   MON_B = MONy (SCREEN_H);
   }
   if (key[KEY_RIGHT])
   {
   touche_fonction_pressee = TRUE;
   ORIGIN_W += 1;
   if (ORIGIN_W > SCREEN_H / 2 + 400)
   ORIGIN_W = SCREEN_H / 2 + 400;
   MON_L = MONx (0);
   MON_R = MONx (SCREEN_W);
   MON_T = MONy (0);
   MON_B = MONy (SCREEN_H);
   }
   if (key[KEY_LEFT])
   {
   touche_fonction_pressee = TRUE;
   ORIGIN_W -= 1;
   if (ORIGIN_W < SCREEN_H / 2 - 400)
   ORIGIN_W = SCREEN_W / 2 - 400;
   MON_L = MONx (0);
   MON_R = MONx (SCREEN_W);
   MON_T = MONy (0);
   MON_B = MONy (SCREEN_H);
   }
   if (key[KEY_DOWN])
   {
   touche_fonction_pressee = TRUE;
   ORIGIN_H += 1;
   if (ORIGIN_H > SCREEN_H / 2 + 400)
   ORIGIN_H = SCREEN_H / 2 + 400;
   MON_L = MONx (0);
   MON_R = MONx (SCREEN_W);
   MON_T = MONy (0);
   MON_B = MONy (SCREEN_H);
   }
   if (key[KEY_UP])
   {
   touche_fonction_pressee = TRUE;
   ORIGIN_H -= 1;
   if (ORIGIN_H < SCREEN_H / 2 - 400)
   ORIGIN_H = SCREEN_H / 2 - 400;
   MON_L = MONx (0);
   MON_R = MONx (SCREEN_W);
   MON_T = MONy (0);
   MON_B = MONy (SCREEN_H);
   }

   if (touche_fonction_pressee)
   {
   // redessine la figure afin de tenir compte des modification dans les
   // paramtres
   current_screen = ecran1;
   show_mouse (NULL);
   tapisser (current_screen);
   dessine_figure ();
   blit (current_screen, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
   show_mouse (screen);
   // vsync();
   current_screen = screen;
   }
   }
 */

/* 
   this function insert the message 'msg' at the insertion point mark
   in the string 'dest'
 */
char *
strinsmsg (char *dest, char *msg, char *mark)
{
  char *ins;
  // find the mark in dest
  if ((ins = strstr (dest, mark)) == NULL)
    return dest;
  // remove the mark, don't forget the 0 end string mark
  memmove (ins, ins + strlen (mark), strlen (ins) + 1);
  // we can insert the message msg
  strins (ins, msg);
  return dest;
}

char *
strins (char *dest, char *chaine)
{
  // insert chaine into dest and cratch the fist character in dest
  char *buffer;
  int lon;
  lon = strlen (dest);
  if (lon == 0)
    strcpy (dest, chaine);
  else
    {
      if ((buffer = (char *) malloc (sizeof (char) * (lon + 1))) == NULL)
	{
	  return NULL;
	}
      strcpy (buffer, dest);
      strcpy (dest, chaine);
      strcpy (dest + strlen (chaine), buffer);
      free (buffer);
    }
  return dest;
}
