/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * lor_cntrl_def.c
 */

#include <stdlib.h>

#include "model_headers.h"


/*
	x' = sigma*(y-x)
	y' = rho*x-y-x*z
	z' = -beta*z+x*y
	X' = sigma*(Y-X)+eps*noise
	Y' = rho*u-Y-u*Z+eps*noise
	Z' = -beta*Z+u*Y+eps*noise
	dx = X-x
	dy = Y-y
	dz = Z-z

   where
	u = switch*x+(1-switch)*A*cos(omega*t)+B
	noise = random number between -1 and 1


	Translation table:

		x[0] <--> x
		x[1] <--> y
		x[2] <--> z
		x[3] <--> X
		x[4] <--> Y
		x[5] <--> Z
		p[0] <--> sigma
		p[1] <--> rho
		p[2] <--> beta
		p[3] <--> eps
		p[4] <--> omega
		p[5] <--> A
		p[6] <--> switch
		p[7] <--> B
		TEMP[0] <--> u
		TEMP[1,2,3] <--> noise
*/

/* function used to define dynamical system */
int lor_control_ds_func( double* f,double* x, double* p)
{

	double TEMP[4];
	TEMP[0] = p[6]*x[0]+(1-p[6])*p[5]*cos(p[4]*x[6])+p[7];
	TEMP[1] = 2*drand48()-1.0;
	TEMP[2] = 2*drand48()-1.0;
	TEMP[3] = 2*drand48()-1.0;
	f[0] = p[0]*(x[1]-x[0]);
	f[1] = p[1]*x[0]-x[1]-x[0]*x[2];
	f[2] = -p[2]*x[2]+x[0]*x[1];
	f[3] = p[0]*(x[4]-x[3])+p[3]*TEMP[1];
	f[4] = p[1]*TEMP[0]-x[4]-TEMP[0]*x[5]+p[3]*TEMP[2];
	f[5] = -p[2]*x[5]+TEMP[0]*x[4]+p[3]*TEMP[3];
	f[6] = 1;

	return 0;
}

/* function used to define aux functions */
int lor_control_aux_func( double* f,double* x, double* p)
{
	f[0] = x[3]-x[0];
	f[1] = x[4]-x[1];
	f[2] = x[5]-x[2];

	return 0;
}

/* function used to define jacobian. NOT AUTOMATICALLY GENERATED.
	input explicit jacobian in the  form
	m[i][j] = d f_i / d x_j; (starting with 0)
*/
/*
int 
lor_control_jac( double **m, double* x, double* p)
{

	return 0;
}
*/

/* function used to define default data */
int 
lor_control_init(void)
{
	int n_varb=6;
	static char *variable_names[]={"x","y","z","X","Y","Z"};
	static double variables[]={0,0,0,0,0,0,0};
	static double variable_min[]={-30,-30,-20,-30,-30,-20};
	static double variable_max[]={30,30,50,30,30,50};

	static char *indep_varb_name="time";
	double indep_varb_min=0;
	double indep_varb_max=100;

	int n_param=8;
	static char *parameter_names[]={"sigma","rho","beta","eps","omega","A","switch","B"};
	static double parameters[]={10,28,2.66667,0.1,1,20,0,0};
	static double parameter_min[]={-10,-10,-10,-10,-10,-10,-10,-1};
	static double parameter_max[]={10,10,10,10,10,10,10,1};

	int n_funct=3;
	static char *funct_names[]={"dx","dy","dz"};
	static double funct_min[]={-10,-10,-10};
	static double funct_max[]={10,10,10};

	int manifold_type=EUCLIDEAN;
	static int periodic_varb[]={FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE};
	static double period_start[]={0,0,0,0,0,0,0};
	static double period_end[]={1,0,0,0,0,0,0};

	int mapping_toggle=FALSE;
	int inverse_toggle=FALSE;

	int (*def_name)()=lor_control_ds_func;
	int (*jac_name)()=NULL;
	int (*aux_func_name)()=lor_control_aux_func;
	int (*inv_name)()=NULL;
	int (*dfdt_name)()=NULL;
	int (*dfdparam_name)()=NULL;

#include <ds_define.c>

        return 0;
}

