static char rcsid[] = "$Id: shapematch.c,v 1.4 1997/07/18 03:02:36 dhb Exp $";

/*
** $Log: shapematch.c,v $
** Revision 1.4  1997/07/18 03:02:36  dhb
** Fix for getopt problem; getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.3  1994/08/08 22:15:20  dhb
** Changes from Upi.
**
** Revision 1.3  1994/06/13  22:40:14  bhalla
** Replaced the missing options for using either a table or a file
**
 * Revision 1.2  1994/06/06  15:59:26  bhalla
 * Changed to use load_file_or_table rather than fopen
 *
 * Revision 1.1  1994/05/31  19:24:05  bhalla
 * Initial revision
 *
** Revision 1.2  1993/02/24  21:15:47  dhb
** 1.4 to 2.0 command argument changes.
**
** Revision 1.1  1992/12/11  19:06:09  dhb
** Initial revision
**
*/

/*
** A brutally hacked piece of code to try to get a decent shapematch
** for the bulb model in the short time I have..
*/
#include <stdio.h>
#include <math.h>
#include "sim_ext.h"
#include "olf_struct.h"

int find_spike();
float do_shapematch();
float	est_max();
float	est_min();
float	do_stats();
void	altspline();
float ShapeStats();


#define MAXPTS 5000
#define MAXSPKS 500
#define MIN_SHAPE_SAMPLES 8

#define SN 0
#define SX 1
#define SY 2
#define SL 3
#define SL2 4
#define SH 5
#define SH2 6
#define SP 7
#define SP2 8
#define SS 9
#define ST 10
#define SW 11
#define NPARMS 12

#define SNSIMSPK 14
#define SNREFSPK 15

#define NSUM 16

#define SDT 0.001	/* 1.00 msec */

static float default_wt[]={
	0.1,	/* SN number */
	10.0,	/* SX time scaling charging curves */
	10.0,	/* SY amplitude scaling charging curves */
	1.0,	/* SL low pt on spikes */
	0.0,	/* SL2 low pt on spikes, only if below ref */
	1.0,	/* SH pk of spks */
	0.0,	/* SH2 pk of spks, only if below ref */
	1.0,	/* SP PTP of spks */
	0.0,	/* SP2 PTP of spks only if below ref */
	10.0,	/* SS Spike Shape -- very important parm */
	10.0,	/* ST Timing of individual spikes */
	1.0,	/* SW Width of individual spikes */
};

#ifdef STANDALONE
main(argc,argv)
	int		argc;
	char	**argv;
{
	printf("%f\n",do_shapematch(argc,argv));
}
#endif

typedef struct spikeinfo_type {
	int lo,hi;
	float tlo,thi;
} Spikeinfo;


float do_shapematch(argc,argv)
	int		argc;
	char	**argv;
{
	FILE	*simfile,*reffile,*fopen();
	float match;
	int i,j;
	float *sim,*simt,*ref,*reft;
	int 	nsim,nref;
	int		plot_flag=0,verbose_flag=0;
	float	Atof();
	float	*sum,*sumsq;
	struct table_type *wtelm,*resultelm;
	float	*wt;
	float	startt;
	int	status;

	wt = (float *)calloc(NSUM,sizeof(float));
	for(i=0;i<NPARMS;i++) wt[i]=default_wt[i];
	wtelm=NULL;
	resultelm=NULL;

	initopt(argc, argv, "ref-file-or-table sim-file-or-table start-time -weight table-element -result table-element -n nspike-wt -x scalex-wt -y scaley-wt -low lo-wt -high hi-wt -toolow too-lo-wt -toohigh too-hi-wt -ptp ptp-wt -toosmallptp too-small-ptp-wt -shape shape-wt -time time-wt -width width-wt -display -verbose");
	while ((status = G_getopt(argc, argv)) == 1)
	  {
	    if (strcmp(G_optopt, "-weight") == 0)
	      {
		wtelm=(struct table_type *)GetElement(optargv[1]);
		if (!wtelm ||
			strcmp(wtelm->object->name,"table")!=0) {
			printf("Error : could not find table elm %s\n",
				optargv[1]);
			return(100);
		}
		if (wtelm->alloced && wtelm->table->xdivs>=NPARMS)
				for(j=0;j<NPARMS;j++)
					wt[j]=wtelm->table->table[j];
		else
			printf("Warning : table %s too small. Using default wts\n",optargv[1]);
	      }
	    else if (strcmp(G_optopt, "-result") == 0)
	      {
		resultelm=(struct table_type *)GetElement(optargv[1]);
		if (!resultelm ||
			strcmp(resultelm->object->name,"table")!=0) {
			printf("Error : could not find table elm %s\n",
				optargv[1]);
			return(100);
		}
	      }
	    else if (strcmp(G_optopt, "-display") == 0)
		plot_flag=1;
	    else if (strcmp(G_optopt, "-verbose") == 0)
		verbose_flag=1;
	    else if (strcmp(G_optopt, "-x") == 0)
		wt[SX]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-y") == 0)
		wt[SY]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-low") == 0)
		wt[SL]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-toolow") == 0)
		wt[SL2]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-high") == 0)
		wt[SH2]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-ptp") == 0)
		wt[SP]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-toosmallptp") == 0)
		wt[SP2]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-shape") == 0)
		wt[SS]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-time") == 0)
		wt[ST]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-width") == 0)
		wt[SW]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-nspike") == 0)
		wt[SN]=Atof(optargv[1]);
	  }

	if (status < 0) {
		printoptusage(argc, argv);
		free(wt);
		return(0);
	}

	if ((startt=Atof(optargv[3]))<0.0) {
		printf("Error : startt = %s is too small\n",optargv[3]);
		free(wt);
		return(0);
	}

    if ((nref = (load_file_or_table(optargv[1],&reft, &ref))) < 1) {
        free(wt);
        return(0);
    }
    if ((nsim = (load_file_or_table(optargv[2],&simt, &sim))) < 1) {
        free(ref);
        free(reft);
        free(wt);
        return(0);
    }

	sum = (float *)calloc(NSUM,sizeof(float));
	sumsq = (float *)calloc(NSUM,sizeof(float));

	for(i=0;reft[i]<startt;i++);
	for(j=0;simt[j]<startt;j++);
	ShapeMatch(ref+i,reft+i,nref-i,sim+j,simt+j,nsim-j,
		1,0.0,0.0,0.03,0.03,sum,sumsq,plot_flag,startt);

	match=sumsq[SS];

	free(wt);
	free(sim);
	free(simt);
	free(ref);
	free(reft);
	free(sum);
	free(sumsq);

	return(match);
}

ShapeMatch(ref,reft,nref,sim,simt,nsim,
	autoest,user_maxest, user_minest, maxwindow,minwindow,
	sum,sumsq,plot_flag,startt)
	float	*ref;
	float	*reft;
	int		nref;
	float	*sim;
	float	*simt;
	int		nsim;
	int		autoest;
	float	user_maxest,user_minest,maxwindow,minwindow;
	float	*sum,*sumsq;
	int		plot_flag;
	float	startt;
{
	int		i,j,k,m;
	int		nrefspk,nsimspk,nminspk;
	Spikeinfo	*refspk,*simspk;
	float	thresh;
	float	maxest,minest;
	float	t,st;
	float	ry,sy;
	float	scalet;
	float	dt=SDT;
	FILE	*rout,*sout,*fopen();

	if (plot_flag) {
		rout=fopen("rout","w");
		sout=fopen("sout","w");
	}

	refspk=(Spikeinfo *)calloc(MAXSPKS,sizeof(Spikeinfo));
	simspk=(Spikeinfo *)calloc(MAXSPKS,sizeof(Spikeinfo));

	for(i=0;i<NSUM;i++) sum[i]=sumsq[i]=0.0;
	
	/* Setting the max and min values for the spike peaks */
	if (autoest) {
		maxest = est_max(ref,nref);
		minest = est_min(ref,nref);
	} else {
		maxest = user_maxest;
		minest = user_minest;
	}
	thresh=(maxest+5*minest)/6.0;

	nrefspk=0;
	refspk[nrefspk].lo=0;
	refspk[nrefspk].tlo=reft[0];
	for(i=1;i<nref-2;i++) {
		if (ref[i-1]<thresh && ref[i]<=thresh && ref[i+1]>thresh && 
			ref[i+2]>thresh) {
			refspk[nrefspk].hi=i;
			refspk[nrefspk].thi=reft[i];
			nrefspk++;
		}
		if (ref[i-1]>thresh && ref[i]>=thresh && ref[i+1]<thresh && 
			ref[i+2]<thresh) {
			refspk[nrefspk].lo=i+1;
			refspk[nrefspk].tlo=reft[i+1];
		}
	}
	refspk[nrefspk].hi=nref-1;
	refspk[nrefspk].thi=reft[nref-1];
	nrefspk++;

	nsimspk=0;
	simspk[nsimspk].lo=0;
	simspk[nsimspk].tlo=simt[0];
	for(i=1;i<nsim-2;i++) {
		if (sim[i-1]<thresh && sim[i]<=thresh && sim[i+1]>thresh && 
			sim[i+2]>thresh) {
			simspk[nsimspk].hi=i;
			simspk[nsimspk].thi=simt[i];
			nsimspk++;
		}
		if (sim[i-1]>thresh && sim[i]>=thresh && sim[i+1]<thresh && 
			sim[i+2]<thresh) {
			simspk[nsimspk].lo=i+1;
			simspk[nsimspk].tlo=simt[i+1];
		}
	}
	simspk[nsimspk].hi=nsim-1;
	simspk[nsimspk].thi=simt[nsim-1];
	nsimspk++;

	nminspk=(nsimspk>nrefspk) ? nrefspk : nsimspk;

	k=1;
	m=1;
	t=0.0;
	for(i=0;i<nminspk;i++) {
		scalet=(simspk[i].thi-simspk[i].tlo)/
			(refspk[i].thi-refspk[i].tlo);
		for (;t<refspk[i].thi;t+=dt) {
			for(;t>reft[k] && k <nref;k++);
			ry=ref[k-1]+(ref[k]-ref[k-1])*
				(t-reft[k-1])/(reft[k]-reft[k-1]);
			st=simspk[i].tlo+(t-refspk[i].tlo)*scalet;
			for(;st>simt[m] && m <nsim;m++);
			sy=sim[m-1]+(sim[m]-sim[m-1])*
				(st-simt[m-1])/(simt[m]-simt[m-1]);
			
			if (plot_flag) {
				fprintf(rout,"%f	%f\n",t,ry);
				fprintf(sout,"%f	%f\n",t,sy);
			}
			sumsq[SS]+=(ry-sy)*(ry-sy);
		}
	}
	free(refspk);
	free(simspk);
	if (plot_flag) {
		fclose(rout);
		fclose(sout);
	}
}

#ifdef STANDALONE
int find_spike(arr,start,npts,maxest,maxwindow)
	float	*arr;
	int		start;
	int		npts;
	float	maxest;
	float	maxwindow;
{
	int i;
	float hi,lo;
	float y;

	hi=maxest+maxwindow;
	lo=maxest-maxwindow;

	if (start > MAXPTS - 3)
		return(0);

	for (i=start+2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y>arr[i-2] && y>arr[i-1] && y>=arr[i+1] && y>=arr[i+2])
				return(i);
		}
	}
	return(0);
}

find_max(est,window,arr,npts,mean,err)
	float est;
	float window;
	float *arr;
	int		npts;
	float *mean;
	float *err;
{
	int i;
	float hi,lo;
	float y;
	float sum=0.0,sumsq=0.0;
	float nsum=0.0;

	hi=est+window;
	lo=est-window;

	for (i=2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y>arr[i-2] && y>arr[i-1] && y>arr[i+1] && y>arr[i+2]){
				sum+=y;
				nsum+=1.0;
				sumsq+=y*y;
			}
		}
	}

	*mean = 0.0;
	*err = 0.0;

	if (nsum > 0.5) {
		sumsq=sumsq-sum*sum/nsum;
		if (sumsq>0)
			*err=sqrt(sumsq)/nsum;
		*mean=sum/nsum;
	} else {
		*mean = est;
		*err=0.0;
	}
}

find_min(est,window,arr,npts,mean,err)
	float est;
	float window;
	float *arr;
	int		npts;
	float *mean;
	float *err;
{
	int i;
	float hi,lo;
	float y;
	float sum=0.0,sumsq=0.0;
	float nsum=0.0;

	hi=est+window;
	lo=est-window;

	for (i=2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y<arr[i-2] && y<arr[i-1] && y<arr[i+1] && y<arr[i+2]){
				sum+=y;
				nsum+=1.0;
				sumsq+=y*y;
			}
		}
	}

	if (nsum > 0.5) {
		sumsq=sumsq-sum*sum/nsum;
		if (sumsq>0)
			*err=sqrt(sumsq)/nsum;
		*mean=sum/nsum;
	} else {
		*mean = est;
		*err=0.0;
	}
}

float est_max(arr,npts)
	float *arr;
	int		npts;
{
	int i;
	float max;

	if (npts <= 0)
		return(0.0);

	max = arr[0];

	for(i=1;i<npts;i++)
		if (max < arr[i])
			max = arr[i];
	return(max);
}

float est_min(arr,npts)
	float *arr;
	int		npts;
{
	int i;
	float min;

	if (npts <= 0)
		return(0.0);

	min = arr[0];

	for(i=1;i<npts;i++)
		if (min > arr[i])
			min = arr[i];
	return(min);
}

/* linterp does linear interpolatoon */
int linterp(xa,ya,n,x,y)
float *xa,*ya,x,*y;
int n;
{
	int klo,khi,k;
	float h,b,a;

	klo=0;
	/* khi=n-1; */
	khi=n;
	while (khi-klo > 1) {
		k=(khi+klo) >> 1;
		if (xa[k] > x) khi=k;
		else klo=k;
	}
	h=xa[khi]-xa[klo];
	if (h == 0.0) {
		printf("phooo! : Bad XA input to linterp in shapematch\n");
		return(0);
	}
	*y= ya[klo]+ (ya[khi]-ya[klo])*(x-xa[klo])/h;
	return(1);
}

#endif

#undef MAXPTS
#undef MAXSPKS
#undef MIN_SHAPE_SAMPLES

#undef SX
#undef SY
#undef SL
#undef SL2
#undef SH
#undef SH2
#undef SP
#undef SP2
#undef SS
#undef ST
#undef SW
#undef SN
#undef NPARMS

#undef SNSIMSPK
#undef SNREFSPK

#undef NSUM
