// LimitedTextField.m

#import <appkit/appkit.h>
#import <math.h>
#import "LimitedTextField.h"

@implementation LimitedTextField

- initFrame:(const NXRect *)frameRect
{
    if(![super initFrame:frameRect]) return nil;
    [self setEntryType:NX_DOUBLETYPE];
    [self setEntryBounds:-MAXDOUBLE :MAXDOUBLE];
    return self;
}

- setEntryType:(int)aType
{
    return [cell setEntryType:aType];
}

- setEntryBounds:(double)low :(double)high
{
    if(low > high) return nil;
    lowerBound = low; upperBound = high;
    return self;
}

- setEntryType:(int)aType withBounds:(double)low :(double)high
{
  if(low > high) return nil;
  lowerBound = low; upperBound = high;
  return  [cell setEntryType:aType];
}

- (BOOL)textWillEnd:textObject
{
    double val;
    
    // Let super check if number is of correct type (YES => error).
    if([super textWillEnd:textObject] == YES) return YES;
    
    // Then check if number within bounds.
    val = [self doubleValue];
    if(val>=lowerBound && val<=upperBound) return NO; // means OK
    else { NXBeep(); return YES; } // means error
}

@end
