
#import "MainPanelDel.h"
#import "GVApp.h"
#import "InspectorDel.h"
#import "ToolPanelDel.h"
#import <objc/HashTable.h>

#include "mg.h"
#include "drawer.h"
#include "ui.h"
#include "comm.h"
#include "event.h"
#include "motion.h"
#include "worldio.h"
#include "version.h"
#include "lang.h"

#include <strings.h>

static int menucount = 0;
static int *menuindex = NULL;

#define	COUNT(array)  (sizeof(array) / sizeof(array[0]))

static int id2menuindex(int id)
{
  int i;

  for (i=0; i<menucount; ++i)
    if (menuindex[i] == id) return i;
  return -1;
}

void DestroyObjectMenuList( char **menulist, int count )
{
  while ( --count >= 0 )
    OOGLFree(menulist[count]);
  OOGLFree(menulist);
  return;
}

@implementation MainPanelDel

- init
{
  [super init];
  [NXApp loadNibSection:"MainPanel.nib" owner:self withNames:NO];
  return self;
}

- awakeFromNib
{
  [NXApp makeKeyResponderFor:mainPanel];
  [mainPanel setBecomeKeyOnlyIfNeeded:YES];
  [objectButtons setAutosizeCells:YES];
  [lightButtons setAutosizeCells:YES];
  [[buttonBox setContentView:[objectButtons superview]] free];
  [buttonBox update];
  [externalBrowser loadColumnZero];
  [pickBrowser loadColumnZero];
  [self objectChange];
  return self;
}

- addLight:sender
{
  add_light();
  return self;
}

- deleteLight:sender
{
  /* don't delete ambient light ! */
  if (uistate.current_light == 0) return self;
  delete_light();
  return self;
}

- loadObject:sender
{
  [NXApp open:self];
  return self;
}

- saveObject:sender
{
  [NXApp save:self];
  return self;
}

- deleteObject:sender
{
  [NXApp deleteObj:self];
  return self;
}

- popUp:sender
{
  if((uistate.lights_shown==0)!=([[sender selectedCell] tag]==0)) {
    light_edit_mode([[sender selectedCell] tag]);
  }
  return self;
}

- lightEdit
{
  [pickBrowser loadColumnZero];
  if(uistate.lights_shown) {
    [[pickBrowser matrixInColumn:0] selectCellAt:uistate.current_light :0];
    [popUp setTitle:"Lights"];
    [buttonBox setContentView:[lightButtons superview]];
    [buttonBox update];
  }
  else {
    [[pickBrowser matrixInColumn:0] selectCellAt:id2menuindex(uistate.targetid) :0];
    [popUp setTitle:"Objects"];
    [buttonBox setContentView:[objectButtons superview]];
    [buttonBox update];
  }
  return self;
}

- display 
{
  struct panel *p = &panels[P_MAIN];
  if(p->x0>=0) [mainPanel moveTo:p->x0 :p->y0];
  p->x0 = -1;
  if(p->shown) [mainPanel orderFront:self];
  else [mainPanel close];
  return self;
}

- lightsChanged
{
  if(uistate.lights_shown) {
    [pickBrowser loadColumnZero]; 
    [[pickBrowser matrixInColumn:0] selectCellAt:uistate.current_light :0];
    [[NXApp toolPanelDel] setTargetField];
  }
  return self;
}

- buildBrowser:sender
{
  [sender loadColumnZero];
  return self;
}

- (int)selectedRow:sender
{
  int index, notused;
  id matrix=[sender matrixInColumn:0];
  [matrix getRow:&index andCol:&notused ofCell:[matrix selectedCell]];
  return index;	
}

- (int)browser:sender fillMatrix:theMatrix inColumn:(int)column
{
  int i;
  NXBrowserCell *bCell;
  if(sender==externalBrowser) {
    emodule *em;
    for(i=0,em=VVEC(uistate.emod,emodule);i<VVCOUNT(uistate.emod);i++, em++) {
      [theMatrix addRow];
      bCell=[theMatrix cellAt:i :0];
      [bCell setStringValue:em->name];
      [bCell setLoaded:YES];
      [bCell setLeaf:YES];
    }
    return VVCOUNT(uistate.emod);
  }
  else if(sender==pickBrowser) {
    if(uistate.lights_shown) {
      char buf[80];
      [theMatrix addRow];
      bCell=[theMatrix cellAt:0 :0];
      [bCell setStringValue:"[la] ambient"];
      [bCell setLoaded:YES];
      [bCell setLeaf:YES];
      for(i=1;i<light_count();i++) {
	[theMatrix addRow];
	bCell=[theMatrix cellAt:i :0];
	sprintf(buf, "[l%1d] light %1d", i,i);
	[bCell setStringValue:buf];
	[bCell setLoaded:YES];
	[bCell setLeaf:YES];
      }
      return light_count();
    }
  else {
      char **menulist;
      if (menuindex) OOGLFree(menuindex);
      [self buildObjectMenuList:&menulist :&menuindex :&menucount];
      for(i=0;i<menucount;i++) {
	[theMatrix addRow];
	bCell=[theMatrix cellAt:i :0];
	[bCell setStringValue:menulist[i]];
	[bCell setLoaded:YES];
	[bCell setLeaf:YES];
      }
      DestroyObjectMenuList(menulist, menucount);
      return menucount;
    }
  }
  return 0;
}	

- pickBrowser:sender
{
  int index=[self selectedRow:sender];

  if(uistate.lights_shown) {
    set_light( index );
    [[NXApp inspectorDel] lights];
    [[NXApp toolPanelDel] setTargetField];
  }
  else gv_ui_target( menuindex[index], IMMEDIATE );
  return self;
}

- externalBrowser:sender
{
  int i=[self selectedRow:sender];
  gv_ui_emodule_start( VVINDEX(uistate.emod, emodule, i)->name );
  return self;
}

- buildObjectMenuList:(char ***)menulist :(int **)menuindex :(int *)count
{
  register int i;
  int n, camcount;
  register DObject *obj, **objs;
  char buf[64];

  if ((camcount = drawer_cam_count()) > 1) {
    /* + 1 for "Current Camera" entry */
    *count = camcount + drawer_geom_count() + 1;     
  } else {
    /* don't have "Current Camera" if we only have 0 or 1 cameras */
    *count = camcount + drawer_geom_count();
  }

  *menulist = OOGLNewNE(char *, *count, "no space for menulist array");
  *menuindex = OOGLNewNE(int, *count, "no space for menuindex array");

  n = 0;
  objs = (DObject**)dgeom;
  for (i=0; i<dgeom_max; ++i) {
    if ( (obj=objs[i]) != NULL && ((DGeom*)obj)->citizenship != ALIEN) {
      if (obj->name[1] != NULL) 
	sprintf(buf, "[%s] %s", obj->name[0], obj->name[1]);
      else
	strcpy(buf, obj->name[0]);
      (*menuindex)[n] = obj->id;
      (*menulist)[n] = strdup(buf);
      ++n;
    }
  }
  if (camcount > 1) {
    (*menuindex)[n] = FOCUSID;
    (*menulist)[n] = strdup("[c] Current Camera");
    ++n;
  }
  objs = (DObject **)dview;
  for (i=0; i<dview_max; ++i) {
    if ( (obj=objs[i]) != NULL ) {
      if (obj->name[1] == NULL) obj->name[1] = "Default Camera";
      sprintf(buf, "[%s] %s", obj->name[0], obj->name[1]);
      (*menuindex)[n] = obj->id;
      (*menulist)[n] = strdup(buf);
      ++n;
    }
  }
  return self;
}

/*
- setKeyboardString:(char *)s
{
  [keyboard setStringValue:s];
  return self;
}
*/

- objectChange
{
  [pickBrowser loadColumnZero];
  [[pickBrowser matrixInColumn:0] selectCellAt: (uistate.lights_shown ? 
          uistate.current_light :id2menuindex(uistate.targetid)) :0];
  return self;
}

- buildExternalBrowser
{
  [externalBrowser loadColumnZero];
  return self;
}

- buildPickBrowser
{
  [pickBrowser loadColumnZero];
  return self;
}

- adjustPickBrowser:(int)oid
{
  [[pickBrowser matrixInColumn:0] selectCellAt:id2menuindex(oid) :0];
  return self;
}

- adjustExternalBrowser:(int)row
{
  [[externalBrowser matrixInColumn:0] selectCellAt:row :0];
  return self;
}

- close
{
  [mainPanel close];
  return self;
}

- window {return mainPanel;}
@end
