
#import "Sweep.h"

#include <stdio.h>
#include "geom.h"
#include "point3.h"
#include "sweep.h"

#define TRAN 0
#define ROT 1
#define RAD 0
#define DEG 1

@implementation Sweep

- appDidInit:sender
{
    [sweepWindow setAvoidsActivation:YES];

    cView = [sweepWindow contentView];

    [tranView getFrame:&boxFrame];
    return self;
}

- go:sender
{
  Geom *g, *s;
  Point3 pt1, pt2;

  printf("(write geometry - targetgeom bare)");
  fflush(stdout);
  g = GeomFLoad(stdin, NULL);

  if ([[tranRot selectedCell] tag]==ROT) {
    pt1.x = [rotEnd floatValueAt:0];
    pt1.y = [rotEnd floatValueAt:1];
    pt1.z = [rotEnd floatValueAt:2];
    pt2.x = [rotDir floatValueAt:0];
    pt2.y = [rotDir floatValueAt:1];
    pt2.z = [rotDir floatValueAt:2];
    s = RotationSweep([rotLength floatValue] * 
	(([[radDeg selectedCell] tag] == DEG) ? M_PI / 180.0 : 1.0), 
	&pt1, &pt2, 
	[rotDivisions intValue], g);
  } else {
    pt1.x = [transDir floatValueAt:0];
    pt1.y = [transDir floatValueAt:1];
    pt1.z = [transDir floatValueAt:2];
    s = TranslationSweep([transLength floatValue], &pt1, g);
  }

  if (s != NULL) {
    printf("(geometry sweep { ");
    GeomFSave(s, stdout, NULL);
    printf(" } ) ");
    fflush(stdout);
  }
  GeomDelete(g);
  GeomDelete(s);
		       
    return self;
}

- rotTran:sender
{
    if([[sender selectedCell] tag]==TRAN) {
	if([tranView superview]!=cView) {
	    [tranView removeFromSuperview];
	    [rotView removeFromSuperview];
	    [cView addSubview:tranView];
	    [tranView setFrame:&boxFrame];
	    [cView display];
	}
    }

    else if([[sender selectedCell] tag]==ROT) {
	if([rotView superview]!=cView) {
	    [tranView removeFromSuperview];
	    [rotView removeFromSuperview];
	    [cView addSubview:rotView];
	    [rotView setFrame:&boxFrame];
	    [cView display];
	}
    }

    return self;
}


@end
